/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchQueryParser {
    public String searchQuery;

    @NotNull
    public static List<String> split(@NotNull String name, @Nullable String query) {
        int end;
        if (name == null) {
            SearchQueryParser.$$$reportNull$$$0(0);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        if (query == null) {
            result2.add(name);
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                SearchQueryParser.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        int length = name.length();
        int queryLength = query.length();
        int index = 0;
        while ((end = StringUtil.indexOfIgnoreCase((String)name, (String)query, (int)index)) != -1) {
            result2.add(name.substring(index, end));
            index = end + queryLength;
            result2.add(name.substring(end, index));
        }
        if (index < length) {
            result2.add(name.substring(index));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SearchQueryParser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected static List<String> splitQuery(@NotNull String query) {
        if (query == null) {
            SearchQueryParser.$$$reportNull$$$0(3);
        }
        ArrayList<String> words = new ArrayList<String>();
        int length = query.length();
        int index = 0;
        block0: while (index < length) {
            char startCh;
            if ((startCh = query.charAt(index++)) == ' ') continue;
            if (startCh == '\"') {
                int end = query.indexOf(34, index);
                if (end == -1) break;
                words.add(query.substring(index, end));
                index = end + 1;
                continue;
            }
            int start2 = index - 1;
            while (index < length) {
                char nextCh;
                if ((nextCh = query.charAt(index++)) != ':' && nextCh != ' ' && index != length) continue;
                words.add(query.substring(start2, nextCh == ' ' ? index - 1 : index));
                continue block0;
            }
        }
        if (words.isEmpty() && length > 0) {
            words.add(query);
        }
        ArrayList<String> arrayList = words;
        if (arrayList == null) {
            SearchQueryParser.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    protected final void parse(@NotNull String query) {
        List<String> words;
        int size;
        if (query == null) {
            SearchQueryParser.$$$reportNull$$$0(5);
        }
        if ((size = (words = SearchQueryParser.splitQuery(query)).size()) == 0) {
            return;
        }
        if (size == 1) {
            this.addToSearchQuery(words.get(0));
            return;
        }
        int index = 0;
        while (index < size) {
            String name;
            if ((name = words.get(index++)).endsWith(":")) {
                if (index < size) {
                    boolean invert = name.startsWith("-");
                    name = name.substring(invert ? 1 : 0, name.length() - 1);
                    this.handleAttribute(name, words.get(index++), invert);
                    continue;
                }
                this.addToSearchQuery(query);
                return;
            }
            this.addToSearchQuery(name);
        }
    }

    protected void addToSearchQuery(@NotNull String query) {
        if (query == null) {
            SearchQueryParser.$$$reportNull$$$0(6);
        }
        this.searchQuery = this.searchQuery == null ? query : this.searchQuery + " " + query;
    }

    protected abstract void handleAttribute(@NotNull String var1, @NotNull String var2, boolean var3);

    @NotNull
    public static String getTagQuery(@NotNull String tag2) {
        if (tag2 == null) {
            SearchQueryParser.$$$reportNull$$$0(7);
        }
        String string = "tag:" + (tag2.indexOf(32) == -1 ? tag2 : StringUtil.wrapWithDoubleQuote((String)tag2));
        if (string == null) {
            SearchQueryParser.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String wrapAttribute(@NotNull String value) {
        if (value == null) {
            SearchQueryParser.$$$reportNull$$$0(9);
        }
        String string = StringUtil.containsAnyChar((String)value, (String)" ,:") ? StringUtil.wrapWithDoubleQuote((String)value) : value;
        if (string == null) {
            SearchQueryParser.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchQueryParser";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "splitQuery";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagQuery";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "splitQuery";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addToSearchQuery";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTagQuery";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InstalledWithVendor
    extends SearchQueryParser {
        public final Set<String> vendors;
        public boolean enabled;
        public boolean disabled;
        public boolean bundled;
        public boolean downloaded;
        public boolean invalid;
        public boolean needUpdate;
        public boolean attributes;

        public InstalledWithVendor(@NotNull String query) {
            if (query == null) {
                InstalledWithVendor.$$$reportNull$$$0(0);
            }
            this.vendors = new HashSet<String>();
            this.localParse(query);
        }

        private void localParse(@NotNull String query) {
            List<String> words;
            int size;
            if (query == null) {
                InstalledWithVendor.$$$reportNull$$$0(1);
            }
            if ((size = (words = InstalledWithVendor.splitQuery(query)).size()) == 0) {
                return;
            }
            int index = 0;
            while (index < size) {
                String name;
                if ((name = words.get(index++)).startsWith("/")) {
                    if (name.equals("/vendor:")) {
                        if (index < size) {
                            this.handleAttribute("vendor", words.get(index++), false);
                            continue;
                        }
                        this.addToSearchQuery(query);
                        break;
                    }
                    this.handleAttribute(name.substring(1), "", false);
                    continue;
                }
                this.addToSearchQuery(name);
            }
            this.attributes = this.enabled || this.disabled || this.bundled || this.downloaded || this.invalid || this.needUpdate;
        }

        @Override
        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert) {
            if (name == null) {
                InstalledWithVendor.$$$reportNull$$$0(2);
            }
            if (value == null) {
                InstalledWithVendor.$$$reportNull$$$0(3);
            }
            switch (name) {
                case "enabled": {
                    this.enabled = true;
                    break;
                }
                case "disabled": {
                    this.disabled = true;
                    break;
                }
                case "bundled": {
                    this.bundled = true;
                    break;
                }
                case "downloaded": {
                    this.downloaded = true;
                    break;
                }
                case "invalid": {
                    this.invalid = true;
                    break;
                }
                case "outdated": {
                    this.needUpdate = true;
                    break;
                }
                case "vendor": {
                    this.vendors.add(value);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$InstalledWithVendor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "localParse";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleAttribute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Installed
    extends SearchQueryParser {
        public Boolean enabled;
        public Boolean bundled;
        public Boolean invalid;
        public Boolean needUpdate;
        public Boolean deleted;
        public Boolean needRestart;
        public boolean attributes;

        public Installed(@NotNull String query) {
            if (query == null) {
                Installed.$$$reportNull$$$0(0);
            }
            this.localParse(query);
        }

        private void localParse(@NotNull String query) {
            if (query == null) {
                Installed.$$$reportNull$$$0(1);
            }
            for (String word : Installed.splitQuery(query)) {
                if (word.startsWith("#")) {
                    this.handleAttribute(word.substring(1), "", false);
                    continue;
                }
                if (word.startsWith("-#")) {
                    this.handleAttribute(word.substring(2), "", true);
                    continue;
                }
                this.addToSearchQuery(word);
            }
            this.attributes = this.enabled != null || this.bundled != null || this.invalid != null || this.needUpdate != null || this.deleted != null || this.needRestart != null;
        }

        @Override
        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert) {
            if (name == null) {
                Installed.$$$reportNull$$$0(2);
            }
            if (value == null) {
                Installed.$$$reportNull$$$0(3);
            }
            switch (name) {
                case "enabled": {
                    this.enabled = !invert;
                    break;
                }
                case "disabled": {
                    this.enabled = invert;
                    break;
                }
                case "bundled": {
                    this.bundled = !invert;
                    break;
                }
                case "custom": {
                    this.bundled = invert;
                    break;
                }
                case "invalid": {
                    this.invalid = !invert;
                    break;
                }
                case "outdated": {
                    this.needUpdate = !invert;
                    break;
                }
                case "uninstalled": {
                    this.deleted = !invert;
                    break;
                }
                case "inactive": {
                    this.needRestart = !invert;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$Installed";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "localParse";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleAttribute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Marketplace
    extends Trending {
        public final Set<String> vendors;

        public Marketplace(@NotNull String query) {
            if (query == null) {
                Marketplace.$$$reportNull$$$0(0);
            }
            this.vendors = new HashSet<String>();
            this.parse(query);
        }

        @Override
        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert) {
            if (name == null) {
                Marketplace.$$$reportNull$$$0(1);
            }
            if (value == null) {
                Marketplace.$$$reportNull$$$0(2);
            }
            if (name.equals("/vendor")) {
                this.vendors.add(value);
            } else if (name.startsWith("/")) {
                super.handleAttribute(name.substring(1), value, invert);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$Marketplace";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleAttribute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Trending
    extends SearchQueryParser {
        public final Set<String> tags;
        public final Set<String> repositories;
        public String sortBy;

        public Trending(@NotNull String query) {
            if (query == null) {
                Trending.$$$reportNull$$$0(0);
            }
            this.tags = new HashSet<String>();
            this.repositories = new HashSet<String>();
            this.parse(query);
        }

        protected Trending() {
            this.tags = new HashSet<String>();
            this.repositories = new HashSet<String>();
        }

        @NotNull
        public String getUrlQuery() {
            StringBuilder url = new StringBuilder();
            if ("featured".equals(this.sortBy)) {
                url.append("is_featured_search=true");
            } else if ("updated".equals(this.sortBy)) {
                url.append("orderBy=update+date");
            } else if ("downloads".equals(this.sortBy)) {
                url.append("orderBy=downloads");
            } else if ("rating".equals(this.sortBy)) {
                url.append("orderBy=rating");
            } else if ("name".equals(this.sortBy)) {
                url.append("orderBy=name");
            }
            for (String tag2 : this.tags) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("tags=").append(URLUtil.encodeURIComponent((String)tag2));
            }
            if (this.searchQuery != null) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("search=").append(URLUtil.encodeURIComponent((String)this.searchQuery));
            }
            String string = url.toString();
            if (string == null) {
                Trending.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert) {
            if (name == null) {
                Trending.$$$reportNull$$$0(2);
            }
            if (value == null) {
                Trending.$$$reportNull$$$0(3);
            }
            if (name.equals("tag")) {
                this.tags.add(value);
            } else if (name.equals("sortBy")) {
                this.sortBy = value;
            } else if (name.equals("repository")) {
                this.repositories.add(value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/newui/SearchQueryParser$Trending";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$Trending";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrlQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleAttribute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

