/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.tree.LeafState;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.NotNull;

public abstract class HierarchyTreeStructure
extends AbstractTreeStructure {
    protected HierarchyNodeDescriptor myBaseDescriptor;
    private HierarchyNodeDescriptor myRoot;
    @NotNull
    protected final Project myProject;

    protected HierarchyTreeStructure(@NotNull Project project, HierarchyNodeDescriptor baseDescriptor) {
        if (project == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        this.myBaseDescriptor = baseDescriptor;
        this.myProject = project;
        this.myRoot = baseDescriptor;
    }

    public final HierarchyNodeDescriptor getBaseDescriptor() {
        return this.myBaseDescriptor;
    }

    protected final void setBaseElement(@NotNull HierarchyNodeDescriptor baseElement) {
        if (baseElement == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        this.myBaseDescriptor = baseElement;
        this.myRoot = baseElement;
        while (this.myRoot.getParentDescriptor() != null) {
            this.myRoot = (HierarchyNodeDescriptor)this.myRoot.getParentDescriptor();
        }
    }

    @NotNull
    public final NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(2);
        }
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor hierarchyNodeDescriptor = (HierarchyNodeDescriptor)((Object)element);
            if (hierarchyNodeDescriptor == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(3);
            }
            return hierarchyNodeDescriptor;
        }
        if (element instanceof String) {
            TextInfoNodeDescriptor textInfoNodeDescriptor = new TextInfoNodeDescriptor(parentDescriptor, (String)element, this.myProject);
            if (textInfoNodeDescriptor == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(4);
            }
            return textInfoNodeDescriptor;
        }
        throw new IllegalArgumentException("Unknown element type: " + element);
    }

    public final boolean isToBuildChildrenInBackground(@NotNull Object element) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(5);
        }
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor descriptor2 = (HierarchyNodeDescriptor)((Object)element);
            Object[] cachedChildren = descriptor2.getCachedChildren();
            return cachedChildren == null && descriptor2.isValid();
        }
        return false;
    }

    @NotNull
    public final Object[] getChildElements(@NotNull Object element) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(6);
        }
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor descriptor2 = (HierarchyNodeDescriptor)((Object)element);
            Object[] cachedChildren = descriptor2.getCachedChildren();
            if (cachedChildren == null) {
                if (descriptor2.isValid()) {
                    try {
                        cachedChildren = (Object[])AbstractTreeUi.calculateYieldingToWriteAction(() -> this.buildChildren(descriptor2));
                    }
                    catch (IndexNotReadyException e) {
                        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                            HierarchyTreeStructure.$$$reportNull$$$0(7);
                        }
                        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                    }
                } else {
                    cachedChildren = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                }
                descriptor2.setCachedChildren(cachedChildren);
            }
            if (cachedChildren == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(8);
            }
            return cachedChildren;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(9);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public final Object getParentElement(@NotNull Object element) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(10);
        }
        if (element instanceof HierarchyNodeDescriptor) {
            return ((HierarchyNodeDescriptor)((Object)element)).getParentDescriptor();
        }
        return null;
    }

    public final void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    public final boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = HierarchyTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(11);
        }
        return actionCallback;
    }

    @NotNull
    protected abstract Object[] buildChildren(@NotNull HierarchyNodeDescriptor var1);

    @NotNull
    public final Object getRootElement() {
        HierarchyNodeDescriptor hierarchyNodeDescriptor = this.myRoot;
        if (hierarchyNodeDescriptor == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(12);
        }
        return hierarchyNodeDescriptor;
    }

    protected SearchScope getSearchScope(String scopeType, PsiElement thisClass) {
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.myProject);
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(scopeType)) {
            searchScope = new LocalSearchScope(thisClass);
        } else if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(scopeType)) {
            searchScope = GlobalSearchScopesCore.projectProductionScope((Project)this.myProject);
        } else if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(scopeType)) {
            searchScope = GlobalSearchScopesCore.projectTestScope((Project)this.myProject);
        } else {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)scopeType);
            if (namedScope != null) {
                searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)namedScope);
            }
        }
        return searchScope;
    }

    protected boolean isInScope(PsiElement baseClass, @NotNull PsiElement srcElement, String scopeType) {
        if (srcElement == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(13);
        }
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(scopeType)) {
            return PsiTreeUtil.isAncestor((PsiElement)baseClass, (PsiElement)srcElement, (boolean)true);
        }
        if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(scopeType)) {
            VirtualFile virtualFile = srcElement.getContainingFile().getVirtualFile();
            return virtualFile == null || !TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)this.myProject);
        }
        if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(scopeType)) {
            VirtualFile virtualFile = srcElement.getContainingFile().getVirtualFile();
            return virtualFile == null || TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)this.myProject);
        }
        if (HierarchyBrowserBaseEx.SCOPE_ALL.equals(scopeType)) {
            return true;
        }
        NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)scopeType);
        if (namedScope == null) {
            return false;
        }
        PackageSet namedScopePattern = namedScope.getValue();
        if (namedScopePattern == null) {
            return false;
        }
        PsiFile psiFile = srcElement.getContainingFile();
        if (psiFile == null) {
            return true;
        }
        NamedScopesHolder holder = NamedScopesHolder.getHolder((Project)this.myProject, (String)scopeType, (NamedScopesHolder)NamedScopeManager.getInstance((Project)this.myProject));
        return namedScopePattern.contains(psiFile, holder);
    }

    @NotNull
    public LeafState getLeafState(@NotNull Object element) {
        if (element == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(14);
        }
        if (this.isAlwaysShowPlus()) {
            LeafState leafState = LeafState.NEVER;
            if (leafState == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(15);
            }
            return leafState;
        }
        LeafState state = super.getLeafState(element);
        LeafState leafState = state != LeafState.DEFAULT ? state : LeafState.ASYNC;
        if (leafState == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(16);
        }
        return leafState;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    @NotNull
    protected String formatBaseElementText() {
        HierarchyNodeDescriptor descriptor2 = this.getBaseDescriptor();
        if (descriptor2 == null) {
            String string = ((Object)((Object)this)).toString();
            if (string == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(17);
            }
            return string;
        }
        PsiElement element = descriptor2.getPsiElement();
        if (element == null) {
            String string = descriptor2.toString();
            if (string == null) {
                HierarchyTreeStructure.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE) + " " + ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
        if (string == null) {
            HierarchyTreeStructure.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseElement";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyTreeStructure";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyTreeStructure";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncCommit";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafState";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "formatBaseElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setBaseElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isToBuildChildrenInBackground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLeafState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TextInfoNodeDescriptor
    extends NodeDescriptor {
        TextInfoNodeDescriptor(NodeDescriptor parentDescriptor, String text2, Project project) {
            super(project, parentDescriptor);
            this.myName = text2;
            this.myColor = JBColor.RED;
        }

        public final Object getElement() {
            return this.myName;
        }

        public final boolean update() {
            return true;
        }
    }
}

