/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.TransferableFileEditorStateSupport;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideBinaryDiffViewer
extends TwosideDiffViewer<BinaryEditorHolder> {
    @NotNull
    private final TransferableFileEditorStateSupport myTransferableStateSupport;
    @NotNull
    private final StatusPanel myStatusPanel;

    public TwosideBinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
        this.myStatusPanel = new StatusPanel();
        new MyFocusOppositePaneAction().install(this.myPanel);
        this.myContentPanel.setTopAction((AnAction)new MyAcceptSideAction(Side.LEFT));
        this.myContentPanel.setBottomAction((AnAction)new MyAcceptSideAction(Side.RIGHT));
        this.myTransferableStateSupport = new TransferableFileEditorStateSupport(DiffUtil.getDiffSettings(context), this.getEditorHolders(), (Disposable)this);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myTransferableStateSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myTransferableStateSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyAcceptSideAction(Side.LEFT));
        group.add((AnAction)new MyAcceptSideAction(Side.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.add(this.myTransferableStateSupport.createToggleAction());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        List contents;
        block8: {
            if (indicator == null) {
                TwosideBinaryDiffViewer.$$$reportNull$$$0(2);
            }
            indicator.checkCanceled();
            contents = this.myRequest.getContents();
            if (contents.get(0) instanceof FileContent && contents.get(1) instanceof FileContent) break block8;
            Runnable runnable3 = this.applyNotification(null);
            if (runnable3 == null) {
                TwosideBinaryDiffViewer.$$$reportNull$$$0(3);
            }
            return runnable3;
        }
        try {
            VirtualFile file1 = ((FileContent)contents.get(0)).getFile();
            VirtualFile file2 = ((FileContent)contents.get(1)).getFile();
            JComponent notification = (JComponent)ReadAction.compute(() -> {
                if (!file1.isValid() || !file2.isValid()) {
                    return DiffNotifications.createError();
                }
                if (FileUtilRt.isTooLarge((long)file1.getLength()) || FileUtilRt.isTooLarge((long)file2.getLength())) {
                    return DiffNotifications.createNotification("Files are too large to compare");
                }
                try {
                    byte[] bytes1 = file1.contentsToByteArray();
                    byte[] bytes2 = file2.contentsToByteArray();
                    return Arrays.equals(bytes1, bytes2) ? DiffNotifications.createEqualContents() : null;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    return null;
                }
            });
            runnable2 = this.applyNotification(notification);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = this.applyNotification(DiffNotifications.createError());
            if (runnable4 == null) {
                TwosideBinaryDiffViewer.$$$reportNull$$$0(5);
            }
            return runnable4;
        }
        if (runnable2 == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(4);
        }
        return runnable2;
    }

    @NotNull
    private Runnable applyNotification(@Nullable JComponent notification) {
        Runnable runnable2 = () -> {
            this.clearDiffPresentation();
            if (notification != null) {
                this.myPanel.addNotification(notification);
            }
        };
        if (runnable2 == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(6);
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
    }

    @NotNull
    FileEditor getCurrentEditor() {
        FileEditor fileEditor = ((BinaryEditorHolder)this.getCurrentEditorHolder()).getEditor();
        if (fileEditor == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(7);
        }
        return fileEditor;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(8);
        }
        return statusPanel;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(9);
        }
        if (request == null) {
            TwosideBinaryDiffViewer.$$$reportNull$$$0(10);
        }
        return TwosideDiffViewer.canShowRequest(context, request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "applyNotification";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        private MyFocusOppositePaneAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFocusOppositePaneAction.$$$reportNull$$$0(0);
            }
            TwosideBinaryDiffViewer.this.setCurrentSide(TwosideBinaryDiffViewer.this.getCurrentSide().other());
            DiffUtil.requestFocus(TwosideBinaryDiffViewer.this.getProject(), TwosideBinaryDiffViewer.this.getPreferredFocusedComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
        }
    }

    private class MyAcceptSideAction
    extends DumbAwareAction {
        @NotNull
        private final Side myBaseSide;

        MyAcceptSideAction(Side baseSide) {
            if (baseSide == null) {
                MyAcceptSideAction.$$$reportNull$$$0(0);
            }
            this.myBaseSide = baseSide;
            this.getTemplatePresentation().setText("Copy Content to " + (String)baseSide.select((Object)"Right", (Object)"Left"));
            this.getTemplatePresentation().setIcon((Icon)baseSide.select((Object)AllIcons.Vcs.Arrow_right, (Object)AllIcons.Vcs.Arrow_left));
            this.setShortcutSet(ActionManager.getInstance().getAction((String)baseSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAcceptSideAction.$$$reportNull$$$0(1);
            }
            VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            boolean enabled = baseFile != null && targetFile != null && targetFile.isWritable();
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAcceptSideAction.$$$reportNull$$$0(2);
            }
            VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            assert (baseFile != null && targetFile != null);
            try {
                WriteAction.run(() -> targetFile.setBinaryContent(baseFile.contentsToByteArray()));
            }
            catch (IOException err) {
                LOG.warn((Throwable)err);
                Messages.showErrorDialog((Project)TwosideBinaryDiffViewer.this.getProject(), (String)err.getMessage(), (String)"Can't Copy File");
            }
        }

        @Nullable
        private VirtualFile getContentFile(@NotNull Side side) {
            DiffContent content2;
            if (side == null) {
                MyAcceptSideAction.$$$reportNull$$$0(3);
            }
            VirtualFile file2 = (content2 = (DiffContent)side.select(TwosideBinaryDiffViewer.this.myRequest.getContents())) instanceof FileContent ? ((FileContent)content2).getFile() : null;
            return file2 != null && file2.isValid() ? file2 : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseSide";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer$MyAcceptSideAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContentFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

