/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.actions.AbstractPerformFixesTask;
import com.intellij.codeInspection.actions.CleanupInspectionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.SequentialModalProgressTask;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanupInspectionUtilImpl
implements CleanupInspectionUtil {
    private static final Logger LOG = Logger.getInstance(CleanupInspectionUtilImpl.class);

    @Override
    public AbstractPerformFixesTask applyFixesNoSort(@NotNull Project project, @NotNull String presentationText, @NotNull List<? extends ProblemDescriptor> descriptions, @Nullable Class quickfixClass, boolean startInWriteAction, boolean markGlobal) {
        if (project == null) {
            CleanupInspectionUtilImpl.$$$reportNull$$$0(0);
        }
        if (presentationText == null) {
            CleanupInspectionUtilImpl.$$$reportNull$$$0(1);
        }
        if (descriptions == null) {
            CleanupInspectionUtilImpl.$$$reportNull$$$0(2);
        }
        boolean isBatch = quickfixClass != null && BatchQuickFix.class.isAssignableFrom(quickfixClass);
        AbstractPerformFixesTask fixesTask = isBatch ? new PerformBatchFixesTask(project, (CommonProblemDescriptor[])descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY), quickfixClass) : new PerformFixesTask(project, (CommonProblemDescriptor[])descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY), quickfixClass);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (markGlobal) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            }
            if (quickfixClass != null && startInWriteAction) {
                ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(presentationText, project, null, (Consumer<? super ProgressIndicator>)((Consumer)fixesTask::doRun));
            } else {
                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, presentationText, true);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask(fixesTask);
                ProgressManager.getInstance().run((Task)progressTask);
            }
        }, presentationText, null);
        return fixesTask;
    }

    @Override
    public AbstractPerformFixesTask applyFixesNoSort(@NotNull Project project, @NotNull String presentationText, @NotNull List<? extends ProblemDescriptor> descriptions, @Nullable Class quickfixClass, boolean startInWriteAction) {
        if (project == null) {
            CleanupInspectionUtilImpl.$$$reportNull$$$0(3);
        }
        if (presentationText == null) {
            CleanupInspectionUtilImpl.$$$reportNull$$$0(4);
        }
        if (descriptions == null) {
            CleanupInspectionUtilImpl.$$$reportNull$$$0(5);
        }
        return this.applyFixesNoSort(project, presentationText, descriptions, quickfixClass, startInWriteAction, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "presentationText";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptions";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/actions/CleanupInspectionUtilImpl";
        objectArray[2] = "applyFixesNoSort";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PerformFixesTask
    extends AbstractPerformFixesTask {
        PerformFixesTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @Nullable Class quickFixClass) {
            if (project == null) {
                PerformFixesTask.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                PerformFixesTask.$$$reportNull$$$0(1);
            }
            super(project, descriptors, quickFixClass);
        }

        @Override
        protected void collectFix(QuickFix fix, ProblemDescriptor descriptor2, Project project) {
            fix.applyFix(project, (CommonProblemDescriptor)descriptor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/actions/CleanupInspectionUtilImpl$PerformFixesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PerformBatchFixesTask
    extends AbstractPerformFixesTask {
        private final List<ProblemDescriptor> myBatchModeDescriptors;
        private boolean myApplied;

        PerformBatchFixesTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Class quickfixClass) {
            if (project == null) {
                PerformBatchFixesTask.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                PerformBatchFixesTask.$$$reportNull$$$0(1);
            }
            if (quickfixClass == null) {
                PerformBatchFixesTask.$$$reportNull$$$0(2);
            }
            super(project, descriptors, quickfixClass);
            this.myBatchModeDescriptors = new ArrayList<ProblemDescriptor>();
            this.myApplied = false;
        }

        @Override
        protected void collectFix(QuickFix fix, ProblemDescriptor descriptor2, Project project) {
            this.myBatchModeDescriptors.add(descriptor2);
        }

        @Override
        public boolean isDone() {
            if (super.isDone()) {
                if (!this.myApplied && !this.myBatchModeDescriptors.isEmpty()) {
                    ProblemDescriptor representative = this.myBatchModeDescriptors.get(0);
                    LOG.assertTrue(representative.getFixes() != null);
                    for (QuickFix fix : representative.getFixes()) {
                        if (fix == null || !fix.getClass().isAssignableFrom(this.myQuickfixClass)) continue;
                        ((BatchQuickFix)fix).applyFix(this.myProject, (CommonProblemDescriptor[])this.myBatchModeDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY), new ArrayList(), null);
                        break;
                    }
                    this.myApplied = true;
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "quickfixClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/actions/CleanupInspectionUtilImpl$PerformBatchFixesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

