/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.StubFileElementType;
import java.util.List;

public abstract class SerializationManager {
    private volatile boolean mySerializersLoaded;

    public static SerializationManager getInstance() {
        return ApplicationManager.getApplication().getComponent(SerializationManager.class);
    }

    public void registerSerializer(ObjectStubSerializer serializer) {
        this.registerSerializer(serializer.getExternalId(), (Computable<ObjectStubSerializer>)new Computable.PredefinedValueComputable((Object)serializer));
    }

    protected abstract void registerSerializer(String var1, Computable<ObjectStubSerializer> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSerializers() {
        if (this.mySerializersLoaded) {
            return;
        }
        SerializationManager serializationManager = this;
        synchronized (serializationManager) {
            if (this.mySerializersLoaded) {
                return;
            }
            List<StubFieldAccessor> lazySerializers = IStubElementType.loadRegisteredStubElementTypes();
            IElementType[] stubElementTypes = IElementType.enumerate(type -> type instanceof StubSerializer);
            for (IElementType type2 : stubElementTypes) {
                if (type2 instanceof StubFileElementType && "psi.file".equals(((StubFileElementType)type2).getExternalId())) continue;
                this.registerSerializer((StubSerializer)((Object)type2));
            }
            for (StubFieldAccessor lazySerializer : lazySerializers) {
                this.registerSerializer(lazySerializer.externalId, lazySerializer);
            }
            this.mySerializersLoaded = true;
        }
    }

    public abstract String internString(String var1);
}

