/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.io.IOUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebConnectionIRIMapper
implements OWLOntologyIRIMapper {
    private static final int CONNECTION_TIMEOUT = 20000;
    private static final boolean CONNECTION_ACCEPT_HTTP_COMPRESSION = true;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String HEAD = "HEAD";
    private final Logger logger = LoggerFactory.getLogger(WebConnectionIRIMapper.class);

    public IRI getDocumentIRI(@Nonnull IRI ontologyIRI) {
        block7: {
            URI documentURI = ontologyIRI.toURI();
            try {
                URLConnection connection = IOUtils.getUrlConnection(documentURI, true, 20000);
                if (HTTP.equals(ontologyIRI.getScheme()) || HTTPS.equals(ontologyIRI.getScheme())) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
                    httpURLConnection.setRequestMethod(HEAD);
                    int responseCode = httpURLConnection.getResponseCode();
                    if (responseCode == 200 || responseCode == 302 || responseCode == 301) {
                        return ontologyIRI;
                    }
                    break block7;
                }
                InputStream is = connection.getInputStream();
                is.close();
                return ontologyIRI;
            }
            catch (MalformedURLException e) {
                this.logger.info("Imported ontology document IRI {} is malformed.", (Object)ontologyIRI);
            }
            catch (FileNotFoundException e) {
                this.logger.info("Imported ontology document {} does not exist on the Web (File Not Found).", (Object)ontologyIRI);
            }
            catch (UnknownHostException e) {
                String host = e.getMessage();
                this.logger.info("Imported ontology document {} could not be retrieved. Cannot connect to {} (Unknown Host).", (Object)ontologyIRI, (Object)host);
            }
            catch (IOException e) {
                this.logger.info("Imported ontology document {} could not be retrieved: {}", (Object)ontologyIRI, (Object)e.getMessage());
            }
        }
        return null;
    }
}

