# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class SynchronizedRenderWindows(Object):
    """
    SynchronizedRenderWindows - synchronizes render windows across
    processes.
    
    Superclass: Object
    
    SynchronizedRenderWindows is used to synchronize render windows
    across processes for parallel rendering.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSynchronizedRenderWindows, obj, update, **traits)
    
    parallel_rendering = tvtk_base.true_bool_trait(desc=\
        """
        Enable/Disable parallel rendering. Unless parallel_rendering is
        ON, no synchronization of RenderWindow::Render() calls between
        processes happens. ON by default.
        """
    )

    def _parallel_rendering_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParallelRendering,
                        self.parallel_rendering_)

    render_event_propagation = tvtk_base.true_bool_trait(desc=\
        """
        
        """
    )

    def _render_event_propagation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRenderEventPropagation,
                        self.render_event_propagation_)

    identifier = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        It's acceptable to have multiple instances on
        SynchronizedRenderWindows on each processes to synchronize
        different render windows. In that case there's no way to each of
        the SynchronizedRenderWindows instance to know how they
        correspond across processes. To enable that identification, a
        SynchronizedRenderWindows can be assigned a unique id. All
        SynchronizedRenderWindows across different processes that have
        the same id are "linked" together for synchronization. It's
        critical that the id is set before any rendering happens.
        """
    )

    def _identifier_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIdentifier,
                        self.identifier)

    def _get_parallel_controller(self):
        return wrap_vtk(self._vtk_obj.GetParallelController())
    def _set_parallel_controller(self, arg):
        old_val = self._get_parallel_controller()
        self._wrap_call(self._vtk_obj.SetParallelController,
                        deref_vtk(arg))
        self.trait_property_changed('parallel_controller', old_val, arg)
    parallel_controller = traits.Property(_get_parallel_controller, _set_parallel_controller, desc=\
        """
        Set the parallel message communicator. This is used to
        communicate among processes.
        """
    )

    def _get_render_window(self):
        return wrap_vtk(self._vtk_obj.GetRenderWindow())
    def _set_render_window(self, arg):
        old_val = self._get_render_window()
        self._wrap_call(self._vtk_obj.SetRenderWindow,
                        deref_vtk(arg))
        self.trait_property_changed('render_window', old_val, arg)
    render_window = traits.Property(_get_render_window, _set_render_window, desc=\
        """
        Set the render window to be synchronized by this
        SynchronizedRenderWindows instance. A
        SynchronizedRenderWindows can be used to synchronize exactly 1
        RenderWindow on each process.
        """
    )

    root_process_id = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the root-process id. This is required when the
        parallel_controller is a SocketController. Set to 0 by default
        (which will not work when using a SocketController but will
        work for MPIController).
        """
    )

    def _root_process_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRootProcessId,
                        self.root_process_id)

    def abort_render(self):
        """
        V.abort_render()
        C++: virtual void AbortRender()
        This method call be called while a render is in progress to abort
        the rendering. It should be called on the root node (or client).
        """
        ret = self._vtk_obj.AbortRender()
        return ret
        

    _updateable_traits_ = \
    (('parallel_rendering', 'GetParallelRendering'),
    ('render_event_propagation', 'GetRenderEventPropagation'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('identifier', 'GetIdentifier'), ('root_process_id',
    'GetRootProcessId'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'parallel_rendering',
    'render_event_propagation', 'identifier', 'root_process_id'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SynchronizedRenderWindows, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SynchronizedRenderWindows properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['parallel_rendering', 'render_event_propagation'], [],
            ['identifier', 'root_process_id']),
            title='Edit SynchronizedRenderWindows properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SynchronizedRenderWindows properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

