/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.BinaryFileDataReader;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.DataReader;
import opennlp.tools.ml.model.PlainTextFileDataReader;

public abstract class AbstractModelReader {
    protected int NUM_PREDS;
    protected DataReader dataReader;

    public AbstractModelReader(File f) throws IOException {
        InputStream input;
        String filename = f.getName();
        if (filename.endsWith(".gz")) {
            input = new GZIPInputStream(new FileInputStream(f));
            filename = filename.substring(0, filename.length() - 3);
        } else {
            input = new FileInputStream(f);
        }
        this.dataReader = filename.endsWith(".bin") ? new BinaryFileDataReader(input) : new PlainTextFileDataReader(input);
    }

    public AbstractModelReader(DataReader dataReader) {
        this.dataReader = dataReader;
    }

    public int readInt() throws IOException {
        return this.dataReader.readInt();
    }

    public double readDouble() throws IOException {
        return this.dataReader.readDouble();
    }

    public String readUTF() throws IOException {
        return this.dataReader.readUTF();
    }

    public AbstractModel getModel() throws IOException {
        this.checkModelType();
        return this.constructModel();
    }

    public abstract void checkModelType() throws IOException;

    public abstract AbstractModel constructModel() throws IOException;

    protected String[] getOutcomes() throws IOException {
        int numOutcomes = this.readInt();
        String[] outcomeLabels = new String[numOutcomes];
        for (int i = 0; i < numOutcomes; ++i) {
            outcomeLabels[i] = this.readUTF();
        }
        return outcomeLabels;
    }

    protected int[][] getOutcomePatterns() throws IOException {
        int numOCTypes = this.readInt();
        int[][] outcomePatterns = new int[numOCTypes][];
        for (int i = 0; i < numOCTypes; ++i) {
            StringTokenizer tok = new StringTokenizer(this.readUTF(), " ");
            int[] infoInts = new int[tok.countTokens()];
            int j = 0;
            while (tok.hasMoreTokens()) {
                infoInts[j] = Integer.parseInt(tok.nextToken());
                ++j;
            }
            outcomePatterns[i] = infoInts;
        }
        return outcomePatterns;
    }

    protected String[] getPredicates() throws IOException {
        this.NUM_PREDS = this.readInt();
        String[] predLabels = new String[this.NUM_PREDS];
        for (int i = 0; i < this.NUM_PREDS; ++i) {
            predLabels[i] = this.readUTF();
        }
        return predLabels;
    }

    protected Context[] getParameters(int[][] outcomePatterns) throws IOException {
        Context[] params = new Context[this.NUM_PREDS];
        int pid = 0;
        for (int i = 0; i < outcomePatterns.length; ++i) {
            int[] outcomePattern = new int[outcomePatterns[i].length - 1];
            System.arraycopy(outcomePatterns[i], 1, outcomePattern, 0, outcomePatterns[i].length - 1);
            for (int j = 0; j < outcomePatterns[i][0]; ++j) {
                double[] contextParameters = new double[outcomePatterns[i].length - 1];
                for (int k = 1; k < outcomePatterns[i].length; ++k) {
                    contextParameters[k - 1] = this.readDouble();
                }
                params[pid] = new Context(outcomePattern, contextParameters);
                ++pid;
            }
        }
        return params;
    }
}

