/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColOptionPaneUI;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;

public class FreeColDialog<T>
extends JDialog
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(FreeColDialog.class.getName());
    protected final FreeColClient freeColClient;
    protected boolean modal;
    protected List<ChoiceItem<T>> options;
    private JOptionPane pane;

    protected FreeColDialog(FreeColClient freeColClient, JFrame frame) {
        super(frame);
        this.freeColClient = freeColClient;
    }

    public FreeColDialog(FreeColClient freeColClient, JFrame frame, DialogType type, boolean modal, Object obj, ImageIcon icon, List<ChoiceItem<T>> options) {
        this(freeColClient, frame);
        this.initializeDialog(frame, type, modal, obj, icon, options);
    }

    private int selectDefault(List<ChoiceItem<T>> options) {
        int def = -1;
        int can = -1;
        int ok = -1;
        int i = 0;
        for (ChoiceItem<T> ci : options) {
            if (ci.isDefault()) {
                def = i;
            } else if (ci.isCancel()) {
                can = i;
            } else if (ci.isOK()) {
                ok = i;
            }
            ++i;
        }
        return def >= 0 ? def : (can >= 0 ? can : (ok >= 0 ? ok : options.size() - 1));
    }

    private Object[] selectOptions() {
        return this.options.stream().filter(ChoiceItem::isEnabled).toArray();
    }

    protected final void initializeDialog(JFrame frame, DialogType type, boolean modal, Object obj, ImageIcon icon, List<ChoiceItem<T>> options) {
        ChoiceItem<T> ci;
        this.modal = modal;
        this.options = options;
        int paneType = 3;
        switch (type) {
            case PLAIN: {
                paneType = -1;
                break;
            }
            case QUESTION: {
                paneType = 3;
            }
        }
        int def = this.selectDefault(options);
        ChoiceItem<T> choiceItem = ci = def >= 0 ? options.get(def) : null;
        if (obj instanceof StringTemplate) {
            obj = Utility.localizedTextArea((StringTemplate)obj);
        } else if (obj instanceof String) {
            obj = Utility.getDefaultTextArea((String)obj);
        }
        this.pane = new JOptionPane(obj, paneType, -1, icon, this.selectOptions(), ci);
        this.pane.setBorder(Utility.DIALOG_BORDER);
        this.pane.setOpaque(false);
        this.pane.setName("FreeColDialog");
        this.pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
        this.pane.addPropertyChangeListener(this);
        this.pane.setSize(this.pane.getPreferredSize());
        this.setComponentOrientation(this.pane.getComponentOrientation());
        Container contentPane = this.getContentPane();
        contentPane.add(this.pane);
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        this.setUndecorated(true);
        this.setModal(modal);
        FreeColDialog.setSubcomponentsNotOpaque(this.pane);
        try {
            this.pack();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Packing failure", e);
        }
        this.setLocationRelativeTo(frame);
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                if (!FreeColDialog.this.responded()) {
                    FreeColDialog.this.setValue(null);
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    FreeColDialog.this.pane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        this.addWindowListener(adapter);
        this.addWindowFocusListener(adapter);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                FreeColDialog.this.pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        this.addMouseListener(new MouseAdapter(){
            private Point loc;

            @Override
            public void mousePressed(MouseEvent e) {
                this.loc = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.loc == null) {
                    return;
                }
                Point now = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
                int dx = now.x - this.loc.x;
                int dy = now.y - this.loc.y;
                Point p = FreeColDialog.this.getLocation();
                FreeColDialog.this.setLocation(p.x + dx, p.y + dy);
                this.loc = null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSubcomponentsNotOpaque(JComponent j) {
        Object object = j.getTreeLock();
        synchronized (object) {
            FreeColDialog.iterateOverOpaqueLayersComponents(j);
        }
    }

    private static void iterateOverOpaqueLayersComponents(JComponent j) {
        if (j instanceof JPanel || j instanceof JOptionPane) {
            Component[] componentes;
            for (Component componente : componentes = j.getComponents()) {
                FreeColDialog.setOpaqueLayerRecursive(componente);
            }
        }
    }

    private static void setOpaqueLayerRecursive(Component opaqueComponent) {
        if (opaqueComponent instanceof JTextArea || opaqueComponent instanceof JLabel) {
            if (opaqueComponent.isOpaque()) {
                ((JComponent)opaqueComponent).setOpaque(false);
            }
        } else if (opaqueComponent instanceof JPanel) {
            JComponent panel = (JComponent)opaqueComponent;
            if (panel.isOpaque()) {
                panel.setOpaque(false);
            }
            FreeColDialog.iterateOverOpaqueLayersComponents(panel);
        }
    }

    protected FreeColClient getFreeColClient() {
        return this.freeColClient;
    }

    protected SwingGUI getGUI() {
        return (SwingGUI)this.freeColClient.getGUI();
    }

    protected InGameController igc() {
        return this.freeColClient.getInGameController();
    }

    protected ImageLibrary getImageLibrary() {
        return this.getGUI().getImageLibrary();
    }

    protected Game getGame() {
        return this.freeColClient.getGame();
    }

    protected Specification getSpecification() {
        return this.getGame().getSpecification();
    }

    protected Player getMyPlayer() {
        return this.freeColClient.getMyPlayer();
    }

    protected Object getValue() {
        Object value = this.pane.getValue();
        this.dispose();
        return value;
    }

    protected synchronized void setValue(Object value) {
        this.pane.setValue(value);
    }

    public synchronized boolean responded() {
        return this.pane != null && this.pane.getValue() != JOptionPane.UNINITIALIZED_VALUE;
    }

    public T getResponse() {
        if (this.responded()) {
            Object value = this.getValue();
            for (ChoiceItem<T> ci : this.options) {
                if (!ci.equals(value)) continue;
                return ci.getObject();
            }
        }
        return null;
    }

    @Override
    public boolean isModal() {
        return this.modal;
    }

    public static <T> List<ChoiceItem<T>> choices() {
        return new ArrayList<ChoiceItem<T>>();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.isVisible() && e.getSource() == this.pane && ("value".equals(e.getPropertyName()) || "inputValue".equals(e.getPropertyName())) && e.getNewValue() != null && e.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
            this.setVisible(false);
        }
    }

    @Override
    public void setVisible(boolean val) {
        if (val) {
            this.pane.selectInitialValue();
        }
        super.setVisible(val);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.getGUI().dialogRemove(this);
        this.removeAll();
        if (this.pane != null) {
            this.pane.removePropertyChangeListener(this);
            this.pane = null;
        }
        for (MouseListener listener : this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
    }

    @Override
    public void requestFocus() {
        Component c;
        if (this.pane != null && this.pane.getUI() instanceof FreeColOptionPaneUI && (c = ((FreeColOptionPaneUI)this.pane.getUI()).getInitialFocusComponent()) != null) {
            c.requestFocus();
        }
    }

    public static enum DialogType {
        PLAIN,
        QUESTION;

    }
}

