/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class ServerPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (expectedValue instanceof String) {
            return ServerPropertyTester.checkProperty(receiver, property, (String)expectedValue);
        }
        if (expectedValue != null) {
            return ServerPropertyTester.checkProperty(receiver, property, expectedValue.toString());
        }
        return ServerPropertyTester.checkProperty(receiver, property, null);
    }

    protected static boolean checkProperty(Object target, String property, String value) {
        if ("isRunnable".equals(property)) {
            IFileEditorInput fei;
            IFile file;
            IModule m;
            if (target instanceof IProject && (m = ServerUtil.getModule((IProject)((IProject)target))) == null) {
                return false;
            }
            boolean b = ServerPlugin.hasModuleArtifact((Object)target);
            if (b) {
                return true;
            }
            return target instanceof IFileEditorInput && (b = ServerPlugin.hasModuleArtifact((Object)(file = (fei = (IFileEditorInput)target).getFile())));
        }
        if ("serverType".equals(property)) {
            IServer server = null;
            if (target instanceof IServer) {
                server = (IServer)target;
            } else if (target instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)target;
                server = ms.server;
            }
            if (server == null || server.getServerType() == null) {
                return false;
            }
            String[] typeIds = ServerPlugin.tokenize((String)value, (String)",");
            return ServerPropertyTester.matches(server.getServerType().getId(), typeIds);
        }
        if ("moduleType".equals(property)) {
            IModule[] module = null;
            if (target instanceof IModule[]) {
                module = (IModule[])target;
            } else if (target instanceof IModule) {
                module = new IModule[]{(IModule)target};
            } else if (target instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)target;
                module = ms.module;
            }
            if (module == null) {
                return false;
            }
            if (module.length == 0) {
                return false;
            }
            String[] values = ServerPlugin.tokenize((String)value, (String)",");
            IModule m = module[module.length - 1];
            return ServerPropertyTester.matches(m.getModuleType().getId(), values);
        }
        if ("moduleVersion".equals(property)) {
            IModule[] module = null;
            if (target instanceof IModule[]) {
                module = (IModule[])target;
            } else if (target instanceof IModule) {
                module = new IModule[]{(IModule)target};
            } else if (target instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)target;
                module = ms.module;
            }
            if (module == null) {
                return false;
            }
            if (module.length == 0) {
                return false;
            }
            String[] values = ServerPlugin.tokenize((String)value, (String)",");
            IModule m = module[module.length - 1];
            return ServerPropertyTester.matches(m.getModuleType().getVersion(), values);
        }
        return false;
    }

    protected static boolean matches(String id, String[] typeIds) {
        if (id == null || id.length() == 0) {
            return false;
        }
        if (typeIds == null) {
            return false;
        }
        int size = typeIds.length;
        int i = 0;
        while (i < size) {
            if (typeIds[i].endsWith("*") ? id.length() >= typeIds[i].length() && id.startsWith(typeIds[i].substring(0, typeIds[i].length() - 1)) : id.equals(typeIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

