/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.model;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.datatools.sqltools.debugger.breakpoint.ISPBreakpoint;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugElement;
import org.eclipse.datatools.sqltools.debugger.model.SPThread;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;

public class SPDebugTarget
extends SPDebugElement
implements IDebugTarget,
ILaunchListener {
    IProcess _process;
    ILaunch _launch;
    SPThread _thread;
    boolean _terminated;
    boolean _terminating;
    boolean _disconnected;
    int _suspendCount = 0;
    String _name;

    public SPDebugTarget(ILaunch launch, IProcess process, String name) {
        super(null);
        this._launch = launch;
        this._process = process;
        this._name = name;
        this.setDebugTarget(this);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public void setSPThread(SPThread thread) {
        this._thread = thread;
    }

    protected void cleanup() {
        if (this._thread != null) {
            this._thread.cleanup();
        }
        this._thread = null;
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
    }

    public IProcess getProcess() {
        return this._process;
    }

    @Override
    public ILaunch getLaunch() {
        return this._launch;
    }

    public IThread[] getThreads() {
        if (this._thread == null) {
            return new IThread[0];
        }
        return new IThread[]{this._thread};
    }

    public SPThread getSPThread() {
        return this._thread;
    }

    public boolean hasThreads() throws DebugException {
        return this._thread != null;
    }

    public String getName() throws DebugException {
        return this._name;
    }

    public boolean canResume() {
        return this._thread != null && this._thread.canResume();
    }

    public boolean canSuspend() {
        return this._thread != null && this._thread.canSuspend();
    }

    public boolean isSuspended() {
        return this._thread != null && this._thread.isSuspended();
    }

    public void resume() throws DebugException {
        if (this._thread == null) {
            return;
        }
        this._thread.resume();
    }

    public void suspend() throws DebugException {
        if (this._thread == null) {
            return;
        }
        this._thread.suspend();
    }

    public boolean canTerminate() {
        return this._thread != null && this._thread.canTerminate();
    }

    public boolean isTerminated() {
        return this._thread == null || this._thread.isTerminated();
    }

    public void terminated() {
        this._terminating = false;
        this._terminated = true;
        this._disconnected = true;
        this.cleanup();
        this.fireTerminateEvent();
    }

    public void disconnected() {
        this._terminating = false;
        if (!this.isDisconnected()) {
            this._terminated = true;
            this._disconnected = true;
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    public void terminate() throws DebugException {
        if (this._thread != null) {
            this._thread.terminate();
        }
    }

    public boolean canDisconnect() {
        return this._thread != null && this._thread.canDisconnect();
    }

    public void disconnect() throws DebugException {
        if (this._thread != null) {
            this._thread.disconnect();
        }
    }

    public boolean isDisconnected() {
        return this._disconnected;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof ISPBreakpoint;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        this.notSupported();
        return null;
    }

    public int getSuspendCount() {
        return this._suspendCount;
    }

    public synchronized void internalIncreaseSuspendCount() {
        ++this._suspendCount;
    }

    public void launchRemoved(ILaunch launch) {
        if (this._thread != null && launch.equals(this.getLaunch())) {
            try {
                this.disconnect();
            }
            catch (DebugException ex) {
                DebuggerCorePlugin.getDefault().log(ex);
            }
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }
}

