/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.analysis.callsite;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.StateSystemStringInterner;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCallsiteAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfDeviceAspect;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CallsiteStateProvider
extends AbstractTmfStateProvider {
    public static final String ID = "org.eclipse.tracecompass.tmf.core.analysis.callsite";
    public static final String DEVICES = "Devices";
    public static final String FILES = "Files";
    public static final String LINES = "Lines";
    public static final int UNKNOWN_LINE_NO = -1;
    public static final Iterable<String> DEFAULT_CATEGORY = Arrays.asList("UNKNOWN");
    public static final String STRING_POOL = "Sources";
    private int fSourceQuark = -2;
    private int fDevicesQuark = -2;
    private final StateSystemStringInterner fInterner;

    public CallsiteStateProvider(ITmfTrace trace, String id, StateSystemStringInterner interner) {
        super(trace, id);
        this.fInterner = interner;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    protected void eventHandle(@NonNull ITmfEvent event) {
        ITmfTrace trace = event.getTrace();
        Iterable<ITmfEventAspect<?>> csAspects = TmfTraceUtils.getEventAspects(trace, TmfCallsiteAspect.class);
        if (!Iterables.isEmpty(csAspects)) {
            int devicesQuark;
            ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
            if (ssb == null) {
                return;
            }
            int sourceQuark = this.fSourceQuark;
            if (sourceQuark == -2) {
                this.fSourceQuark = sourceQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{STRING_POOL});
            }
            if ((devicesQuark = this.fDevicesQuark) == -2) {
                this.fDevicesQuark = devicesQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{DEVICES});
            }
            String deviceId = null;
            String deviceType = null;
            for (ITmfEventAspect<?> aspect : trace.getEventAspects()) {
                TmfDeviceAspect tmfDeviceAspect;
                Object result;
                if (!(aspect instanceof TmfDeviceAspect) || (result = (tmfDeviceAspect = (TmfDeviceAspect)aspect).resolve(event)) == null) continue;
                deviceId = result.toString();
                deviceType = tmfDeviceAspect.getDeviceType();
                break;
            }
            if (deviceId == null) {
                return;
            }
            List<String> path = Arrays.asList(String.valueOf(trace.getUUID()), deviceType, deviceId);
            List callsites = null;
            for (ITmfEventAspect iTmfEventAspect : csAspects) {
                Object result = iTmfEventAspect.resolve(event);
                if (!(result instanceof List)) continue;
                callsites = (List)result;
                break;
            }
            if (callsites != null && !callsites.isEmpty()) {
                int n = ssb.getQuarkRelativeAndAdd(devicesQuark, (String[])Iterables.toArray(path, String.class));
                int filesQuark = ssb.getQuarkRelativeAndAdd(n, new String[]{FILES});
                int linesQuark = ssb.getQuarkRelativeAndAdd(n, new String[]{LINES});
                long time = event.getTimestamp().toNanos();
                try {
                    Integer nextLine;
                    Integer prevFile = (Integer)ssb.queryOngoing(filesQuark);
                    ssb.modifyAttribute(time, (Object)((int)(this.fInterner.intern(ssb, ((ITmfCallsite)callsites.get(0)).getFileName(), sourceQuark) - ssb.getStartTime())), filesQuark);
                    Integer nextFile = (Integer)ssb.queryOngoing(filesQuark);
                    Long lineNo = ((ITmfCallsite)callsites.get(0)).getLineNo();
                    Integer prevLine = (Integer)ssb.queryOngoing(filesQuark);
                    Integer n2 = nextLine = lineNo == null ? null : Integer.valueOf(lineNo.intValue());
                    if (Objects.equal((Object)prevLine, (Object)nextLine) && Objects.equal((Object)prevFile, (Object)nextFile)) {
                        ssb.modifyAttribute(time, null, linesQuark);
                    }
                    ssb.modifyAttribute(time, (Object)nextLine, linesQuark);
                }
                catch (IndexOutOfBoundsException | StateValueTypeException | TimeRangeException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public @NonNull ITmfStateProvider getNewInstance() {
        return new CallsiteStateProvider(this.getTrace(), ID, new StateSystemStringInterner());
    }
}

