/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.questionnaire;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.oomph.setup.ui.questionnaire.QuestionnairePlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AnimatedCanvas
extends Canvas {
    private static final int DEFAULT_TIMER_INTERVAL = 10;
    private final Runnable runnable = new Runnable(){

        public void run() {
            AnimatedCanvas.this.doRun();
        }
    };
    private final List<Animator> animators = new ArrayList<Animator>();
    private int timerInterval;
    private Point shellMoveStart;

    public AnimatedCanvas(Composite parent, int style) {
        this(parent, style, 10);
    }

    public AnimatedCanvas(Composite parent, int style, int timerInterval) {
        super(parent, style | 0x20000000);
        Display display = this.getDisplay();
        this.setBackground(display.getSystemColor(1));
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AnimatedCanvas.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                AnimatedCanvas.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                AnimatedCanvas.this.doPaint(event.gc);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!AnimatedCanvas.this.onKeyPressed(e)) {
                    super.keyPressed(e);
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                AnimatedCanvas.this.onMouseMove(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                AnimatedCanvas.this.onMouseMove(e.x, e.y);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    AnimatedCanvas.this.onMouseDown(e.x, e.y);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (AnimatedCanvas.this.shellMoveStart != null) {
                    AnimatedCanvas.this.shellMoveStart = null;
                }
            }
        });
        display.timerExec(timerInterval, this.runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Animator[] getAnimators() {
        List<Animator> list = this.animators;
        synchronized (list) {
            return this.animators.toArray(new Animator[this.animators.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAnimator(Animator animator) {
        List<Animator> list = this.animators;
        synchronized (list) {
            animator.canvas = this;
            animator.init();
            this.animators.add(animator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAnimator(Animator animator) {
        List<Animator> list = this.animators;
        synchronized (list) {
            this.animators.remove(animator);
            animator.dispose();
            animator.canvas = null;
        }
    }

    public final int getTimerInterval() {
        return this.timerInterval;
    }

    public final void setTimerInterval(int timerInterval) {
        this.timerInterval = timerInterval;
    }

    public void cover(GC gc, int alpha) {
        gc.setBackground(this.getDisplay().getSystemColor(1));
        gc.setAlpha(alpha);
        gc.fillRectangle(this.getBounds());
        gc.setAlpha(255);
    }

    public synchronized void dispose() {
        this.getDisplay().timerExec(-1, this.runnable);
        Animator[] animatorArray = this.getAnimators();
        int n = animatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Animator animator = animatorArray[n2];
            animator.dispose();
            ++n2;
        }
        super.dispose();
    }

    protected boolean onKeyPressed(KeyEvent e) {
        Animator[] animators = this.getAnimators();
        int i = animators.length - 1;
        while (i >= 0) {
            Animator animator = animators[i];
            if (animator.onKeyPressed(e)) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected void onMouseMove(int x, int y) {
        if (this.shellMoveStart != null) {
            Shell shell = this.getShell();
            Point location = shell.getLocation();
            location.x += x - this.shellMoveStart.x;
            location.y += y - this.shellMoveStart.y;
            shell.setLocation(location);
        }
        Animator[] animators = this.getAnimators();
        int i = animators.length - 1;
        while (i >= 0) {
            Animator animator = animators[i];
            if (animator.onMouseMove(x, y)) {
                return;
            }
            --i;
        }
    }

    protected void onMouseDown(int x, int y) {
        Animator[] animators = this.getAnimators();
        int i = animators.length - 1;
        while (i >= 0) {
            Animator animator = animators[i];
            if (animator.onMouseDown(x, y)) {
                return;
            }
            --i;
        }
        this.shellMoveStart = new Point(x, y);
    }

    protected synchronized void doRun() {
        if (this.isDisposed()) {
            return;
        }
        boolean needsRedraw = false;
        Animator[] animatorArray = this.getAnimators();
        int n = animatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Animator animator = animatorArray[n2];
            if (animator.advance()) {
                needsRedraw = true;
            }
            ++n2;
        }
        if (needsRedraw) {
            this.redraw();
        } else {
            this.scheduleRun();
        }
    }

    protected void doPaint(GC canvasGC) {
        Image buffer = new Image((Device)this.getDisplay(), this.getBounds());
        GC bufferGC = new GC((Drawable)buffer);
        bufferGC.setAdvanced(true);
        bufferGC.setBackground(canvasGC.getBackground());
        bufferGC.fillRectangle(buffer.getBounds());
        Animator[] animatorArray = this.getAnimators();
        int n = animatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Animator animator = animatorArray[n2];
            bufferGC.setTextAntialias(1);
            animator.paint(bufferGC, buffer);
            ++n2;
        }
        canvasGC.drawImage(buffer, 0, 0);
        bufferGC.dispose();
        buffer.dispose();
        if (!this.isFocusControl()) {
            this.cover(canvasGC, 200);
        }
        this.scheduleRun();
    }

    private void scheduleRun() {
        this.getDisplay().timerExec(this.timerInterval, this.runnable);
    }

    public static abstract class Animator {
        private final List<Resource> resources = new ArrayList<Resource>();
        private final Display display;
        private AnimatedCanvas canvas;
        private int width;
        private int height;
        private Font baseFont;

        public Animator(Display display) {
            this.display = display;
        }

        public final Display getDisplay() {
            return this.display;
        }

        public final AnimatedCanvas getCanvas() {
            return this.canvas;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final Font getBaseFont() {
            return this.baseFont;
        }

        protected void init() {
            Font initialFont = this.getCanvas().getFont();
            FontData[] fontData = initialFont.getFontData();
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setHeight(16);
                fontData[i].setStyle(1);
                ++i;
            }
            this.baseFont = new Font((Device)this.display, fontData);
        }

        protected void dispose() {
            UIUtil.dispose((Resource[])this.resources.toArray(new Resource[this.resources.size()]));
        }

        protected final Image loadImage(String name) {
            Image image;
            Display display = this.getDisplay();
            String path = "images/" + name;
            if (QuestionnairePlugin.INSTANCE.isOSGiRunning()) {
                InputStream stream = null;
                try {
                    OomphPlugin.BundleFile rootFile = QuestionnairePlugin.INSTANCE.getRootFile();
                    OomphPlugin.BundleFile file = rootFile.getChild(path);
                    if (file == null) {
                        throw new IllegalStateException("Couldn't load " + path);
                    }
                    stream = file.getContents();
                    image = new Image((Device)display, stream);
                }
                catch (Throwable throwable) {
                    IOUtil.close(stream);
                    throw throwable;
                }
                IOUtil.close((Closeable)stream);
            } else {
                image = new Image((Device)display, path);
            }
            this.resources.add((Resource)image);
            return image;
        }

        protected final Color createColor(int r, int g, int b) {
            Display display = this.getDisplay();
            Color color = new Color((Device)display, r, g, b);
            this.resources.add((Resource)color);
            return color;
        }

        protected final Font createFont(int pixelHeight) {
            return this.createFont(pixelHeight, 0, new String[0]);
        }

        protected final Font createFont(int pixelHeight, int pixelWidth, String ... testStrings) {
            if (testStrings.length == 0) {
                pixelWidth = Integer.MAX_VALUE;
                testStrings = new String[]{"Ag"};
            }
            Display display = this.getDisplay();
            GC fontGC = new GC((Drawable)display);
            try {
                FontData[] fontData = this.baseFont.getFontData();
                int fontSize = 40;
                while (fontSize > 0) {
                    int i = 0;
                    while (i < fontData.length) {
                        fontData[i].setHeight(fontSize);
                        fontData[i].setStyle(1);
                        ++i;
                    }
                    Font font = new Font((Device)display, fontData);
                    fontGC.setFont(font);
                    if (this.isFontSmallEnough(pixelHeight, pixelWidth, fontGC, testStrings)) {
                        this.resources.add((Resource)font);
                        Font font2 = font;
                        return font2;
                    }
                    font.dispose();
                    --fontSize;
                }
                throw new RuntimeException("Could not create font: " + pixelHeight);
            }
            finally {
                fontGC.dispose();
            }
        }

        private boolean isFontSmallEnough(int pixelHeight, int pixelWidth, GC fontGC, String[] testStrings) {
            String[] stringArray = testStrings;
            int n = testStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String testString = stringArray[n2];
                Point extent = fontGC.stringExtent(testString);
                if (extent.y > pixelHeight || extent.x > pixelWidth) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        protected final void setSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        protected boolean onKeyPressed(KeyEvent e) {
            return false;
        }

        protected boolean onMouseMove(int x, int y) {
            return false;
        }

        protected boolean onMouseDown(int x, int y) {
            return false;
        }

        protected abstract boolean advance();

        protected abstract void paint(GC var1, Image var2);

        public static Rectangle drawText(GC gc, double cX, double cY, String text) {
            return Animator.drawText(gc, cX, cY, text, 0);
        }

        public static Rectangle drawText(GC gc, double cX, double cY, String text, int box) {
            Point extent = gc.stringExtent(text);
            int x = (int)(cX - (double)(extent.x / 2));
            int y = (int)(cY - (double)(extent.y / 2));
            if (x < box) {
                x = box;
            }
            Rectangle rectangle = new Rectangle(x, y, extent.x, extent.y);
            if (box > 0) {
                rectangle.x -= box;
                rectangle.y -= box;
                rectangle.width += 2 * box;
                rectangle.height += 2 * box;
                gc.fillRectangle(rectangle);
            }
            gc.drawText(text, x, y, true);
            return rectangle;
        }

        public static Rectangle drawImage(GC gc, Image image, int cX, int cY) {
            Rectangle bounds = image.getBounds();
            gc.drawImage(image, cX -= bounds.width / 2, cY -= bounds.height / 2);
            return new Rectangle(cX, cY, bounds.width, bounds.height);
        }
    }
}

