/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.coode.mdock.Node;
import org.coode.mdock.Splitter;

public abstract class SplitterNode
extends Node {
    private List<Node> children;
    private Map<Node, Double> nodeSplits;
    private List<Splitter> splitters;
    public static final int HORIZONTAL_SPLITTER = 0;
    public static final int VERTICAL_SPLITTER = 1;

    public SplitterNode(List<? extends Node> children, List<Double> splits) {
        if (children.size() != splits.size()) {
            throw new IllegalArgumentException("The number of splits must correspond to the number of children");
        }
        this.children = new ArrayList<Node>(children);
        this.nodeSplits = new IdentityHashMap<Node, Double>();
        int index = 0;
        for (Node node : children) {
            node.setParent(this);
            this.nodeSplits.put(node, splits.get(index));
            ++index;
        }
        this.createSplitters();
    }

    public double getSplit(Node node) {
        return this.nodeSplits.get(node);
    }

    public List<Double> getSplits() {
        ArrayList<Double> splits = new ArrayList<Double>();
        for (Node curNode : this.getVisibleChildren()) {
            splits.add(this.nodeSplits.get(curNode));
        }
        return splits;
    }

    public void setSplit(Node node, double split) {
        this.nodeSplits.put(node, split);
    }

    public double getNormalisedSplit(Node node) {
        double split = this.nodeSplits.get(node);
        return split / this.getChildSpan();
    }

    public double getChildSpan() {
        double span = 0.0;
        for (Node node : this.getVisibleChildren()) {
            span += this.nodeSplits.get(node).doubleValue();
        }
        return span;
    }

    public List<Node> getVisibleChildren() {
        ArrayList<Node> visibleChildren = new ArrayList<Node>();
        for (Node curChild : this.children) {
            if (!curChild.isVisible()) continue;
            visibleChildren.add(curChild);
        }
        return visibleChildren;
    }

    @Override
    public boolean isVisible() {
        for (Node node : this.children) {
            if (!node.isVisible()) continue;
            return true;
        }
        return false;
    }

    private void createSplitters() {
        this.splitters = new ArrayList<Splitter>();
        this.splitters.clear();
        List<Node> visibleChildren = this.getVisibleChildren();
        for (int i = 0; i < visibleChildren.size() - 1; ++i) {
            Node child0 = visibleChildren.get(i);
            Node child1 = visibleChildren.get(i + 1);
            this.splitters.add(this.createSplitter(child0, child1));
        }
    }

    public abstract Splitter createSplitter(Node var1, Node var2);

    public final List<Splitter> getSplitters() {
        if (this.splitters == null) {
            this.createSplitters();
        }
        return this.splitters;
    }

    protected void addChild(Node child, int index, double split) {
        this.children.add(index, child);
        this.nodeSplits.put(child, split);
        child.setParent(this);
    }

    public void addChild(Node child, double split) {
        this.children.add(child);
        this.nodeSplits.put(child, split);
        child.setParent(this);
        this.notifyStateChange();
    }

    public void removeChild(Node child) {
        this.children.remove(child);
        this.nodeSplits.remove(child);
        child.setParent(null);
        if (this.children.isEmpty()) {
            this.remove();
        }
        this.notifyStateChange();
    }

    public abstract boolean isSplitterDirection(int var1);

    public void insertNodeBefore(Node insert, Node before, int direction) {
        if (this.isSplitterDirection(direction)) {
            double split = this.getSplit(before) / 2.0;
            this.setSplit(before, split);
            this.addChild(insert, this.children.indexOf(before), split);
        } else {
            this.pushDown(before, insert, before);
        }
        this.notifyStateChange();
    }

    public void insertNodeAfter(Node insert, Node after, int direction) {
        if (this.isSplitterDirection(direction)) {
            double split = this.getSplit(after) / 2.0;
            this.setSplit(after, split);
            this.addChild(insert, this.children.indexOf(after) + 1, split);
        } else {
            this.pushDown(after, after, insert);
        }
        this.notifyStateChange();
    }

    public void insertNodeAfter(Node insert, Node after, double split) {
        this.addChild(insert, this.children.indexOf(after) + 1, split);
        this.notifyStateChange();
    }

    public void insertNodeAt(Node insert, int index, double split) {
        this.addChild(insert, index, split);
        this.notifyStateChange();
    }

    @Override
    protected void stateChanged() {
        this.splitters = null;
    }

    public void replaceChild(Node current, Node with) {
        double currentSplit = this.nodeSplits.get(current);
        int index = this.children.indexOf(current);
        this.children.remove(current);
        this.addChild(with, index, currentSplit);
        this.notifyStateChange();
    }

    protected abstract SplitterNode createPerpendicularSplitterNode(List<Node> var1, List<Double> var2);

    private SplitterNode pushDown(Node existingChild, Node node0, Node node1) {
        double split = this.getSplit(existingChild) / 2.0;
        SplitterNode sn = this.createPerpendicularSplitterNode(Arrays.asList(node0, node1), Arrays.asList(split, split));
        this.replaceChild(existingChild, sn);
        return sn;
    }
}

