/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.corext.callhierarchy.CallLocation;

public class MethodCall {
    private IModelElement fMember;
    private List fCallLocations;

    public MethodCall(IModelElement enclosingElement) {
        this.fMember = enclosingElement;
    }

    public Collection getCallLocations() {
        return this.fCallLocations;
    }

    public CallLocation getFirstCallLocation() {
        if (this.fCallLocations != null && !this.fCallLocations.isEmpty()) {
            return (CallLocation)this.fCallLocations.get(0);
        }
        return null;
    }

    public boolean hasCallLocations() {
        return this.fCallLocations != null && this.fCallLocations.size() > 0;
    }

    public Object getKey() {
        return this.getMember().getHandleIdentifier();
    }

    public IModelElement getMember() {
        return this.fMember;
    }

    public void addCallLocation(CallLocation location) {
        if (this.fCallLocations == null) {
            this.fCallLocations = new ArrayList();
        }
        this.fCallLocations.add(location);
    }
}

