/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public class XSDEditorPreferencePage
extends AbstractPreferencePage {
    private static final String XML_EDITOR_PREFERENCE_PAGE_ID = "org.eclipse.wst.sse.ui.preferences.xml.source";
    private Button removeUnusedImports;
    private Button automaticallyOpenSchemaLocationDialog;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "org.eclipse.wst.xsd.ui.internal.xsdp0020");
        new PreferenceLinkArea(composite, 66, XML_EDITOR_PREFERENCE_PAGE_ID, Messages._UI_XML_TEXT_EDITOR_PREFS_LINK, (IWorkbenchPreferenceContainer)this.getContainer(), null).getControl().setLayoutData((Object)GridDataFactory.fillDefaults().hint(150, -1).create());
        new Label(composite, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.createContentsForImportCleanup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    private boolean getRemoveImportSetting() {
        return this.removeUnusedImports.getSelection();
    }

    private boolean getAutomaticallyOpenSchemaLocationDialogSetting() {
        return this.automaticallyOpenSchemaLocationDialog.getSelection();
    }

    protected void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.removeUnusedImports.setSelection(store.getBoolean("org.eclipse.wst.xsd.ui.autoImportCleanup"));
        this.automaticallyOpenSchemaLocationDialog.setSelection(store.getBoolean("org.eclipse.wst.xsd.ui.autoOpenSchemaLocationDialog"));
    }

    protected void performDefaults() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.removeUnusedImports.setSelection(preferenceStore.getDefaultBoolean("org.eclipse.wst.xsd.ui.autoImportCleanup"));
        this.automaticallyOpenSchemaLocationDialog.setSelection(preferenceStore.getDefaultBoolean("org.eclipse.wst.xsd.ui.autoOpenSchemaLocationDialog"));
        super.performDefaults();
    }

    protected void storeValues() {
        this.saveValuesForImportsCleanup();
    }

    private void saveValuesForImportsCleanup() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.wst.xsd.ui.autoImportCleanup", this.getRemoveImportSetting());
        store.setValue("org.eclipse.wst.xsd.ui.autoOpenSchemaLocationDialog", this.getAutomaticallyOpenSchemaLocationDialogSetting());
    }

    public IPreferenceStore getPreferenceStore() {
        return XSDEditorPlugin.getPlugin().getPreferenceStore();
    }

    private void createContentsForImportCleanup(Composite parent) {
        Group unusedImportGroup = this.createGroup(parent, 1);
        unusedImportGroup.setText(Messages._UI_GRAPH_DIRECTIVES);
        GridData data = new GridData(4);
        data.verticalAlignment = 0x1000000;
        data.horizontalAlignment = 4;
        if (this.removeUnusedImports == null) {
            this.removeUnusedImports = new Button((Composite)unusedImportGroup, 16416);
            this.removeUnusedImports.setText(Messages._UI_TEXT_ENABLE_AUTO_IMPORT_CLEANUP);
            this.removeUnusedImports.setLayoutData((Object)data);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.removeUnusedImports, "org.eclipse.wst.xsd.ui.xsduf0050");
            this.automaticallyOpenSchemaLocationDialog = new Button((Composite)unusedImportGroup, 16416);
            this.automaticallyOpenSchemaLocationDialog.setText(Messages._UI_TEXT_ENABLE_AUTO_OPEN_SCHEMA_DIALOG);
            this.automaticallyOpenSchemaLocationDialog.setLayoutData((Object)GridDataFactory.copyData((GridData)data));
        }
    }

    protected void doSavePreferenceStore() {
        XSDEditorPlugin.getDefault().savePluginPreferences();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }
}

