/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tracetype.preferences;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.tracetype.preferences.TraceTypeLabelProvider;
import org.eclipse.tracecompass.tmf.ui.tracetype.preferences.TraceTypeTreeContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.FilteredCheckboxTree;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TreePatternFilter;

public class TraceTypePreferencePageViewer {
    private static final int BUTTON_CHECK_SELECTED_ID = 1024;
    private static final int BUTTON_UNCHECK_SELECTED_ID = 1025;
    private static final String[] FILTER_COLUMN_NAMES = new String[]{"Trace Types", "Initial Range Duration"};
    private static final String[] COLUMN_PROPERTIES = new String[]{"NAME", "DURATION"};
    private static final Set<String> EDITABLE = ImmutableSet.of((Object)Objects.requireNonNull(FILTER_COLUMN_NAMES[1]));
    private boolean fIsEmpty;
    private FilteredCheckboxTree fTree;
    private TraceTypeTreeContentProvider fContentProvider;
    private TraceTypeLabelProvider fLabelProvider;
    private ViewerComparator fComparator;
    private List<ViewerFilter> fFilters;
    private Iterable<@NonNull TraceTypeHelper> fEntries;
    private TextCellEditor fCellEditor;

    public TraceTypePreferencePageViewer(Iterable<@NonNull TraceTypeHelper> entries) {
        this.fEntries = entries;
        this.fContentProvider = new TraceTypeTreeContentProvider();
        this.fLabelProvider = new TraceTypeLabelProvider();
    }

    public Composite create(Composite parent) {
        Composite composite = this.createFilterArea(parent);
        this.fIsEmpty = this.fEntries.iterator().hasNext();
        BusyIndicator.showWhile(null, () -> {
            @NonNull Iterable toCheck = Iterables.filter(this.fEntries, helper -> helper.isEnabled());
            toCheck.forEach(handler -> this.checkElement(handler));
            this.fTree.getViewer().expandAll();
            TreeColumn[] treeColumnArray = this.fTree.getViewer().getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.pack();
                ++n2;
            }
            this.fTree.getViewer().collapseAll();
        });
        return composite;
    }

    public Composite createFilterArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        CheckboxTreeViewer treeViewer = this.createTreeViewer(composite);
        Composite buttonComposite = this.createSelectionButtons(composite);
        GridData data = new GridData(1808);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        if (this.fIsEmpty) {
            treeWidget.setEnabled(false);
            buttonComposite.setEnabled(false);
        }
        return composite;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        TreePatternFilter filter = new TreePatternFilter();
        filter.setIncludeLeadingWildcard(true);
        this.fTree = new FilteredCheckboxTree(parent, 2050, filter, true);
        this.fTree.setLayout((Layout)new GridLayout());
        this.fTree.setLayoutData(new GridData(4, 4, true, true));
        final TreeViewer viewer = this.fTree.getViewer();
        final TextCellEditor[] editors = new TextCellEditor[FILTER_COLUMN_NAMES.length];
        TreeViewerEditor.create((TreeViewer)viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell viewerCell;
                if (event.getSource() instanceof ViewerCell && editors[(viewerCell = (ViewerCell)event.getSource()).getColumnIndex()] != null) {
                    return event.eventType == 2;
                }
                return false;
            }
        }, (int)1);
        Tree tree = viewer.getTree();
        this.fCellEditor = new TextCellEditor((Composite)tree, 2048);
        tree.setHeaderVisible(true);
        String[] stringArray = FILTER_COLUMN_NAMES;
        int n = FILTER_COLUMN_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setText(columnName);
            ++n2;
        }
        int i = 0;
        while (i < FILTER_COLUMN_NAMES.length) {
            if (EDITABLE.contains(FILTER_COLUMN_NAMES[i])) {
                editors[i] = this.fCellEditor;
            }
            ++i;
        }
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        viewer.setColumnProperties(COLUMN_PROPERTIES);
        viewer.setCellEditors((CellEditor[])editors);
        viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TreeItem treeItem;
                Object data;
                if (element instanceof TreeItem && (data = (treeItem = (TreeItem)element).getData()) instanceof TraceTypeHelper) {
                    TraceTypeHelper helper = (TraceTypeHelper)data;
                    if (property.equals(COLUMN_PROPERTIES[1])) {
                        try {
                            String text = value.toString().replaceAll("\\s", "");
                            double doubleval = Double.parseDouble(text) * 1.0E9;
                            TraceTypePreferences.setInitialTimeRange((String)helper.getTraceTypeId(), (long)((long)doubleval));
                            viewer.refresh();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }

            public Object getValue(Object element, String property) {
                if (element instanceof TraceTypeHelper) {
                    TraceTypeHelper helper = (TraceTypeHelper)element;
                    if (property.equals(COLUMN_PROPERTIES[1])) {
                        String traceTypeId = helper.getTraceTypeId();
                        return TmfTimestamp.fromNanos((long)TraceTypePreferences.getInitialTimeRange((String)traceTypeId, (long)helper.getTrace().getInitialRangeOffset().toNanos())).toString(TmfTimestampFormat.getDefaulIntervalFormat());
                    }
                }
                return element;
            }

            public boolean canModify(Object element, String property) {
                if (element instanceof TraceTypeHelper) {
                    return property.equals(COLUMN_PROPERTIES[1]);
                }
                return false;
            }
        });
        this.fTree.addCheckStateListener(new CheckStateListener());
        viewer.setComparator(this.fComparator);
        if (this.fFilters != null) {
            i = 0;
            while (i != this.fFilters.size()) {
                viewer.addFilter(this.fFilters.get(i));
                ++i;
            }
        }
        viewer.setInput(this.fEntries);
        return (CheckboxTreeViewer)viewer;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(131072, 128, false, false);
        buttonComposite.setLayoutData((Object)data);
        Button checkSelectedButton = TraceTypePreferencePageViewer.createButton(buttonComposite, 1024, Messages.TmfTimeFilterDialog_CHECK_SELECTED);
        Button checkAllButton = TraceTypePreferencePageViewer.createButton(buttonComposite, 18, Messages.TmfTimeFilterDialog_CHECK_ALL);
        Button uncheckSelectedButton = TraceTypePreferencePageViewer.createButton(buttonComposite, 1025, Messages.TmfTimeFilterDialog_UNCHECK_SELECTED);
        Button uncheckAllButton = TraceTypePreferencePageViewer.createButton(buttonComposite, 19, Messages.TmfTimeFilterDialog_UNCHECK_ALL);
        checkSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeSelection selection = (TreeSelection)TraceTypePreferencePageViewer.this.fTree.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    TraceTypePreferencePageViewer.this.checkElement(element);
                    ++n2;
                }
            }
        });
        checkAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] viewerElements = TraceTypePreferencePageViewer.this.fContentProvider.getElements(TraceTypePreferencePageViewer.this.fEntries);
                int i = 0;
                while (i < viewerElements.length) {
                    TraceTypePreferencePageViewer.this.fTree.setSubtreeChecked(viewerElements[i], true);
                    ++i;
                }
            }
        });
        uncheckSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeSelection selection = (TreeSelection)TraceTypePreferencePageViewer.this.fTree.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    TraceTypePreferencePageViewer.this.uncheckElement(element);
                    ++n2;
                }
            }
        });
        uncheckAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] viewerElements;
                Object[] objectArray = viewerElements = TraceTypePreferencePageViewer.this.fContentProvider.getElements(TraceTypePreferencePageViewer.this.fEntries);
                int n = viewerElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (TraceTypePreferencePageViewer.this.fTree.getViewer().testFindItem(element) != null) {
                        TraceTypePreferencePageViewer.this.uncheckElement(element);
                    }
                    ++n2;
                }
            }
        });
        return buttonComposite;
    }

    private static Button createButton(Composite parent, int id, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        GridData data = new GridData(4, 0x1000000, true, true);
        button.setLayoutData((Object)data);
        return button;
    }

    public void performDefaults() {
        Object input = this.fTree.getViewer().getInput();
        if (input instanceof Iterable) {
            ((Iterable)input).forEach(this::checkElementAndSubtree);
            ((Iterable)input).forEach(element -> {
                if (element instanceof TraceTypeHelper) {
                    TraceTypeHelper helper = (TraceTypeHelper)element;
                    TraceTypePreferences.resetInitialTimeRange((String)helper.getTraceTypeId());
                }
            });
        }
        this.fTree.getViewer().refresh();
        this.fTree.getViewer().expandAll();
    }

    private void checkElement(Object element) {
        this.fTree.setChecked(element, true);
        String parent = this.fContentProvider.getParent(element);
        while (parent != null && !this.fTree.getChecked(parent)) {
            this.fTree.setChecked(parent, true);
            parent = this.fContentProvider.getParent(parent);
        }
        TraceTypeHelper[] children = this.fContentProvider.getChildren(element);
        if (children != null) {
            TraceTypeHelper[] traceTypeHelperArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TraceTypeHelper child = traceTypeHelperArray[n2];
                this.checkElement(child);
                ++n2;
            }
        }
    }

    private void checkElementAndSubtree(Object element) {
        this.checkElement(element);
        TraceTypeHelper[] traceTypeHelperArray = this.fContentProvider.getChildren(element);
        int n = traceTypeHelperArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceTypeHelper child = traceTypeHelperArray[n2];
            this.checkElementAndSubtree(child);
            ++n2;
        }
    }

    private void uncheckElement(Object element) {
        this.fTree.setChecked(element, false);
        TraceTypeHelper[] traceTypeHelperArray = this.fContentProvider.getChildren(element);
        int n = traceTypeHelperArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceTypeHelper child = traceTypeHelperArray[n2];
            this.uncheckElement(child);
            ++n2;
        }
        String parent = this.fContentProvider.getParent(element);
        while (parent != null && !this.hasCheckedChild(parent)) {
            this.fTree.setChecked(parent, false);
            parent = this.fContentProvider.getParent(parent);
        }
    }

    private boolean hasCheckedChild(Object parent) {
        TraceTypeHelper[] children;
        TraceTypeHelper[] traceTypeHelperArray = children = this.fContentProvider.getChildren(parent);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TraceTypeHelper child = traceTypeHelperArray[n2];
            if (this.fTree.getChecked(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<TraceTypeHelper> getCheckedElements() {
        Object[] checkedElements;
        ArrayList<TraceTypeHelper> checked = new ArrayList<TraceTypeHelper>();
        Object[] objectArray = checkedElements = this.fTree.getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof TraceTypeHelper) {
                checked.add((TraceTypeHelper)element);
            }
            ++n2;
        }
        return checked;
    }

    public List<TraceTypeHelper> getUncheckedElements() {
        List<TraceTypeHelper> unchecked = this.getEntries();
        unchecked.removeAll(this.getCheckedElements());
        return unchecked;
    }

    private List<TraceTypeHelper> getEntries() {
        return Lists.newArrayList(this.fEntries);
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
    }

    private class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            try {
                boolean checked = event.getChecked();
                if (checked) {
                    TraceTypePreferencePageViewer.this.checkElement(event.getElement());
                } else {
                    TraceTypePreferencePageViewer.this.uncheckElement(event.getElement());
                }
            }
            catch (ClassCastException e) {
                Activator.getDefault().logError("Failed to enable trace types", e);
                return;
            }
        }
    }
}

