/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.genericeditor.Messages;

public class DefaultWordHighlightStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IEclipsePreferences.IPreferenceChangeListener {
    private static final String ANNOTATION_TYPE = "org.eclipse.ui.genericeditor.text";
    private boolean enabled;
    private ISourceViewer sourceViewer;
    private IDocument document;
    private static final String WORD_REGEXP = "\\w+";
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w+", 256);
    private static final Pattern CURRENT_WORD_START_PATTERN = Pattern.compile("\\w+$", 256);
    private Annotation[] fOccurrenceAnnotations = null;
    private ISelectionChangedListener editorSelectionChangedListener = event -> this.applyHighlights(event.getSelection());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHighlights(ISelection selection) {
        String word;
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (this.sourceViewer == null || !this.enabled) {
            this.removeOccurrenceAnnotations();
            return;
        }
        String text = this.document.get();
        int offset = textSelection.getOffset();
        if (this.sourceViewer instanceof ITextViewerExtension5) {
            offset = ((ITextViewerExtension5)this.sourceViewer).widgetOffset2ModelOffset(textSelection.getOffset());
        }
        if ((word = DefaultWordHighlightStrategy.findCurrentWord(text, offset)) == null) {
            this.removeOccurrenceAnnotations();
            return;
        }
        Matcher m = WORD_PATTERN.matcher(text);
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>();
        while (m.find()) {
            if (!m.group().equals(word)) continue;
            annotationMap.put(new Annotation(ANNOTATION_TYPE, false, NLS.bind((String)Messages.DefaultWordHighlightStrategy_OccurrencesOf, (Object)word)), new Position(m.start(), m.end() - m.start()));
        }
        if (annotationMap.size() < 2) {
            this.removeOccurrenceAnnotations();
            return;
        }
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        if (annotationModel != null) {
            Object object = DefaultWordHighlightStrategy.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, annotationMap);
                } else {
                    this.removeOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
        } else {
            this.fOccurrenceAnnotations = null;
        }
    }

    private static String findCurrentWord(String text, int offset) {
        String wordStart = null;
        String wordEnd = null;
        String substring = text.substring(0, offset);
        Matcher m = CURRENT_WORD_START_PATTERN.matcher(substring);
        if (m.find()) {
            wordStart = m.group();
        }
        if ((m = WORD_PATTERN.matcher(substring = text.substring(offset))).lookingAt()) {
            wordEnd = m.group();
        }
        if (wordStart != null && wordEnd != null) {
            return String.valueOf(wordStart) + wordEnd;
        }
        if (wordStart != null) {
            return wordStart;
        }
        return wordEnd;
    }

    public void install(ITextViewer viewer) {
        if (!(viewer instanceof ISourceViewer)) {
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.genericeditor");
        preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.enabled = preferences.getBoolean("org.eclipse.ui.genericeditor.togglehighlight", true);
        this.sourceViewer = (ISourceViewer)viewer;
        ((IPostSelectionProvider)this.sourceViewer.getSelectionProvider()).addPostSelectionChangedListener(this.editorSelectionChangedListener);
    }

    public void uninstall() {
        if (this.sourceViewer != null) {
            ((IPostSelectionProvider)this.sourceViewer.getSelectionProvider()).removePostSelectionChangedListener(this.editorSelectionChangedListener);
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.genericeditor");
        preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.eclipse.ui.genericeditor.togglehighlight")) {
            this.enabled = Boolean.parseBoolean(event.getNewValue().toString());
            if (this.enabled) {
                this.initialReconcile();
            } else {
                this.removeOccurrenceAnnotations();
            }
        }
    }

    public void initialReconcile() {
        if (this.sourceViewer != null) {
            this.sourceViewer.getTextWidget().getDisplay().asyncExec(() -> {
                if (this.sourceViewer != null && this.sourceViewer.getTextWidget() != null) {
                    this.applyHighlights(this.sourceViewer.getSelectionProvider().getSelection());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = DefaultWordHighlightStrategy.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                Annotation[] annotationArray = this.fOccurrenceAnnotations;
                int n = this.fOccurrenceAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation fOccurrenceAnnotation = annotationArray[n2];
                    annotationModel.removeAnnotation(fOccurrenceAnnotation);
                    ++n2;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private static Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }
}

