/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.UdevListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class Udev
implements Runnable {
    private static Udev instance;
    private long fd = this._open();
    private ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
    private Thread thread;
    private UdevListener[] listeners;

    static synchronized Udev getInstance() {
        if (instance == null) {
            try {
                instance = new Udev();
            }
            catch (IOException iOException) {
                System.err.println("Udev: failed to open connection");
                iOException.printStackTrace();
            }
        }
        return instance;
    }

    private Udev() throws IOException {
        this.buffer.order(ByteOrder.nativeOrder());
        this.thread = new Thread((Runnable)this, "udev monitor");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    synchronized void addListener(UdevListener udevListener) {
        if (this.listeners == null) {
            this.listeners = new UdevListener[]{udevListener};
        } else {
            this.listeners = Arrays.copyOf(this.listeners, this.listeners.length + 1);
            this.listeners[this.listeners.length - 1] = udevListener;
        }
    }

    private native long _open() throws IOException;

    private native int _readEvent(long var1, ByteBuffer var3) throws IOException;

    private native void _close(long var1);

    private native int _getPropertiesOffset(ByteBuffer var1);

    private native int _getPropertiesLength(ByteBuffer var1);

    @Override
    public void run() {
        try {
            RunnableProcessor runnableProcessor = NativePlatformFactory.getNativePlatform().getRunnableProcessor();
            while (true) {
                final Map<String, String> map = this.readEvent();
                runnableProcessor.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String string = (String)map.get("ACTION");
                        if (string != null) {
                            UdevListener[] udevListenerArray;
                            1 var3_2 = this;
                            synchronized (var3_2) {
                                udevListenerArray = Udev.this.listeners;
                            }
                            if (udevListenerArray != null) {
                                for (int i = 0; i < udevListenerArray.length; ++i) {
                                    try {
                                        udevListenerArray[i].udevEvent(string, map);
                                        continue;
                                    }
                                    catch (RuntimeException runtimeException) {
                                        System.err.println("Exception in udev listener:");
                                        runtimeException.printStackTrace();
                                        continue;
                                    }
                                    catch (Error error) {
                                        System.err.println("Error in udev listener, closing udev");
                                        error.printStackTrace();
                                        Udev.this.close();
                                        return;
                                    }
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (IOException iOException) {
            if (!this.thread.isInterrupted()) {
                System.err.println("Exception in udev thread:");
                iOException.printStackTrace();
                this.close();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readEvent() throws IOException {
        ByteBuffer byteBuffer;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Udev udev = this;
        synchronized (udev) {
            byteBuffer = this.buffer;
            if (byteBuffer == null) {
                return hashMap;
            }
        }
        int n = this._readEvent(this.fd, byteBuffer);
        Udev udev2 = this;
        synchronized (udev2) {
            int n2;
            if (this.buffer == null) {
                return hashMap;
            }
            int n3 = this._getPropertiesOffset(this.buffer);
            int n4 = n3 + (n2 = this._getPropertiesLength(this.buffer));
            if (n < n4) {
                throw new IOException("Mismatched property segment length");
            }
            this.buffer.position(n3);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            block13: while (this.buffer.position() < n4) {
                char c;
                stringBuffer.setLength(0);
                stringBuffer2.setLength(0);
                boolean bl = false;
                block14: while (this.buffer.position() < n && !bl) {
                    c = (char)this.buffer.get();
                    switch (c) {
                        case '\u0000': {
                            hashMap.put(stringBuffer.toString(), "");
                            continue block13;
                        }
                        case '=': {
                            bl = true;
                            continue block14;
                        }
                    }
                    stringBuffer.append(c);
                }
                while (this.buffer.position() < n4) {
                    c = (char)this.buffer.get();
                    switch (c) {
                        case '\u0000': {
                            hashMap.put(stringBuffer.toString(), stringBuffer2.toString());
                            continue block13;
                        }
                    }
                    stringBuffer2.append(c);
                }
            }
            this.buffer.clear();
        }
        return hashMap;
    }

    synchronized void close() {
        this.thread.interrupt();
        this._close(this.fd);
        this.fd = 0L;
        this.buffer = null;
        this.thread = null;
    }
}

