/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.Timer;
import net.osmand.PlatformUtil;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.ui.ISelectionInterface;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import org.apache.commons.logging.Log;

public class OsmBitmapPanelMouseAdapter
extends MouseAdapter
implements ComponentListener {
    private static final int ZOOM_DELAY_MILLISECONDS = 100;
    private static final int ROTATE_DELAY_MILLISECONDS = 500;
    private static final Log log = PlatformUtil.getLog(OsmBitmapPanelMouseAdapter.class);
    private ISelectionInterface mDragInterface = null;
    private OsmBitmapPanel drawPanel;
    private Point lastDragPoint;
    private Timer mZoomTimer;
    private ZoomPerformer mZoomPerformer;
    private Timer mRotateTimer;
    private RotatePerformer mRotatePerformer;
    private MouseEvent mMouseEvent;
    private OsmWindow mContext;
    private ISelectionInterface.IDragInformation mDragInformation;

    public OsmBitmapPanelMouseAdapter(OsmBitmapPanel drawPanel) {
        this.drawPanel = drawPanel;
        this.mContext = drawPanel.getContext();
        this.mZoomPerformer = new ZoomPerformer();
        this.mZoomTimer = new Timer(100, this.mZoomPerformer);
        this.mZoomTimer.setRepeats(false);
        this.mRotatePerformer = new RotatePerformer();
        this.mRotateTimer = new Timer(500, this.mRotatePerformer);
        this.mRotateTimer.setRepeats(false);
    }

    public ZoomPerformer getZoomPerformer() {
        return this.mZoomPerformer;
    }

    public boolean isPopup(MouseEvent e) {
        return e.isPopupTrigger();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isPopup(e)) {
            return;
        }
        this.lastDragPoint = new Point(e.getPoint());
        this.mDragInterface = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.lastDragPoint == null) {
            return;
        }
        Point deltaPoint = new Point(this.lastDragPoint);
        Point point = new Point(e.getPoint());
        deltaPoint.translate(-point.x, -point.y);
        if (this.mDragInterface != null) {
            this.mDragInterface.drag(point, this.mDragInformation);
            this.drawPanel.repaint();
            return;
        }
        for (OsmandMapLayer layer : this.mContext.getDrawPanel().getLayers()) {
            ISelectionInterface sel;
            ISelectionInterface.IDragInformation information;
            if (!(layer instanceof ISelectionInterface) || (information = (sel = (ISelectionInterface)((Object)layer)).isDragPoint(this.lastDragPoint, point)) == null) continue;
            this.mDragInterface = sel;
            this.mDragInformation = information;
            sel.drag(point, this.mDragInformation);
            this.drawPanel.repaint();
            return;
        }
        this.lastDragPoint = new Point(point);
        this.drawPanel.dragImage(deltaPoint);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isPopup(e)) {
            return;
        }
        this.drawPanel.drawLater();
        this.mDragInterface = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent pE) {
        pE.consume();
        this.lastDragPoint = null;
        if (pE.isControlDown()) {
            this.mRotatePerformer.addWheelEvent(10.0 * pE.getPreciseWheelRotation(), pE.getPoint());
            this.mRotateTimer.restart();
            this.drawPanel.directRotateIncrement(10.0 * pE.getPreciseWheelRotation());
            return;
        }
        log.info((Object)("Wheel event detected: " + pE));
        this.mZoomPerformer.addWheelEvent(pE.getWheelRotation(), pE.getPoint());
        this.mZoomTimer.restart();
    }

    @Override
    public void componentResized(ComponentEvent pE) {
        log.info((Object)("Resize event received: " + pE));
        this.drawPanel.resizePanel();
    }

    @Override
    public void componentMoved(ComponentEvent pE) {
    }

    @Override
    public void componentShown(ComponentEvent pE) {
    }

    @Override
    public void componentHidden(ComponentEvent pE) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isPopup(e)) {
            return;
        }
        if (e.isShiftDown()) {
            this.mContext.getPolylineLayer().addPolylinePoint(e.getPoint());
            return;
        }
        this.mContext.getPolylineLayer().endPolyline();
        this.mContext.setCursorPosition(e.getPoint());
        for (OsmandMapLayer layer : this.mContext.getDrawPanel().getLayers()) {
            ISelectionInterface sel;
            if (!(layer instanceof ISelectionInterface) || !(sel = (ISelectionInterface)((Object)layer)).isSelection(e.getPoint())) continue;
            sel.setSelection(e.getPoint());
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent pE) {
        this.setMouseEvent(pE);
    }

    public MouseEvent getMouseEvent() {
        return this.mMouseEvent;
    }

    public void setMouseEvent(MouseEvent pMouseEvent) {
        this.mMouseEvent = pMouseEvent;
    }

    public Timer getZoomTimer() {
        return this.mZoomTimer;
    }

    public void addWheelEvent(int pI, RotatedTileBox pCurrentTileBox) {
        this.mZoomPerformer.addWheelEvent(pI, new Point(pCurrentTileBox.getCenterPixelX(), pCurrentTileBox.getCenterPixelY()));
        this.mZoomTimer.restart();
    }

    private class RotatePerformer
    implements ActionListener {
        private double mDegrees;
        private Point mPoint;

        private RotatePerformer() {
        }

        public void addWheelEvent(double pWheelRotation, Point pPoint) {
            this.mDegrees += pWheelRotation;
            this.mPoint = pPoint;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            OsmBitmapPanelMouseAdapter.this.drawPanel.rotateIncrement(this.mDegrees);
            this.mDegrees = 0.0;
        }
    }

    public class ZoomPerformer
    implements ActionListener {
        private int mCounter;
        private Point mPoint;

        public void addWheelEvent(int pWheelRotation, Point pPoint) {
            this.mCounter += pWheelRotation;
            this.mPoint = pPoint;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            log.info((Object)"Zoom action is fired");
            if (OsmBitmapPanelMouseAdapter.this.drawPanel.isZoomRunning()) {
                log.info((Object)"Don't zoom as there is something running. Try later automatically.");
                OsmBitmapPanelMouseAdapter.this.mZoomTimer.restart();
            } else {
                OsmBitmapPanelMouseAdapter.this.drawPanel.zoomChange(-this.mCounter, this.mPoint);
                this.mCounter = 0;
            }
        }
    }
}

