/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.fonts.autodetect.FontFinder;

public class WindowsFontDirFinder
implements FontFinder {
    private String getWinDir(String osName) throws IOException {
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        process = osName.startsWith("Windows 9") ? runtime.exec("command.com /c echo %windir%") : runtime.exec("cmd.exe /c echo %windir%");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        return bufferedReader.readLine();
    }

    public List find() {
        ArrayList<File> fontDirList = new ArrayList<File>();
        String windir = null;
        try {
            windir = System.getProperty("env.windir");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String osName = System.getProperty("os.name");
        if (windir == null) {
            try {
                windir = this.getWinDir(osName);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        File osFontsDir = null;
        File psFontsDir = null;
        if (windir != null) {
            if (windir.endsWith("/")) {
                windir = windir.substring(0, windir.length() - 1);
            }
            if ((osFontsDir = new File(windir + File.separator + "FONTS")).exists() && osFontsDir.canRead()) {
                fontDirList.add(osFontsDir);
            }
            if ((psFontsDir = new File(windir.substring(0, 2) + File.separator + "PSFONTS")).exists() && psFontsDir.canRead()) {
                fontDirList.add(psFontsDir);
            }
        } else {
            String windowsDirName = osName.endsWith("NT") ? "WINNT" : "WINDOWS";
            char driveLetter = 'C';
            while (driveLetter <= 'E') {
                osFontsDir = new File(driveLetter + ":" + File.separator + windowsDirName + File.separator + "FONTS");
                if (osFontsDir.exists() && osFontsDir.canRead()) {
                    fontDirList.add(osFontsDir);
                    break;
                }
                driveLetter = (char)(driveLetter + '\u0001');
            }
            char driveLetter2 = 'C';
            while (driveLetter2 <= 'E') {
                psFontsDir = new File(driveLetter2 + ":" + File.separator + "PSFONTS");
                if (psFontsDir.exists() && psFontsDir.canRead()) {
                    fontDirList.add(psFontsDir);
                    break;
                }
                driveLetter2 = (char)(driveLetter2 + '\u0001');
            }
        }
        return fontDirList;
    }
}

