/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.dsf.gdb.internal.ProcStatCoreLoads;

public class ProcStatCounters {
    private Map<String, OneCoreTickCounters> fTickCounters = new HashMap<String, OneCoreTickCounters>();

    public void addTickCounters(String core, Integer[] ticks) {
        this.fTickCounters.put(core, new OneCoreTickCounters(ticks));
    }

    public final ProcStatCoreLoads computeLoads(ProcStatCounters old) {
        ProcStatCoreLoads loads = new ProcStatCoreLoads();
        for (String coreId : this.fTickCounters.keySet()) {
            OneCoreTickCounters coreCountersNew = this.fTickCounters.get(coreId);
            if (old != null) {
                OneCoreTickCounters coreCountersOld = old.fTickCounters.get(coreId);
                int diffIdle = coreCountersNew.getIdleTicks() - coreCountersOld.getIdleTicks();
                int diffActive = coreCountersNew.getActiveTicks() - coreCountersOld.getActiveTicks();
                assert (diffIdle >= 0);
                assert (diffActive >= 0);
                if (diffIdle < 0 || diffActive < 0) {
                    return null;
                }
                float load = diffIdle + diffActive != 0 ? (float)diffActive / (float)(diffActive + diffIdle) : 0.0f;
                loads.put(coreId, Float.valueOf(load * 100.0f));
                continue;
            }
            int diffIdle = coreCountersNew.getIdleTicks();
            int diffActive = coreCountersNew.getActiveTicks();
            assert (diffActive + diffIdle != 0);
            float load = (float)diffActive / (float)(diffActive + diffIdle);
            loads.put(coreId, Float.valueOf(load * 100.0f));
        }
        return loads;
    }

    private class OneCoreTickCounters {
        private int fUser;
        private int fNice;
        private int fSystem;
        private int fIdle;
        private int fIowait;
        private int fIrq;
        private int fSoftirq;

        public OneCoreTickCounters(Integer[] c) {
            assert (c != null && c.length >= 7);
            if (c == null || c.length < 7) {
                return;
            }
            this.fUser = c[0];
            this.fNice = c[1];
            this.fSystem = c[2];
            this.fIdle = c[3];
            this.fIowait = c[4];
            this.fIrq = c[5];
            this.fSoftirq = c[6];
        }

        private int getActiveTicks() {
            return this.fUser + this.fNice + this.fSystem + this.fIowait + this.fIrq + this.fSoftirq;
        }

        private int getIdleTicks() {
            return this.fIdle;
        }
    }
}

