/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.base.DLTKChange;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameResourceChange
extends DLTKChange {
    private final String fComment;
    private final RefactoringDescriptor fDescriptor;
    private final String fNewName;
    private final IPath fResourcePath;
    private final long fStampToRestore;

    public static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }

    private RenameResourceChange(RefactoringDescriptor descriptor, IPath resourcePath, String newName, String comment, long stampToRestore) {
        this.fDescriptor = descriptor;
        this.fResourcePath = resourcePath;
        this.fNewName = newName;
        this.fComment = comment;
        this.fStampToRestore = stampToRestore;
    }

    public RenameResourceChange(RefactoringDescriptor descriptor, IResource resource, String newName, String comment) {
        this(descriptor, resource.getFullPath(), newName, comment, -1L);
    }

    public ChangeDescriptor getDescriptor() {
        if (this.fDescriptor != null) {
            return new RefactoringChangeDescriptor(this.fDescriptor);
        }
        return null;
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameResourceChange_name, this.fResourcePath.toString(), this.fNewName);
    }

    public String getNewName() {
        return this.fNewName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameResourceChange_does_not_exist, this.fResourcePath.toString()));
        }
        return super.isValid(pm, 2);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.RenameResourceChange_rename_resource, 1);
            IResource resource = this.getResource();
            long currentStamp = resource.getModificationStamp();
            IPath newPath = RenameResourceChange.renamedResourcePath(this.fResourcePath, this.fNewName);
            resource.move(newPath, 32, pm);
            if (this.fStampToRestore != -1L) {
                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
                newResource.revertModificationStamp(this.fStampToRestore);
            }
            String oldName = this.fResourcePath.lastSegment();
            RenameResourceChange renameResourceChange = new RenameResourceChange(null, newPath, oldName, this.fComment, currentStamp);
            return renameResourceChange;
        }
        finally {
            pm.done();
        }
    }
}

