/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class WebServiceTargetNamespaceRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof TypeDeclaration)) continue;
            AnnotationMirror webService = AnnotationUtils.getAnnotation((Declaration)declaration, WebService.class);
            AnnotationValue targetNamespace = AnnotationUtils.getAnnotationValue((AnnotationMirror)webService, (String)"targetNamespace");
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
            PackageDeclaration packageDeclaration = typeDeclaration.getPackage();
            if (packageDeclaration.getQualifiedName().length() == 0 && (targetNamespace == null || targetNamespace.getValue().toString().trim().length() == 0)) {
                this.printError(webService.getPosition(), JAXWSCoreMessages.WEBSERVICE_DEFAULT_PACKAGE_TARGET_NAMESPACE);
            }
            this.validateURISyntax(targetNamespace);
            Collection methods = ((TypeDeclaration)declaration).getMethods();
            for (MethodDeclaration methodDeclaration : methods) {
                Collection parameters = methodDeclaration.getParameters();
                for (ParameterDeclaration parameterDeclaration : parameters) {
                    AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameterDeclaration, WebParam.class);
                    if (webParam == null) continue;
                    this.validateURISyntax(AnnotationUtils.getAnnotationValue((AnnotationMirror)webParam, (String)"targetNamespace"));
                }
            }
        }
    }

    private void validateURISyntax(AnnotationValue targetNamespace) {
        if (targetNamespace != null) {
            try {
                new URI(targetNamespace.getValue().toString());
            }
            catch (URISyntaxException urise) {
                this.printError(targetNamespace.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.TARGET_NAMESPACE_URI_SYNTAX_ERROR, (Object[])new Object[]{urise.getIndex(), urise.getInput(), urise.getReason()}));
            }
        }
    }
}

