/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.model;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;

public abstract class ServerDelegate {
    private Server server;
    private ServerWorkingCopy serverWC;

    final void initialize(Server newServer, IProgressMonitor monitor) {
        this.server = newServer;
        if (newServer instanceof ServerWorkingCopy) {
            this.serverWC = (ServerWorkingCopy)newServer;
        }
        this.initialize();
    }

    public boolean isUseProjectSpecificSchedulingRuleOnPublish() {
        return false;
    }

    protected void initialize() {
    }

    public final IServer getServer() {
        return this.server;
    }

    public final IServerWorkingCopy getServerWorkingCopy() {
        return this.serverWC;
    }

    protected final int getAttribute(String id, int defaultValue) {
        return this.server.getAttribute(id, defaultValue);
    }

    protected final boolean getAttribute(String id, boolean defaultValue) {
        return this.server.getAttribute(id, defaultValue);
    }

    protected final String getAttribute(String id, String defaultValue) {
        return this.server.getAttribute(id, defaultValue);
    }

    protected final List getAttribute(String id, List<String> defaultValue) {
        return this.server.getAttribute(id, defaultValue);
    }

    protected final Map getAttribute(String id, Map defaultValue) {
        return this.server.getAttribute(id, defaultValue);
    }

    public void dispose() {
    }

    public abstract IStatus canModifyModules(IModule[] var1, IModule[] var2);

    public abstract IModule[] getChildModules(IModule[] var1);

    public abstract IModule[] getRootModules(IModule var1) throws CoreException;

    public ServerPort[] getServerPorts() {
        return new ServerPort[0];
    }

    public void setDefaults(IProgressMonitor monitor) {
    }

    public void newServerDetailsChanged(IProgressMonitor monitor) {
        this.setDefaults(monitor);
    }

    protected final void setAttribute(String id, int value) {
        this.serverWC.setAttribute(id, value);
    }

    protected final void setAttribute(String id, boolean value) {
        this.serverWC.setAttribute(id, value);
    }

    protected final void setAttribute(String id, String value) {
        this.serverWC.setAttribute(id, value);
    }

    protected final void setAttribute(String id, List<String> value) {
        this.serverWC.setAttribute(id, value);
    }

    protected final void setAttribute(String id, Map value) {
        this.serverWC.setAttribute(id, value);
    }

    public abstract void modifyModules(IModule[] var1, IModule[] var2, IProgressMonitor var3) throws CoreException;

    public void importConfiguration(IRuntime runtime, IProgressMonitor monitor) {
        try {
            this.importRuntimeConfiguration(runtime, monitor);
        }
        catch (CoreException coreException) {}
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
    }

    public void configurationChanged() {
    }
}

