/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.egit.ui.internal.commit.DiffRegionFormatter;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkSourceViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DiffViewer
extends HyperlinkSourceViewer {
    private final Map<String, IToken> tokens = new HashMap<String, IToken>();
    private final Map<String, Color> backgroundColors = new HashMap<String, Color>();
    private IPropertyChangeListener themeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("CHANGE_CURRENT_THEME".equals(property) || "org.eclipse.egit.ui.DiffAddBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffAddForegroundColor".equals(property) || "org.eclipse.egit.ui.DiffHunkBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffHunkForegroundColor".equals(property) || "org.eclipse.egit.ui.DiffHeadlineBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffHeadlineForegroundColor".equals(property) || "org.eclipse.egit.ui.DiffHeadlineFont".equals(property) || "org.eclipse.egit.ui.DiffRemoveBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffRemoveForegroundColor".equals(property)) {
                DiffViewer.this.refreshDiffStyles();
                DiffViewer.this.invalidateTextPresentation();
            }
        }
    };

    public DiffViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this(parent, ruler, null, false, styles);
    }

    public DiffViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        this.getTextWidget().setAlwaysShowScrollBars(false);
        this.setEditable(false);
        this.setDocument((IDocument)new Document());
        this.initListeners();
        this.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.refreshDiffStyles();
    }

    @Override
    protected void handleDispose() {
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeListener);
        super.handleDispose();
    }

    @Override
    public void configure(SourceViewerConfiguration config) {
        Assert.isTrue((boolean)(config instanceof Configuration));
        super.configure(config);
    }

    protected Layout createLayout() {
        return new FixedRulerLayout(1);
    }

    private void refreshDiffStyles() {
        ColorRegistry col = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        FontRegistry reg = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        this.tokens.put("__dftl_partition_content_type", (IToken)new Token(null));
        this.tokens.put("_egit_diff_headline", (IToken)new Token((Object)new TextAttribute(col.get("org.eclipse.egit.ui.DiffHeadlineForegroundColor"), null, 0, reg.get("org.eclipse.egit.ui.DiffHeadlineFont"))));
        this.tokens.put("_egit_diff_hunk", (IToken)new Token((Object)new TextAttribute(col.get("org.eclipse.egit.ui.DiffHunkForegroundColor"))));
        this.tokens.put("_egit_diff_added", (IToken)new Token((Object)new TextAttribute(col.get("org.eclipse.egit.ui.DiffAddForegroundColor"))));
        this.tokens.put("_egit_diff_removed", (IToken)new Token((Object)new TextAttribute(col.get("org.eclipse.egit.ui.DiffRemoveForegroundColor"))));
        this.backgroundColors.put("_egit_diff_headline", col.get("org.eclipse.egit.ui.DiffHeadlineBackgroundColor"));
        this.backgroundColors.put("_egit_diff_hunk", col.get("org.eclipse.egit.ui.DiffHunkBackgroundColor"));
        this.backgroundColors.put("_egit_diff_added", col.get("org.eclipse.egit.ui.DiffAddBackgroundColor"));
        this.backgroundColors.put("_egit_diff_removed", col.get("org.eclipse.egit.ui.DiffRemoveBackgroundColor"));
    }

    private void initListeners() {
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        this.getTextWidget().addLineBackgroundListener(event -> {
            IDocument document = this.getDocument();
            if (document instanceof DiffDocument) {
                try {
                    Color color;
                    int modelOffset = this.widgetOffset2ModelOffset(event.lineOffset);
                    ITypedRegion partition = ((DiffDocument)document).getPartition(modelOffset);
                    if (partition != null && (color = this.backgroundColors.get(partition.getType())) != null) {
                        event.lineBackground = color;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    protected void handleJFacePreferencesChange(PropertyChangeEvent event) {
        if ("org.eclipse.jface.textfont".equals(event.getProperty())) {
            this.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        } else {
            super.handleJFacePreferencesChange(event);
        }
    }

    public static void openFileInEditor(File file, int lineNoToReveal) {
        if (!file.exists()) {
            Activator.showError(NLS.bind((String)UIText.DiffViewer_FileDoesNotExist, (Object)file.getPath()), null);
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = EgitUiEditorUtils.openEditor(file, page);
        EgitUiEditorUtils.revealLine(editor, lineNoToReveal);
    }

    public static void openInEditor(FileDiff d, DiffEntry.Side side, int lineNoToReveal) {
        ObjectId[] blobs = d.getBlobs();
        switch (side) {
            case OLD: {
                DiffViewer.openInEditor(d.getRepository(), d.getOldPath(), d.getCommit().getParent(0), blobs[0], lineNoToReveal);
                break;
            }
            default: {
                DiffViewer.openInEditor(d.getRepository(), d.getNewPath(), d.getCommit(), blobs[blobs.length - 1], lineNoToReveal);
            }
        }
    }

    private static void openInEditor(Repository repository, String path, RevCommit commit, ObjectId blob, int reveal) {
        try {
            IFileRevision rev = CompareUtils.getFileRevision(path, commit, repository, blob);
            if (rev == null) {
                String message = NLS.bind((String)UIText.DiffViewer_notContainedInCommit, (Object)path, (Object)commit.getName());
                Activator.showError(message, null);
                return;
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IEditorPart editor = EgitUiEditorUtils.openEditor(page, rev, (IProgressMonitor)new NullProgressMonitor());
            EgitUiEditorUtils.revealLine(editor, reveal);
        }
        catch (IOException | CoreException e) {
            Activator.handleError(UIText.GitHistoryPage_openFailed, e, true);
        }
    }

    public static void showTwoWayFileDiff(FileDiff d) {
        ObjectId newObjectId;
        RevCommit newCommit;
        ObjectId oldObjectId;
        RevCommit oldCommit;
        ObjectId[] blobs = d.getBlobs();
        if (blobs.length > 2) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIText.CommitFileDiffViewer_CanNotOpenCompareEditorTitle, (String)UIText.CommitFileDiffViewer_MergeCommitMultiAncestorMessage);
            return;
        }
        String np = d.getNewPath();
        String op = d.getOldPath();
        RevCommit c = d.getCommit();
        if (!d.getChange().equals((Object)DiffEntry.ChangeType.ADD)) {
            oldCommit = c.getParent(0);
            oldObjectId = blobs[0];
        } else {
            oldCommit = null;
            oldObjectId = null;
        }
        if (d.getChange().equals((Object)DiffEntry.ChangeType.DELETE)) {
            newCommit = null;
            newObjectId = null;
        } else {
            newCommit = c;
            newObjectId = blobs[blobs.length - 1];
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        Repository repository = d.getRepository();
        if (oldCommit != null && newCommit != null && repository != null) {
            IFile file = np != null ? ResourceUtil.getFileForLocation((Repository)repository, (String)np, (boolean)false) : null;
            try {
                if (file != null) {
                    CompareUtils.compare(file, repository, np, op, newCommit.getName(), oldCommit.getName(), false, page);
                } else {
                    CompareUtils.compareBetween(repository, np, op, newCommit.getName(), oldCommit.getName(), page);
                }
            }
            catch (IOException e) {
                Activator.handleError(UIText.GitHistoryPage_openFailed, e, true);
            }
            return;
        }
        ITypedElement oldSide = DiffViewer.createTypedElement(repository, op, oldCommit, oldObjectId);
        ITypedElement newSide = DiffViewer.createTypedElement(repository, np, newCommit, newObjectId);
        CompareUtils.openInCompare(page, (CompareEditorInput)new GitCompareFileRevisionEditorInput(newSide, oldSide, null));
    }

    private static ITypedElement createTypedElement(Repository repository, String path, RevCommit commit, ObjectId objectId) {
        if (commit != null) {
            return CompareUtils.getFileRevisionTypedElement(path, commit, repository, objectId);
        }
        return new GitCompareFileRevisionEditorInput.EmptyTypedElement("");
    }

    private static class CompareLink
    extends RevealLink {
        protected final FileDiff fileDiff;

        public CompareLink(IRegion region, DiffRegionFormatter.FileDiffRegion fileRange, int lineNo) {
            super(region, lineNo);
            this.fileDiff = fileRange.getDiff();
        }

        public String getHyperlinkText() {
            return UIText.DiffViewer_OpenComparisonLinkLabel;
        }

        public void open() {
            DiffViewer.showTwoWayFileDiff(this.fileDiff);
        }
    }

    public static class Configuration
    extends HyperlinkSourceViewer.Configuration {
        public Configuration(IPreferenceStore preferenceStore) {
            super(preferenceStore);
        }

        public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
            return 0;
        }

        @Override
        protected IHyperlinkDetector[] internalGetHyperlinkDetectors(ISourceViewer sourceViewer) {
            Assert.isTrue((boolean)(sourceViewer instanceof DiffViewer));
            IHyperlinkDetector[] result = new IHyperlinkDetector[]{new HyperlinkDetector()};
            return result;
        }

        public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
            Assert.isTrue((boolean)(sourceViewer instanceof DiffViewer));
            DiffViewer viewer = (DiffViewer)sourceViewer;
            return viewer.tokens.keySet().toArray(new String[0]);
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            Assert.isTrue((boolean)(sourceViewer instanceof DiffViewer));
            DiffViewer viewer = (DiffViewer)sourceViewer;
            PresentationReconciler reconciler = new PresentationReconciler();
            reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning((ISourceViewer)viewer));
            for (String contentType : viewer.tokens.keySet()) {
                DefaultDamagerRepairer damagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(() -> (IToken)viewer.tokens.get(contentType)));
                reconciler.setDamager((IPresentationDamager)damagerRepairer, contentType);
                reconciler.setRepairer((IPresentationRepairer)damagerRepairer, contentType);
            }
            return reconciler;
        }
    }

    private static class FileLink
    extends RevealLink {
        private final File file;

        public FileLink(IRegion region, File file, int lineNo) {
            super(region, lineNo);
            this.file = file;
        }

        public String getHyperlinkText() {
            return UIText.DiffViewer_OpenWorkingTreeLinkLabel;
        }

        public void open() {
            DiffViewer.openFileInEditor(this.file, this.lineNo);
        }
    }

    private class FixedRulerLayout
    extends SourceViewer.RulerLayout {
        public FixedRulerLayout(int gap) {
            super((SourceViewer)DiffViewer.this, gap);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle bounds = composite.getBounds();
            if (bounds.width == 0 || bounds.height == 0) {
                return;
            }
            super.layout(composite, flushCache);
        }
    }

    private static class HyperlinkDetector
    extends AbstractHyperlinkDetector
    implements IHyperlinkDetectorExtension2 {
        private final Pattern HUNK_LINE_PATTERN = Pattern.compile("@@ ([-+]?(\\d+),\\d+) ([-+]?(\\d+),\\d+) @@");

        private HyperlinkDetector() {
        }

        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            IDocument document = textViewer.getDocument();
            if (!(document instanceof DiffDocument) || document.getLength() == 0) {
                return null;
            }
            DiffDocument diffDocument = (DiffDocument)document;
            DiffRegionFormatter.DiffRegion[] regions = diffDocument.getRegions();
            DiffRegionFormatter.FileDiffRegion[] fileRegions = diffDocument.getFileRegions();
            if (regions == null || regions.length == 0 || fileRegions == null || fileRegions.length == 0) {
                return null;
            }
            int start = region.getOffset();
            int end = region.getOffset() + region.getLength();
            DiffRegionFormatter.DiffRegion key = new DiffRegionFormatter.DiffRegion(start, 0);
            int i = Arrays.binarySearch(regions, key, (a, b) -> {
                if (a.getOffset() > b.getOffset() + b.getLength()) {
                    return 1;
                }
                if (a.getOffset() + a.getLength() < b.getOffset()) {
                    return -1;
                }
                return 0;
            });
            ArrayList<IHyperlink> links = new ArrayList<IHyperlink>();
            DiffRegionFormatter.FileDiffRegion fileRange = null;
            while (i >= 0 && i < regions.length) {
                DiffRegionFormatter.DiffRegion range = regions[i];
                if (range.getOffset() >= end) break;
                if (range.getOffset() + range.getLength() > start) {
                    block0 : switch (range.getType()) {
                        case HEADLINE: {
                            Region linkRegion;
                            fileRange = this.findFileRange(diffDocument, fileRange, range.getOffset());
                            if (fileRange == null) break;
                            DiffEntry.ChangeType change = fileRange.getDiff().getChange();
                            switch (change) {
                                case ADD: 
                                case DELETE: {
                                    break block0;
                                }
                            }
                            if (!this.getString(document, range.getOffset(), range.getLength()).startsWith("diff") || !TextUtilities.overlaps((IRegion)region, (IRegion)(linkRegion = new Region(range.getOffset(), 4)))) break;
                            links.add(new CompareLink((IRegion)linkRegion, fileRange, -1));
                            break;
                        }
                        case HEADER: {
                            fileRange = this.findFileRange(diffDocument, fileRange, range.getOffset());
                            if (fileRange == null) break;
                            String line = this.getString(document, range.getOffset(), range.getLength());
                            this.createHeaderLinks((DiffDocument)document, region, fileRange, range, line, DiffEntry.Side.OLD, links);
                            this.createHeaderLinks((DiffDocument)document, region, fileRange, range, line, DiffEntry.Side.NEW, links);
                            break;
                        }
                        case HUNK: {
                            Matcher m;
                            String line;
                            fileRange = this.findFileRange(diffDocument, fileRange, range.getOffset());
                            if (fileRange == null || !(m = this.HUNK_LINE_PATTERN.matcher(line = this.getString(document, range.getOffset(), range.getLength()))).find()) break;
                            int lineOffset = this.getContextLines(document, range, i + 1 < regions.length ? regions[i + 1] : null);
                            this.createHunkLinks(region, fileRange, range, m, lineOffset, links);
                            break;
                        }
                    }
                }
                ++i;
            }
            if (links.isEmpty()) {
                return null;
            }
            return links.toArray(new IHyperlink[0]);
        }

        private String getString(IDocument document, int offset, int length) {
            try {
                return document.get(offset, length);
            }
            catch (BadLocationException e) {
                return "";
            }
        }

        private int getContextLines(IDocument document, DiffRegionFormatter.DiffRegion hunk, DiffRegionFormatter.DiffRegion next) {
            if (next != null) {
                try {
                    switch (next.getType()) {
                        case CONTEXT: {
                            int nofLines = document.getNumberOfLines(next.getOffset(), next.getLength());
                            return nofLines - 1;
                        }
                        case ADD: 
                        case REMOVE: {
                            int hunkLine = document.getLineOfOffset(hunk.getOffset());
                            int diffLine = document.getLineOfOffset(next.getOffset());
                            return diffLine - hunkLine - 1;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return 0;
        }

        private DiffRegionFormatter.FileDiffRegion findFileRange(DiffDocument document, DiffRegionFormatter.FileDiffRegion candidate, int offset) {
            if (candidate != null && TextUtilities.overlaps((IRegion)candidate, (IRegion)new Region(offset, 0))) {
                return candidate;
            }
            return document.findFileRegion(offset);
        }

        private void createHeaderLinks(DiffDocument document, IRegion region, DiffRegionFormatter.FileDiffRegion fileRange, DiffRegionFormatter.DiffRegion range, String line, @NonNull DiffEntry.Side side, List<IHyperlink> links) {
            Region linkRegion;
            Matcher m;
            Pattern p = document.getPathPattern(side);
            if (p == null) {
                return;
            }
            DiffEntry.ChangeType change = fileRange.getDiff().getChange();
            switch (side) {
                case OLD: {
                    if (change != DiffEntry.ChangeType.ADD) break;
                    return;
                }
                default: {
                    if (change != DiffEntry.ChangeType.DELETE) break;
                    return;
                }
            }
            if ((m = p.matcher(line)).find() && TextUtilities.overlaps((IRegion)region, (IRegion)(linkRegion = new Region(range.getOffset() + m.start(), m.end() - m.start())))) {
                File file;
                if (side == DiffEntry.Side.NEW && (file = new Path(fileRange.getDiff().getRepository().getWorkTree().getAbsolutePath()).append(fileRange.getDiff().getNewPath()).toFile()).exists()) {
                    links.add(new FileLink((IRegion)linkRegion, file, -1));
                }
                links.add(new OpenLink((IRegion)linkRegion, fileRange, side, -1));
            }
        }

        private void createHunkLinks(IRegion region, DiffRegionFormatter.FileDiffRegion fileRange, DiffRegionFormatter.DiffRegion range, Matcher m, int lineOffset, List<IHyperlink> links) {
            int lineNo;
            Region linkRegion;
            DiffEntry.ChangeType change = fileRange.getDiff().getChange();
            if (change != DiffEntry.ChangeType.ADD && TextUtilities.overlaps((IRegion)(linkRegion = new Region(range.getOffset() + m.start(1), m.end(1) - m.start(1))), (IRegion)region)) {
                lineNo = Integer.parseInt(m.group(2)) - 1 + lineOffset;
                if (change != DiffEntry.ChangeType.DELETE) {
                    links.add(new CompareLink((IRegion)linkRegion, fileRange, lineNo));
                }
                links.add(new OpenLink((IRegion)linkRegion, fileRange, DiffEntry.Side.OLD, lineNo));
            }
            if (change != DiffEntry.ChangeType.DELETE && TextUtilities.overlaps((IRegion)(linkRegion = new Region(range.getOffset() + m.start(3), m.end(3) - m.start(3))), (IRegion)region)) {
                File file;
                lineNo = Integer.parseInt(m.group(4)) - 1 + lineOffset;
                if (change != DiffEntry.ChangeType.ADD) {
                    links.add(new CompareLink((IRegion)linkRegion, fileRange, lineNo));
                }
                if ((file = new Path(fileRange.getDiff().getRepository().getWorkTree().getAbsolutePath()).append(fileRange.getDiff().getNewPath()).toFile()).exists()) {
                    links.add(new FileLink((IRegion)linkRegion, file, lineNo));
                }
                links.add(new OpenLink((IRegion)linkRegion, fileRange, DiffEntry.Side.NEW, lineNo));
            }
        }

        public int getStateMask() {
            return -1;
        }
    }

    private static class OpenLink
    extends CompareLink {
        private final DiffEntry.Side side;

        public OpenLink(IRegion region, DiffRegionFormatter.FileDiffRegion fileRange, DiffEntry.Side side, int lineNo) {
            super(region, fileRange, lineNo);
            this.side = side;
        }

        @Override
        public String getHyperlinkText() {
            switch (this.side) {
                case OLD: {
                    return UIText.DiffViewer_OpenPreviousLinkLabel;
                }
            }
            return UIText.DiffViewer_OpenInEditorLinkLabel;
        }

        @Override
        public void open() {
            DiffViewer.openInEditor(this.fileDiff, this.side, this.lineNo);
        }
    }

    private static abstract class RevealLink
    implements IHyperlink {
        private final IRegion region;
        protected final int lineNo;

        protected RevealLink(IRegion region, int lineNo) {
            this.region = region;
            this.lineNo = lineNo;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }
    }

    private static class SingleTokenScanner
    implements ITokenScanner {
        private final Supplier<IToken> token;
        private int currentOffset;
        private int end;
        private int tokenStart;

        public SingleTokenScanner(Supplier<IToken> supplier) {
            this.token = supplier;
        }

        public void setRange(IDocument document, int offset, int length) {
            this.currentOffset = offset;
            this.end = offset + length;
            this.tokenStart = -1;
        }

        public IToken nextToken() {
            this.tokenStart = this.currentOffset;
            if (this.currentOffset < this.end) {
                this.currentOffset = this.end;
                return this.token.get();
            }
            return Token.EOF;
        }

        public int getTokenOffset() {
            return this.tokenStart;
        }

        public int getTokenLength() {
            return this.currentOffset - this.tokenStart;
        }
    }
}

