/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.util.EAnnotations;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.impl.DynamicSetupTaskImpl;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.ui.SelfCommitContext;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.ConfirmationPage;
import org.eclipse.oomph.ui.BackgroundProgressPart;
import org.eclipse.oomph.ui.ButtonBar;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnablementComposite
extends Composite {
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final BaseEditUtil.IconReflectiveItemProvider iconItemProvider = BaseEditUtil.replaceReflectiveItemProvider((ComposedAdapterFactory)this.adapterFactory);
    private TreeViewer treeViewer;
    private Button offlineButton;
    private Boolean offlineProperty;
    private Button mirrorsButton;
    private Boolean mirrorsProperty;
    private ProgressMonitorPart progressMonitorPart;
    private InputData inputData;
    private InstallOperation installOperation;

    public EnablementComposite(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)UIUtil.createGridLayout((int)1));
        this.treeViewer = new TreeViewer((Composite)this, style);
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        AccessUtil.setKey((Widget)tree, (Object)"tree");
        ButtonBar buttonBar = new ButtonBar(this){

            protected IDialogSettings getDialogSettings() {
                return EnablementComposite.this.getDialogSettings();
            }
        };
        this.offlineProperty = PropertiesUtil.getBoolean((String)"oomph.setup.offline");
        if (this.offlineProperty == null) {
            this.offlineButton = buttonBar.addCheckButton("Offline", "Avoid unnecessary network requests during the installation process", false, "toggleCommand:org.eclipse.oomph.ui.ToggleOfflineMode");
            AccessUtil.setKey((Widget)this.offlineButton, (Object)"offline");
        }
        this.mirrorsProperty = PropertiesUtil.getBoolean((String)"eclipse.p2.mirrors");
        if (this.mirrorsProperty == null) {
            this.mirrorsButton = buttonBar.addCheckButton("Mirrors", "Make use of p2 mirrors during the installation process", true, "mirrors");
            AccessUtil.setKey((Widget)this.mirrorsButton, (Object)"mirrors");
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EnablementComposite.this.adapterFactory.dispose();
            }
        });
    }

    public final boolean isOffline() {
        return ConfirmationPage.getProperty("oomph.setup.offline.startup", this.offlineProperty, this.offlineButton);
    }

    public final boolean isMirrors() {
        return ConfirmationPage.getProperty("oomph.setup.mirrors.startup", this.mirrorsProperty, this.mirrorsButton);
    }

    public final InputData setInput(EList<SetupTask> tasks) {
        return this.setInput(EnablementComposite.getEnablementTasks(tasks));
    }

    public final InputData setInput(Map<EClass, EList<SetupTask>> enablementTasks) {
        if (enablementTasks.isEmpty()) {
            this.treeViewer.setInput(null);
            this.inputData = null;
            return null;
        }
        this.inputData = new InputData();
        final HashMap<EClass, ClassItemProvider> classItemProviders = new HashMap<EClass, ClassItemProvider>();
        ItemProvider root = new ItemProvider((AdapterFactory)this.adapterFactory);
        EList children = root.getChildren();
        for (Map.Entry<EClass, EList<SetupTask>> entry : enablementTasks.entrySet()) {
            EClass eClass = entry.getKey();
            EList<SetupTask> list = entry.getValue();
            this.inputData.enablementTasks.addAll(list);
            String typeText = EAnnotations.getText((EClass)eClass);
            if (typeText == null) {
                try {
                    EObject dynamicSetupTask = EcoreUtil.create((EClass)eClass);
                    typeText = this.iconItemProvider.getTypeText((Object)dynamicSetupTask);
                }
                catch (Throwable throwable) {
                    typeText = eClass.getName();
                }
            }
            ClassItemProvider classItemProvider = new ClassItemProvider((AdapterFactory)this.adapterFactory, eClass, typeText, list);
            children.add((Object)classItemProvider);
            classItemProviders.put(eClass, classItemProvider);
        }
        if (this.inputData.enablementTasks.isEmpty()) {
            this.treeViewer.setInput(null);
            this.inputData = null;
            return null;
        }
        this.treeViewer.setInput((Object)root);
        final Tree tree = this.treeViewer.getTree();
        UIUtil.asyncExec((Control)tree, (Runnable)new Runnable(){

            public void run() {
                EnablementComposite.this.treeViewer.expandAll();
                final ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(classItemProviders.values());
                int jobs = Math.max(queue.size(), 10);
                int i = 0;
                while (i < jobs) {
                    Job iconLoader = new Job("IconLoader-" + i){

                        protected IStatus run(IProgressMonitor monitor) {
                            ClassItemProvider classItemProvider;
                            while ((classItemProvider = (ClassItemProvider)((Object)queue.poll())) != null && !tree.isDisposed() && !monitor.isCanceled()) {
                                classItemProvider.loadImage();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    iconLoader.setSystem(true);
                    iconLoader.schedule();
                    ++i;
                }
            }
        });
        return this.inputData;
    }

    public InstallOperation install(final InstallHandler handler) {
        if (this.inputData == null || this.inputData.repositories.isEmpty() && this.inputData.requirements.isEmpty()) {
            return null;
        }
        this.installOperation = new InstallOperation(this.inputData);
        this.enableButtons(false);
        this.progressMonitorPart = new BackgroundProgressPart(this, null, true){

            public boolean isCanceled() {
                return ((EnablementComposite)EnablementComposite.this).installOperation.canceled || super.isCanceled();
            }
        };
        this.progressMonitorPart.attachToCancelComponent(null);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        AccessUtil.setKey((Widget)this.progressMonitorPart, (Object)"progress");
        this.layout();
        Job job = new Job("Install extensions"){

            /*
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                block10: {
                    try {
                        ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
                        SetupContext setupContext = SetupContext.createUserOnly((ResourceSet)resourceSet);
                        User user = setupContext.getUser();
                        Agent agent = P2Util.getAgentManager().getCurrentAgent();
                        Profile profile = agent.getCurrentProfile();
                        ProfileTransaction transaction = profile.change();
                        SelfCommitContext commitContext = new SelfCommitContext(user);
                        transaction = commitContext.migrateProfile(transaction);
                        boolean mirrors = EnablementComposite.this.isMirrors();
                        transaction.setMirrors(mirrors);
                        ProfileDefinition profileDefinition = transaction.getProfileDefinition();
                        EList profileRepositories = profileDefinition.getRepositories();
                        for (String url : ((EnablementComposite)EnablementComposite.this).inputData.repositories) {
                            profileRepositories.add((Object)P2Factory.eINSTANCE.createRepository(url));
                        }
                        EList profileRequirements = profileDefinition.getRequirements();
                        for (Requirement requirement : ((EnablementComposite)EnablementComposite.this).inputData.requirements) {
                            profileRequirements.add((Object)requirement);
                        }
                        transaction.commit((ProfileTransaction.CommitContext)commitContext, (IProgressMonitor)EnablementComposite.this.progressMonitorPart);
                    }
                    catch (OperationCanceledException ex) {
                        ((EnablementComposite)EnablementComposite.this).installOperation.exception = ex;
                        ((EnablementComposite)EnablementComposite.this).installOperation.canceled = true;
                        ((EnablementComposite)EnablementComposite.this).installOperation.done = true;
                        UIUtil.syncExec((Runnable)new Runnable(handler){
                            private final /* synthetic */ InstallHandler val$handler;
                            {
                                this.val$handler = installHandler;
                            }

                            public void run() {
                                try {
                                    EnablementComposite.this.enableButtons(true);
                                    EnablementComposite.this.progressMonitorPart.dispose();
                                    EnablementComposite.this.layout();
                                    if (this.val$handler != null) {
                                        if (((EnablementComposite)(this).EnablementComposite.this).installOperation.exception instanceof OperationCanceledException) {
                                            this.val$handler.installCanceled();
                                        } else if (((EnablementComposite)(this).EnablementComposite.this).installOperation.exception != null) {
                                            this.val$handler.installFailed(((EnablementComposite)(this).EnablementComposite.this).installOperation.exception);
                                        } else {
                                            this.val$handler.installSucceeded();
                                        }
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        });
                        EnablementComposite.this.progressMonitorPart = null;
                        EnablementComposite.this.installOperation = null;
                        break block10;
                    }
                    catch (CoreException ex) {
                        ((EnablementComposite)EnablementComposite.this).installOperation.exception = ex;
                        IStatus iStatus = ex.getStatus();
                        ((EnablementComposite)EnablementComposite.this).installOperation.done = true;
                        UIUtil.syncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                        EnablementComposite.this.progressMonitorPart = null;
                        EnablementComposite.this.installOperation = null;
                        return iStatus;
                    }
                    catch (Throwable ex) {
                        ((EnablementComposite)EnablementComposite.this).installOperation.exception = ex;
                        IStatus iStatus = SetupUIPlugin.INSTANCE.getStatus(ex);
                        ((EnablementComposite)EnablementComposite.this).installOperation.done = true;
                        {
                            catch (Throwable throwable) {
                                ((EnablementComposite)EnablementComposite.this).installOperation.done = true;
                                UIUtil.syncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                                EnablementComposite.this.progressMonitorPart = null;
                                EnablementComposite.this.installOperation = null;
                                throw throwable;
                            }
                        }
                        UIUtil.syncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                        EnablementComposite.this.progressMonitorPart = null;
                        EnablementComposite.this.installOperation = null;
                        return iStatus;
                    }
                    ((EnablementComposite)EnablementComposite.this).installOperation.done = true;
                    UIUtil.syncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                    EnablementComposite.this.progressMonitorPart = null;
                    EnablementComposite.this.installOperation = null;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return this.installOperation;
    }

    protected IDialogSettings getDialogSettings() {
        return SetupUIPlugin.INSTANCE.getDialogSettings(EnablementComposite.class.getSimpleName());
    }

    private void enableButtons(boolean enabled) {
        this.offlineButton.setEnabled(enabled);
        this.mirrorsButton.setEnabled(enabled);
    }

    public static Map<EClass, EList<SetupTask>> getEnablementTasks(EList<SetupTask> tasks) {
        HashMap<EClass, EList<SetupTask>> result = new HashMap<EClass, EList<SetupTask>>();
        for (SetupTask task : tasks) {
            EList enablementTasks;
            EClass eClass;
            if (!(task instanceof DynamicSetupTaskImpl) || result.containsKey(eClass = task.eClass()) || (enablementTasks = SetupTaskPerformer.createEnablementTasks((EModelElement)eClass, (boolean)true)) == null || enablementTasks.isEmpty()) continue;
            result.put(eClass, (EList<SetupTask>)enablementTasks);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassItemProvider
    extends ItemProvider {
        private final EClass eClass;

        public ClassItemProvider(AdapterFactory adapterFactory, EClass eClass, String typeText, EList<SetupTask> enablementTasks) {
            super(adapterFactory, typeText, SetupUIPlugin.INSTANCE.getImage(SetupPackage.Literals.SETUP_TASK.isSuperTypeOf(eClass) ? "full/obj16/SetupTask" : "full/obj16/EObject"));
            this.eClass = eClass;
            HashMap requirements = new HashMap();
            ArrayList extraRequirements = new ArrayList();
            int size = enablementTasks.size();
            int i = 0;
            while (i < size) {
                SetupTask task = (SetupTask)enablementTasks.get(i);
                if (task instanceof P2Task) {
                    P2Task p2Task = (P2Task)task;
                    EList repositories = p2Task.getRepositories();
                    if (repositories.isEmpty()) {
                        extraRequirements.addAll(p2Task.getRequirements());
                    } else {
                        VariableTask variableTask;
                        SetupTask nextTask;
                        Repository repository = (Repository)repositories.get(0);
                        String url = repository.getURL();
                        if (url.startsWith("${") && i + 1 < size && (nextTask = (SetupTask)enablementTasks.get(i + 1)) instanceof VariableTask && url.equals("${" + (variableTask = (VariableTask)nextTask).getName() + "}")) {
                            url = variableTask.getValue();
                        }
                        if (url.equals("${oomph.update.url}")) {
                            url = SetupCorePlugin.UPDATE_URL;
                        }
                        CollectionUtil.addAll(requirements, (Object)url, (Collection)p2Task.getRequirements());
                        ((EnablementComposite)EnablementComposite.this).inputData.requirements.addAll((Collection<Requirement>)p2Task.getRequirements());
                    }
                }
                ++i;
            }
            ArrayList urls = new ArrayList(requirements.keySet());
            Collections.sort(urls);
            ((EnablementComposite)EnablementComposite.this).inputData.repositories.addAll(urls);
            EList children = this.getChildren();
            Image repositoryImage = SetupUIPlugin.INSTANCE.getSWTImage("full/obj16/Repository");
            for (String url : urls) {
                ItemProvider repository = new ItemProvider(url, (Object)repositoryImage);
                repository.getChildren().addAll((Collection)requirements.get(url));
                children.add((Object)repository);
            }
            children.addAll(extraRequirements);
        }

        public void loadImage() {
            URI imageURI = EAnnotations.getImageURI((EClass)this.eClass);
            if (imageURI != null) {
                Image image = ExtendedImageRegistry.INSTANCE.getImage(BaseEditUtil.getImage((URI)imageURI));
                this.setImage(image);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class InputData {
        final EList<SetupTask> enablementTasks = new BasicEList();
        final Set<String> repositories = new HashSet<String>();
        final Set<Requirement> requirements = new HashSet<Requirement>();

        public EList<SetupTask> getEnablementTasks() {
            return this.enablementTasks;
        }

        public Set<String> getRepositories() {
            return this.repositories;
        }

        public Set<Requirement> getRequirements() {
            return this.requirements;
        }
    }

    public static interface InstallHandler {
        public void installSucceeded();

        public void installFailed(Throwable var1);

        public void installCanceled();
    }

    public static final class InstallOperation {
        private final InputData inputData;
        boolean canceled;
        boolean done;
        Throwable exception;

        InstallOperation(InputData inputData) {
            this.inputData = inputData;
        }

        public void cancel() {
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public boolean isDone() {
            return this.done;
        }

        public Throwable getException() {
            return this.exception;
        }

        public InputData getInputData() {
            return this.inputData;
        }
    }
}

