/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Sash;
import java.io.IOException;
import java.io.ObjectInputStream;

public class HomeDoorOrWindow
extends HomePieceOfFurniture
implements DoorOrWindow {
    private static final long serialVersionUID = 1L;
    private float wallThickness;
    private float wallDistance;
    private float wallWidth;
    private float wallLeft;
    private float wallHeight;
    private float wallTop;
    private boolean wallCutOutOnBothSides;
    private boolean widthDepthDeformable;
    private Sash[] sashes;
    private String cutOutShape;
    private boolean boundToWall;

    public HomeDoorOrWindow(DoorOrWindow doorOrWindow) {
        super(doorOrWindow);
        this.wallThickness = doorOrWindow.getWallThickness();
        this.wallDistance = doorOrWindow.getWallDistance();
        this.wallWidth = 1.0f;
        this.wallLeft = 0.0f;
        this.wallHeight = 1.0f;
        this.wallTop = 0.0f;
        this.wallCutOutOnBothSides = doorOrWindow.isWallCutOutOnBothSides();
        this.widthDepthDeformable = doorOrWindow.isWidthDepthDeformable();
        this.sashes = doorOrWindow.getSashes();
        this.cutOutShape = doorOrWindow.getCutOutShape();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.cutOutShape = "M0,0 v1 h1 v-1 z";
        this.widthDepthDeformable = true;
        this.wallWidth = 1.0f;
        this.wallLeft = 0.0f;
        this.wallHeight = 1.0f;
        this.wallTop = 0.0f;
        objectInputStream.defaultReadObject();
    }

    @Override
    public float getWallThickness() {
        return this.wallThickness;
    }

    public void setWallThickness(float f) {
        this.wallThickness = f;
    }

    @Override
    public float getWallDistance() {
        return this.wallDistance;
    }

    public void setWallDistance(float f) {
        this.wallDistance = f;
    }

    public float getWallWidth() {
        return this.wallWidth;
    }

    public void setWallWidth(float f) {
        this.wallWidth = f;
    }

    public float getWallLeft() {
        return this.wallLeft;
    }

    public void setWallLeft(float f) {
        this.wallLeft = f;
    }

    public float getWallHeight() {
        return this.wallHeight;
    }

    public void setWallHeight(float f) {
        this.wallHeight = f;
    }

    public float getWallTop() {
        return this.wallTop;
    }

    public void setWallTop(float f) {
        this.wallTop = f;
    }

    @Override
    public Sash[] getSashes() {
        if (this.sashes.length == 0) {
            return this.sashes;
        }
        return (Sash[])this.sashes.clone();
    }

    public void setSashes(Sash[] sashArray) {
        this.sashes = sashArray.length == 0 ? sashArray : (Sash[])sashArray.clone();
    }

    @Override
    public String getCutOutShape() {
        return this.cutOutShape;
    }

    @Override
    public boolean isWallCutOutOnBothSides() {
        return this.wallCutOutOnBothSides;
    }

    @Override
    public boolean isWidthDepthDeformable() {
        return this.widthDepthDeformable;
    }

    public boolean isBoundToWall() {
        return this.boundToWall;
    }

    public void setBoundToWall(boolean bl) {
        this.boundToWall = bl;
    }

    @Override
    public void setX(float f) {
        if (this.getX() != f) {
            this.boundToWall = false;
        }
        super.setX(f);
    }

    @Override
    public void setY(float f) {
        if (this.getY() != f) {
            this.boundToWall = false;
        }
        super.setY(f);
    }

    @Override
    public void setAngle(float f) {
        if (this.getAngle() != f) {
            this.boundToWall = false;
        }
        super.setAngle(f);
    }

    @Override
    public void setDepth(float f) {
        if (this.getDepth() != f) {
            this.boundToWall = false;
        }
        super.setDepth(f);
    }

    @Override
    public boolean isDoorOrWindow() {
        return true;
    }

    @Override
    public HomeDoorOrWindow clone() {
        HomeDoorOrWindow homeDoorOrWindow = (HomeDoorOrWindow)super.clone();
        homeDoorOrWindow.boundToWall = false;
        return homeDoorOrWindow;
    }
}

