/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.HexaShape;
import net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.PentaAShape;
import net.sourceforge.plantuml.timingdiagram.PentaBShape;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeDrawing;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Ribbon
implements TimeDrawing {
    private final List<ChangeState> changes = new ArrayList<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private final double delta = 12.0;
    private final ISkinParam skinParam;
    private final TimingRuler ruler;
    private String initialState;
    private Colors initialColors;
    private final List<TimingNote> notes;

    public Ribbon(TimingRuler ruler, ISkinParam skinParam, List<TimingNote> notes) {
        this.ruler = ruler;
        this.skinParam = skinParam;
        this.notes = notes;
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        double x = this.ruler.getPosInPixel(tick);
        double y = 6.0 + this.getHeightForConstraints();
        for (ChangeState change : this.changes) {
            if (change.getWhen().compareTo(tick) != 0) continue;
            return new IntricatedPoint(new Point2D.Double(x, y), new Point2D.Double(x, y));
        }
        return new IntricatedPoint(new Point2D.Double(x, y - 12.0), new Point2D.Double(x, y + 12.0));
    }

    @Override
    public void addChange(ChangeState change) {
        this.changes.add(change);
    }

    private double getPosInPixel(ChangeState change) {
        return this.ruler.getPosInPixel(change.getWhen());
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.TIMING, null);
    }

    private TextBlock createTextBlock(String value) {
        Display display = Display.getWithNewlines(value);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    @Override
    public void drawU(UGraphic ug) {
        double a;
        TextBlock initial;
        StringBounder stringBounder = ug.getStringBounder();
        double halfDelta = 6.0;
        this.drawNotes(ug.apply(new UTranslate(0.0, -12.0)), Position.TOP);
        double ribbonHeight = this.getRibbonHeight();
        UGraphic ugDown = ug.apply(new UTranslate(0.0, this.getHeightForConstraints() + this.getHeightForNotes(stringBounder, Position.TOP)));
        if (this.initialState == null) {
            initial = null;
        } else {
            initial = this.createTextBlock(this.initialState);
            if (this.changes.size() > 0) {
                double a2 = this.getPosInPixel(this.changes.get(0));
                this.drawPentaA(ugDown.apply(new UTranslate(-this.getInitialWidth(stringBounder), -6.0)), this.getInitialWidth(stringBounder) + a2, this.changes.get(0));
            }
        }
        for (int i = 0; i < this.changes.size() - 1; ++i) {
            a = this.getPosInPixel(this.changes.get(i));
            double b = this.getPosInPixel(this.changes.get(i + 1));
            assert (b > a);
            if (this.changes.get(i).isFlat()) {
                this.drawFlat(ugDown.apply(new UTranslate(a, -6.0)), b - a, this.changes.get(i));
                continue;
            }
            if (this.changes.get(i).isCompletelyHidden()) continue;
            this.drawHexa(ugDown.apply(new UTranslate(a, -6.0)), b - a, this.changes.get(i));
        }
        if (this.changes.size() >= 1) {
            ChangeState last = this.changes.get(this.changes.size() - 1);
            a = this.getPosInPixel(last);
            if (last.isFlat()) {
                this.drawFlat(ugDown.apply(new UTranslate(a, -6.0)), this.ruler.getWidth() - a, last);
            } else if (!last.isCompletelyHidden()) {
                this.drawPentaB(ugDown.apply(new UTranslate(a, -6.0)), this.ruler.getWidth() - a, last);
            }
        }
        ugDown = ugDown.apply(new UTranslate(0.0, 6.0));
        if (initial != null) {
            Dimension2D dimInital = initial.calculateDimension(stringBounder);
            initial.drawU(ugDown.apply(new UTranslate(-this.getDelta() - dimInital.getWidth(), -dimInital.getHeight() / 2.0)));
        }
        for (int i = 0; i < this.changes.size(); ++i) {
            String commentString;
            ChangeState change = this.changes.get(i);
            double x = this.ruler.getPosInPixel(change.getWhen());
            if (!(change.isBlank() || change.isCompletelyHidden() || change.isFlat())) {
                double xtext;
                TextBlock state = this.createTextBlock(change.getState());
                Dimension2D dim = state.calculateDimension(stringBounder);
                if (i == this.changes.size() - 1) {
                    xtext = x + this.getDelta();
                } else {
                    double x2 = this.ruler.getPosInPixel(this.changes.get(i + 1).getWhen());
                    xtext = (x + x2) / 2.0 - dim.getWidth() / 2.0;
                }
                state.drawU(ugDown.apply(new UTranslate(xtext, -dim.getHeight() / 2.0)));
            }
            if ((commentString = change.getComment()) == null) continue;
            TextBlock comment = this.createTextBlock(commentString);
            Dimension2D dimComment = comment.calculateDimension(stringBounder);
            comment.drawU(ugDown.apply(new UTranslate(x + this.getDelta(), -12.0 - dimComment.getHeight())));
        }
        for (TimeConstraint constraint : this.constraints) {
            constraint.drawU(ug.apply(new UTranslate(0.0, this.getHeightForConstraints() / 2.0)), this.ruler, this.skinParam);
        }
        this.drawNotes(ug.apply(new UTranslate(0.0, this.getHeightForConstraints() + this.getHeightForNotes(stringBounder, Position.TOP) + ribbonHeight)), Position.BOTTOM);
    }

    private void drawNotes(UGraphic ug, Position position) {
        for (TimingNote note : this.notes) {
            if (note.getPosition() != position) continue;
            double x = this.ruler.getPosInPixel(note.getWhen());
            note.drawU(ug.apply(new UTranslate(x, 0.0)));
        }
    }

    private double getInitialWidth(StringBounder stringBounder) {
        return this.createTextBlock(this.initialState).calculateDimension(stringBounder).getWidth() + this.getRibbonHeight();
    }

    private void drawHexa(UGraphic ug, double len, ChangeState change) {
        HexaShape shape = HexaShape.create(len, this.getRibbonHeight(), change.getContext());
        shape.drawU(ug);
    }

    private void drawFlat(UGraphic ug, double len, ChangeState change) {
        ULine line = new ULine(len, 0.0);
        change.getContext().apply(ug).apply(new UTranslate(0.0, this.getRibbonHeight() / 2.0)).draw(line);
    }

    private double getRibbonHeight() {
        return 24.0;
    }

    private void drawPentaB(UGraphic ug, double len, ChangeState change) {
        PentaBShape shape = PentaBShape.create(len, this.getRibbonHeight(), change.getContext());
        shape.drawU(ug);
    }

    private void drawPentaA(UGraphic ug, double len, ChangeState change) {
        SymbolContext context = change.getContext();
        HtmlColor back = this.initialColors.getColor(ColorType.BACK);
        if (back != null) {
            context = context.withBackColor(back);
        }
        PentaAShape shape = PentaAShape.create(len, this.getRibbonHeight(), context);
        shape.drawU(ug);
    }

    private double getHeightForConstraints() {
        if (this.constraints.size() == 0) {
            return 0.0;
        }
        return 30.0;
    }

    @Override
    public double getHeight(StringBounder stringBounder) {
        return 36.0 + this.getHeightForConstraints() + this.getHeightForNotes(stringBounder, Position.TOP) + this.getHeightForNotes(stringBounder, Position.BOTTOM);
    }

    private double getHeightForNotes(StringBounder stringBounder, Position position) {
        double height = 0.0;
        for (TimingNote note : this.notes) {
            if (note.getPosition() != position) continue;
            height = Math.max(height, note.getHeight(stringBounder));
        }
        return height;
    }

    public double getDelta() {
        return 12.0;
    }

    @Override
    public TextBlock getWidthHeader(StringBounder stringBounder) {
        if (this.initialState != null) {
            return TextBlockUtils.empty(this.getInitialWidth(stringBounder), this.getRibbonHeight());
        }
        return TextBlockUtils.empty(0.0, 0.0);
    }

    @Override
    public void setInitialState(String initialState, Colors initialColors) {
        this.initialState = initialState;
        this.initialColors = initialColors;
    }

    @Override
    public void addConstraint(TimeConstraint constraint) {
        this.constraints.add(constraint);
    }
}

