/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterFunctionCall;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;

public class InvokeVoidFunction
implements TFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%invoke_void_func", 1);
    }

    @Override
    public boolean canCover(int nbArg) {
        return nbArg > 0;
    }

    @Override
    public TFunctionType getFunctionType() {
        return TFunctionType.VOID;
    }

    @Override
    public void executeVoid(TContext context, TMemory memory, String s) throws EaterException {
        EaterFunctionCall call = new EaterFunctionCall(s, false, this.isUnquoted());
        call.execute(context, memory);
        List<TValue> values = call.getValues();
        String fname = values.get(0).toString();
        List<TValue> args = values.subList(1, values.size());
        TFunctionSignature signature = new TFunctionSignature(fname, args.size());
        TFunction func = context.getFunctionSmart(signature);
        if (func == null) {
            throw new EaterException("Cannot find void function " + fname);
        }
        func.executeVoidInternal(context, memory, args);
    }

    @Override
    public void executeVoidInternal(TContext context, TMemory memory, List<TValue> args) throws EaterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TValue executeReturn(TContext context, TMemory memory, List<TValue> args) throws EaterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUnquoted() {
        return false;
    }
}

