/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sprite;

import java.awt.Color;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;

public class ColorPalette4096 {
    private static final String colorValue = "!#$%&*+-:;<=>?@^_~GHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public String getStringFor(Color dest) {
        return this.getStringFor(new HtmlColorSimple(dest, false));
    }

    public String getStringFor(HtmlColor dest) {
        int result = 0;
        double resultDist = Double.MAX_VALUE;
        for (int i = 0; i < 4096; ++i) {
            double dist = ((HtmlColorSimple)dest).distance(this.getHtmlColorSimpleFor(i));
            if (!(dist < resultDist)) continue;
            result = i;
            resultDist = dist;
        }
        return this.encodeInt(result);
    }

    protected String encodeInt(int result) {
        int v2 = result % 64;
        int v1 = result / 64;
        assert (v1 >= 0 && v1 <= 63 && v2 >= 0 && v2 <= 63);
        return "" + colorValue.charAt(v1) + colorValue.charAt(v2);
    }

    private HtmlColorSimple getHtmlColorSimpleFor(int s) {
        Color color = this.getColorFor(s);
        if (color == null) {
            throw new IllegalArgumentException();
        }
        return new HtmlColorSimple(color, false);
    }

    public Color getColorFor(String s) {
        if (s.length() != 2) {
            throw new IllegalArgumentException();
        }
        int v1 = colorValue.indexOf(s.charAt(0));
        if (v1 == -1) {
            return null;
        }
        int v2 = colorValue.indexOf(s.charAt(1));
        if (v2 == -1) {
            return null;
        }
        int code = v1 * 64 + v2;
        return this.getColorFor(code);
    }

    protected Color getColorFor(int code) {
        int blue = code % 16;
        int green = code / 16 % 16;
        int red = code / 256 % 16;
        return new Color(this.dup(red), this.dup(green), this.dup(blue));
    }

    private int dup(int v) {
        assert (v >= 0 && v <= 15);
        return v * 16 + v;
    }
}

