/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.ISshClientSupport;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileSshSessionConnPool {
    private final HashMap<CloudAppIndexKey, SessionList> sessionMap = new HashMap();
    private final CloudFoundryServerBehaviour behaviour;
    private final AtomicInteger numberOfActiveConnections = new AtomicInteger();
    private final Object supportLock = new Object();
    private ISshClientSupport sshClientSupport;
    private final long MAX_ACTIVE_CONNECTIONS = 5L;
    private final long MAX_CONNECTION_ATTEMPT_TIME_IN_NANOS = TimeUnit.NANOSECONDS.convert(120L, TimeUnit.SECONDS);

    public FileSshSessionConnPool(CloudFoundryServerBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processSshSessionRequest(CloudApplication app, int instanceIndex, String path, boolean isDir, IProgressMonitor monitor) throws CoreException {
        SessionList value;
        CloudAppIndexKey key = new CloudAppIndexKey(app, instanceIndex);
        HashMap<CloudAppIndexKey, SessionList> hashMap = this.sessionMap;
        synchronized (hashMap) {
            value = this.sessionMap.get(key);
        }
        if (value == null) {
            value = new SessionList();
            hashMap = this.sessionMap;
            synchronized (hashMap) {
                this.sessionMap.put(key, value);
            }
        }
        return this.runWithSession(key, value, monitor, path, isDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runWithSession(CloudAppIndexKey key, SessionList value, IProgressMonitor monitor, String path, boolean isDir) throws CoreException {
        String fileResult = null;
        boolean requestProcessed = false;
        Throwable lastExceptionThrown = null;
        Session session = null;
        long expireTimeInNanos = System.nanoTime() + this.MAX_CONNECTION_ATTEMPT_TIME_IN_NANOS;
        while (!requestProcessed && System.nanoTime() < expireTimeInNanos) {
            session = value.acquireSessionIfAvailable().orElse(null);
            if (session != null) {
                RequestResult result = this.runWithSessionInner(value, session, path, isDir);
                requestProcessed = result.isRequestProcessed();
                fileResult = result.getResult();
                lastExceptionThrown = result.getLastExceptionThrown().orElse(null);
            } else {
                boolean areWeOverConnLimit = false;
                Object object = this.numberOfActiveConnections;
                synchronized (object) {
                    if ((long)this.numberOfActiveConnections.get() >= 5L) {
                        areWeOverConnLimit = true;
                    } else {
                        areWeOverConnLimit = false;
                        this.numberOfActiveConnections.incrementAndGet();
                    }
                }
                if (!areWeOverConnLimit) {
                    try {
                        object = this.supportLock;
                        synchronized (object) {
                            if (this.sshClientSupport == null) {
                                this.sshClientSupport = this.behaviour.getSshClientSupport(monitor);
                            }
                        }
                        session = this.sshClientSupport.connect(key.getApp().getName(), key.getIndex(), this.behaviour.getCloudFoundryServer().getServer(), monitor);
                        RequestResult result = this.runWithSessionInner(value, session, path, isDir);
                        requestProcessed = result.isRequestProcessed();
                        fileResult = result.getResult();
                        lastExceptionThrown = result.getLastExceptionThrown().orElse(null);
                    }
                    catch (CoreException e) {
                        lastExceptionThrown = e;
                    }
                }
            }
            if (requestProcessed) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!requestProcessed) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus(Messages.SshFileSessionPool_UNABLE_TO_ESTABLISH_CONNECTION, lastExceptionThrown));
        }
        return fileResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestResult runWithSessionInner(SessionList value, Session session, String path, boolean isDir) {
        boolean processed = false;
        boolean errorOccurred = false;
        Exception lastExceptionThrown = null;
        String result = null;
        try {
            Channel channel = session.openChannel("exec");
            try {
                String command = isDir ? "ls -p " + path : "cat " + path;
                ((ChannelExec)channel).setCommand(command);
                result = FileSshSessionConnPool.getContent(channel);
                processed = true;
            }
            finally {
                channel.disconnect();
            }
        }
        catch (Exception e) {
            errorOccurred = true;
            lastExceptionThrown = e;
        }
        if (errorOccurred) {
            try {
                session.disconnect();
            }
            catch (Exception exception) {}
            AtomicInteger atomicInteger = this.numberOfActiveConnections;
            synchronized (atomicInteger) {
                this.numberOfActiveConnections.decrementAndGet();
            }
        }
        value.releaseSession(session);
        return new RequestResult(processed, result, lastExceptionThrown);
    }

    private static String getContent(Channel channel) throws IOException, JSchException {
        InputStream in = null;
        OutputStream outStream = null;
        in = channel.getInputStream();
        channel.connect();
        try {
            if (in != null) {
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                outStream = new BufferedOutputStream(byteArrayOut);
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = in.read(buffer)) != -1) {
                    outStream.write(buffer, 0, bytesRead);
                }
                outStream.flush();
                byteArrayOut.flush();
                String string = byteArrayOut.toString();
                return string;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return null;
    }

    private static class CloudAppIndexKey {
        private final CloudApplication app;
        private final int index;

        public CloudAppIndexKey(CloudApplication app, int index) {
            this.app = app;
            this.index = index;
        }

        public CloudApplication getApp() {
            return this.app;
        }

        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            return this.app.hashCode() + this.index;
        }

        public boolean equals(Object o) {
            CloudAppIndexKey other = (CloudAppIndexKey)o;
            if (!other.app.equals(this.app)) {
                return false;
            }
            return this.index == other.index;
        }
    }

    private static class RequestResult {
        private final boolean requestProcessed;
        private final String userResult;
        private final Exception lastExceptionThrown;

        public RequestResult(boolean requestProcessed, String userResult, Exception lastExceptionThrown) {
            this.requestProcessed = requestProcessed;
            this.userResult = userResult;
            this.lastExceptionThrown = lastExceptionThrown;
        }

        public boolean isRequestProcessed() {
            return this.requestProcessed;
        }

        public String getResult() {
            return this.userResult;
        }

        public Optional<Exception> getLastExceptionThrown() {
            return Optional.ofNullable(this.lastExceptionThrown);
        }
    }

    private static class SessionList {
        private final List<Session> availableSessions = new ArrayList<Session>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<Session> acquireSessionIfAvailable() {
            List<Session> list = this.availableSessions;
            synchronized (list) {
                if (this.availableSessions.size() > 0) {
                    return Optional.of(this.availableSessions.remove(0));
                }
            }
            return Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSession(Session s) {
            List<Session> list = this.availableSessions;
            synchronized (list) {
                this.availableSessions.add(s);
            }
        }
    }
}

