/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSettingsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(MavenSettingsPreferencePage.class);
    final IMavenConfiguration mavenConfiguration;
    final IMaven maven;
    Text globalSettingsText;
    Text userSettingsText;
    Text localRepositoryText;
    boolean dirty = false;
    private Link globalSettingsLink;
    private Link userSettingsLink;

    public MavenSettingsPreferencePage() {
        this.setTitle(Messages.MavenSettingsPreferencePage_title);
        this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        this.maven = MavenPlugin.getMaven();
    }

    public void init(IWorkbench workbench) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateLocalRepository();
        }
    }

    protected void updateSettings(boolean updateMavenDependencies) {
        IMavenProjectFacade[] projects;
        this.updateLocalRepository();
        final String userSettings = this.getUserSettings();
        final String globalSettings = this.getGlobalSettings();
        String currentGlobalSettings = this.mavenConfiguration.getGlobalSettingsFile();
        String currentUserSettings = this.mavenConfiguration.getUserSettingsFile();
        if (Objects.equals(globalSettings, currentGlobalSettings) && Objects.equals(currentUserSettings, userSettings)) {
            return;
        }
        final Boolean[] updateProjects = new Boolean[]{updateMavenDependencies};
        if (updateMavenDependencies && (projects = MavenPlugin.getMavenProjectRegistry().getProjects()) != null && projects.length > 0) {
            updateProjects[0] = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.MavenPreferencePage_updateProjectRequired_title, (String)Messages.MavenProjectPreferencePage_dialog_message);
        }
        new Job(Messages.MavenSettingsPreferencePage_job_updating){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    File localRepositoryDir = new File(MavenSettingsPreferencePage.this.maven.getLocalRepository().getBasedir());
                    MavenSettingsPreferencePage.this.mavenConfiguration.setGlobalSettingsFile(globalSettings);
                    MavenSettingsPreferencePage.this.mavenConfiguration.setUserSettingsFile(userSettings);
                    File newRepositoryDir = new File(MavenSettingsPreferencePage.this.maven.getLocalRepository().getBasedir());
                    if (!newRepositoryDir.equals(localRepositoryDir)) {
                        IndexManager indexManager = MavenPlugin.getIndexManager();
                        indexManager.getWorkspaceIndex().updateIndex(true, monitor);
                    }
                    if (updateProjects[0].booleanValue()) {
                        IMavenProjectFacade[] projects = MavenPlugin.getMavenProjectRegistry().getProjects();
                        ArrayList<IProject> allProjects = new ArrayList<IProject>();
                        if (projects != null && projects.length > 0) {
                            MavenPlugin.getMaven().reloadSettings();
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, projects.length);
                            int i = 0;
                            while (i < projects.length) {
                                subMonitor.beginTask(NLS.bind((String)Messages.MavenSettingsPreferencePage_task_updating, (Object)projects[i].getProject().getName()), 1);
                                allProjects.add(projects[i].getProject());
                                ++i;
                            }
                            MavenPlugin.getMavenProjectRegistry().refresh(new MavenUpdateRequest(allProjects.toArray(new IProject[0]), MavenSettingsPreferencePage.this.mavenConfiguration.isOffline(), true));
                            subMonitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return e.getStatus();
                }
            }
        }.schedule();
    }

    protected void performDefaults() {
        this.globalSettingsText.setText("");
        this.userSettingsText.setText("");
        this.checkSettings();
        this.updateLocalRepository();
        super.performDefaults();
    }

    public boolean performOk() {
        this.updateSettings(true);
        return true;
    }

    protected Control createContents(Composite parent) {
        String userSettings;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.globalSettingsLink = new Link(composite, 0);
        this.globalSettingsLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.globalSettingsLink.setText(Messages.MavenSettingsPreferencePage_globalSettingslink2);
        this.globalSettingsLink.setToolTipText(Messages.MavenSettingsPreferencePage_globalSettingslink_tooltip);
        this.globalSettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String globalSettings = MavenSettingsPreferencePage.this.getGlobalSettings();
                if (globalSettings != null) {
                    MavenSettingsPreferencePage.this.openEditor(globalSettings);
                }
            }
        });
        this.globalSettingsText = new Text(composite, 2048);
        this.globalSettingsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button globalSettingsBrowseButton = new Button(composite, 0);
        globalSettingsBrowseButton.setText(Messages.MavenSettingsPreferencePage_globalSettingsBrowseButton_text);
        globalSettingsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenSettingsPreferencePage.this.browseSettingsAction(MavenSettingsPreferencePage.this.globalSettingsText);
            }
        });
        this.userSettingsLink = new Link(composite, 0);
        this.userSettingsLink.setText(Messages.MavenSettingsPreferencePage_userSettingslink2);
        this.userSettingsLink.setToolTipText(Messages.MavenSettingsPreferencePage_userSettingslink_tooltip);
        this.userSettingsLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.userSettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String userSettings = MavenSettingsPreferencePage.this.getUserSettings();
                if (userSettings == null) {
                    userSettings = SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
                }
                MavenSettingsPreferencePage.this.openEditor(userSettings);
            }
        });
        this.userSettingsText = new Text(composite, 2048);
        this.userSettingsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.userSettingsText.setMessage(SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath());
        Button userSettingsBrowseButton = new Button(composite, 0);
        userSettingsBrowseButton.setLayoutData((Object)new GridData(4, 131072, false, false, 1, 1));
        userSettingsBrowseButton.setText(Messages.MavenSettingsPreferencePage_userSettingsBrowseButton_text);
        userSettingsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenSettingsPreferencePage.this.browseSettingsAction(MavenSettingsPreferencePage.this.userSettingsText);
            }
        });
        Button updateSettings = new Button(composite, 0);
        updateSettings.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        updateSettings.setText(Messages.MavenSettingsPreferencePage_btnUpdate);
        updateSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenSettingsPreferencePage.this.updateSettings(true);
            }
        });
        Label localRepositoryLabel = new Label(composite, 0);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.verticalIndent = 25;
        localRepositoryLabel.setLayoutData((Object)gd);
        localRepositoryLabel.setText(Messages.MavenSettingsPreferencePage_lblLocal);
        this.localRepositoryText = new Text(composite, 2056);
        this.localRepositoryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.localRepositoryText.setData("name", (Object)"localRepositoryText");
        this.localRepositoryText.setEditable(false);
        Button reindexButton = new Button(composite, 0);
        reindexButton.setLayoutData((Object)new GridData(4, 131072, false, false, 1, 1));
        reindexButton.setText(Messages.preferencesReindexButton);
        reindexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new WorkspaceJob(Messages.MavenSettingsPreferencePage_job_indexing){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        IndexManager indexManager = MavenPlugin.getIndexManager();
                        indexManager.getWorkspaceIndex().updateIndex(true, monitor);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        ModifyListener settingsModifyListener = modifyevent -> {
            this.updateLocalRepository();
            this.checkSettings();
        };
        this.userSettingsText.addModifyListener(settingsModifyListener);
        this.globalSettingsText.addModifyListener(settingsModifyListener);
        String globalSettings = this.mavenConfiguration.getGlobalSettingsFile();
        if (globalSettings != null) {
            this.globalSettingsText.setText(globalSettings);
        }
        if ((userSettings = this.mavenConfiguration.getUserSettingsFile()) != null) {
            this.userSettingsText.setText(userSettings);
        }
        this.checkSettings();
        this.updateLocalRepository();
        return composite;
    }

    private void updateUserSettingsLink(String userSettings) {
        File userSettingsFile = SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE;
        if (userSettings != null) {
            userSettingsFile = new File(userSettings);
        }
        boolean active = userSettingsFile.canRead();
        String text = Messages.MavenSettingsPreferencePage_userSettingslink1;
        if (active) {
            text = Messages.MavenSettingsPreferencePage_userSettingslink2;
        }
        this.userSettingsLink.setText(text);
    }

    private void updateGlobalSettingsLink(String globalSettings) {
        boolean active = globalSettings != null && new File(globalSettings).canRead();
        String text = Messages.MavenSettingsPreferencePage_globalSettingslink1;
        if (active) {
            text = Messages.MavenSettingsPreferencePage_globalSettingslink2;
        }
        this.globalSettingsLink.setText(text);
    }

    protected void updateLocalRepository() {
        String globalSettings = this.getGlobalSettings();
        String userSettings = this.getUserSettings();
        try {
            Settings settings = this.maven.buildSettings(globalSettings, userSettings);
            String localRepository = settings.getLocalRepository();
            if (localRepository == null) {
                localRepository = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
            }
            if (!this.localRepositoryText.isDisposed()) {
                this.localRepositoryText.setText(localRepository == null ? "" : localRepository);
            }
        }
        catch (CoreException e) {
            this.setMessage(e.getMessage(), 3);
        }
    }

    protected void checkSettings() {
        this.setErrorMessage(null);
        this.setMessage(null);
        String globalSettings = this.getGlobalSettings();
        this.updateGlobalSettingsLink(globalSettings);
        String userSettings = this.getUserSettings();
        this.updateUserSettingsLink(userSettings);
        if (globalSettings != null && !this.checkSettings(globalSettings, Messages.MavenSettingsPreferencePage_error_globalSettingsMissing, Messages.MavenSettingsPreferencePage_error_globalSettingsParse)) {
            return;
        }
        if (userSettings != null && !this.checkSettings(userSettings, Messages.MavenSettingsPreferencePage_error_userSettingsMissing, Messages.MavenSettingsPreferencePage_error_userSettingsParse)) {
            return;
        }
    }

    private boolean checkSettings(String location, String errorMissing, String errorParse) {
        if (!new File(location).canRead()) {
            this.setMessage(errorMissing, 2);
            return false;
        }
        List result = this.maven.validateSettings(location);
        if (result.size() > 0) {
            this.setMessage(NLS.bind((String)errorParse, (Object)((SettingsProblem)result.get(0)).getMessage()), 2);
            return false;
        }
        return true;
    }

    void openEditor(String fileName) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor("settings.xml");
        FileStoreEditorInput input = new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile(new File(fileName)));
        try {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)desc.getId());
            if (editor == null) {
                return;
            }
            editor.addPropertyListener((source, propId) -> {
                if (!editor.isDirty()) {
                    log.info("Refreshing settings " + fileName);
                }
            });
        }
        catch (PartInitException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    String getUserSettings() {
        return this.getSettings(this.userSettingsText);
    }

    String getGlobalSettings() {
        return this.getSettings(this.globalSettingsText);
    }

    private String getSettings(Text settings) {
        String location = settings.getText().trim();
        return location.length() > 0 ? location : null;
    }

    protected void browseSettingsAction(Text settings) {
        String file;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (settings.getText().trim().length() > 0) {
            dialog.setFileName(settings.getText());
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            settings.setText(file);
            this.updateLocalRepository();
            this.checkSettings();
        }
    }
}

