/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.viewcontroller.BaseboardChoiceController;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.WallController;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WallPanel
extends JPanel
implements DialogView {
    private final WallController controller;
    private JLabel xStartLabel;
    private JSpinner xStartSpinner;
    private JLabel yStartLabel;
    private JSpinner yStartSpinner;
    private JLabel xEndLabel;
    private JSpinner xEndSpinner;
    private JLabel yEndLabel;
    private JSpinner yEndSpinner;
    private JLabel distanceToEndPointLabel;
    private JSpinner distanceToEndPointSpinner;
    private JRadioButton leftSideColorRadioButton;
    private ColorButton leftSideColorButton;
    private JRadioButton leftSideTextureRadioButton;
    private JComponent leftSideTextureComponent;
    private JRadioButton leftSideMattRadioButton;
    private JButton leftSideBaseboardButton;
    private JRadioButton leftSideShinyRadioButton;
    private JRadioButton rightSideColorRadioButton;
    private ColorButton rightSideColorButton;
    private JRadioButton rightSideTextureRadioButton;
    private JComponent rightSideTextureComponent;
    private JRadioButton rightSideMattRadioButton;
    private JRadioButton rightSideShinyRadioButton;
    private JButton rightSideBaseboardButton;
    private JLabel patternLabel;
    private JComboBox patternComboBox;
    private JLabel topColorLabel;
    private JRadioButton topDefaultColorRadioButton;
    private JRadioButton topColorRadioButton;
    private ColorButton topColorButton;
    private JRadioButton rectangularWallRadioButton;
    private JLabel rectangularWallHeightLabel;
    private JSpinner rectangularWallHeightSpinner;
    private JRadioButton slopingWallRadioButton;
    private JLabel slopingWallHeightAtStartLabel;
    private JSpinner slopingWallHeightAtStartSpinner;
    private JLabel slopingWallHeightAtEndLabel;
    private JSpinner slopingWallHeightAtEndSpinner;
    private JLabel thicknessLabel;
    private JSpinner thicknessSpinner;
    private JLabel arcExtentLabel;
    private JSpinner arcExtentSpinner;
    private JEditorPane wallOrientationLabel;
    private String dialogTitle;

    public WallPanel(UserPreferences userPreferences, WallController wallController) {
        super(new GridBagLayout());
        this.controller = wallController;
        this.createComponents(userPreferences, wallController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences, wallController);
    }

    private void createComponents(final UserPreferences userPreferences, final WallController wallController) {
        String string = userPreferences.getLengthUnit().getName();
        this.xStartLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "xLabel.text", string));
        float f = userPreferences.getLengthUnit().getMaximumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.xStartSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.setNullable(wallController.getXStart() == null);
        nullableSpinnerLengthModel.setLength(wallController.getXStart());
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.X_START, propertyChangeListener);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.X_START, propertyChangeListener);
                wallController.setXStart(nullableSpinnerLengthModel.getLength());
                wallController.addPropertyChangeListener(WallController.Property.X_START, propertyChangeListener);
            }
        });
        this.yStartLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "yLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.yStartSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.setNullable(wallController.getYStart() == null);
        nullableSpinnerLengthModel2.setLength(wallController.getYStart());
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel2.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.Y_START, propertyChangeListener2);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.Y_START, propertyChangeListener2);
                wallController.setYStart(nullableSpinnerLengthModel2.getLength());
                wallController.addPropertyChangeListener(WallController.Property.Y_START, propertyChangeListener2);
            }
        });
        this.xEndLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "xLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.xEndSpinner = new NullableSpinner(nullableSpinnerLengthModel3);
        nullableSpinnerLengthModel3.setNullable(wallController.getXEnd() == null);
        nullableSpinnerLengthModel3.setLength(wallController.getXEnd());
        final PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel3.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel3.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.X_END, propertyChangeListener3);
        nullableSpinnerLengthModel3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.X_END, propertyChangeListener3);
                wallController.setXEnd(nullableSpinnerLengthModel3.getLength());
                wallController.addPropertyChangeListener(WallController.Property.X_END, propertyChangeListener3);
            }
        });
        this.yEndLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "yLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel4 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.yEndSpinner = new NullableSpinner(nullableSpinnerLengthModel4);
        nullableSpinnerLengthModel4.setNullable(wallController.getYEnd() == null);
        nullableSpinnerLengthModel4.setLength(wallController.getYEnd());
        final PropertyChangeListener propertyChangeListener4 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel4.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel4.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.Y_END, propertyChangeListener4);
        nullableSpinnerLengthModel4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.Y_END, propertyChangeListener4);
                wallController.setYEnd(nullableSpinnerLengthModel4.getLength());
                wallController.addPropertyChangeListener(WallController.Property.Y_END, propertyChangeListener4);
            }
        });
        this.distanceToEndPointLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "distanceToEndPointLabel.text", string));
        final float f2 = userPreferences.getLengthUnit().getMinimumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel5 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, 2.0f * f * (float)Math.sqrt(2.0));
        this.distanceToEndPointSpinner = new NullableSpinner(nullableSpinnerLengthModel5);
        nullableSpinnerLengthModel5.setNullable(wallController.getLength() == null);
        nullableSpinnerLengthModel5.setLength(wallController.getDistanceToEndPoint());
        final PropertyChangeListener propertyChangeListener5 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel5.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel5.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.DISTANCE_TO_END_POINT, propertyChangeListener5);
        nullableSpinnerLengthModel5.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.DISTANCE_TO_END_POINT, propertyChangeListener5);
                wallController.setDistanceToEndPoint(nullableSpinnerLengthModel5.getLength());
                wallController.addPropertyChangeListener(WallController.Property.DISTANCE_TO_END_POINT, propertyChangeListener5);
            }
        });
        this.leftSideColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "leftSideColorRadioButton.text", new Object[0]));
        this.leftSideColorRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.leftSideColorRadioButton.isSelected()) {
                    wallController.setLeftSidePaint(WallController.WallPaint.COLORED);
                }
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.LEFT_SIDE_PAINT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.updateLeftSideColorRadioButtons(wallController);
            }
        });
        this.leftSideColorButton = new ColorButton(userPreferences);
        this.leftSideColorButton.setColorDialogTitle(userPreferences.getLocalizedString(WallPanel.class, "leftSideColorDialog.title", new Object[0]));
        this.leftSideColorButton.setColor(wallController.getLeftSideColor());
        this.leftSideColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                wallController.setLeftSideColor(WallPanel.this.leftSideColorButton.getColor());
                wallController.setLeftSidePaint(WallController.WallPaint.COLORED);
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.LEFT_SIDE_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.leftSideColorButton.setColor(wallController.getLeftSideColor());
            }
        });
        this.leftSideTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "leftSideTextureRadioButton.text", new Object[0]));
        this.leftSideTextureRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.leftSideTextureRadioButton.isSelected()) {
                    wallController.setLeftSidePaint(WallController.WallPaint.TEXTURED);
                }
            }
        });
        this.leftSideTextureComponent = (JComponent)((Object)wallController.getLeftSideTextureController().getView());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.leftSideColorRadioButton);
        buttonGroup.add(this.leftSideTextureRadioButton);
        this.updateLeftSideColorRadioButtons(wallController);
        this.leftSideMattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "leftSideMattRadioButton.text", new Object[0]));
        this.leftSideMattRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.leftSideMattRadioButton.isSelected()) {
                    wallController.setLeftSideShininess(Float.valueOf(0.0f));
                }
            }
        });
        PropertyChangeListener propertyChangeListener6 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.updateLeftSideShininessRadioButtons(wallController);
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.LEFT_SIDE_SHININESS, propertyChangeListener6);
        this.leftSideShinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "leftSideShinyRadioButton.text", new Object[0]));
        this.leftSideShinyRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.leftSideShinyRadioButton.isSelected()) {
                    wallController.setLeftSideShininess(Float.valueOf(0.25f));
                }
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.LEFT_SIDE_SHININESS, propertyChangeListener6);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.leftSideMattRadioButton);
        buttonGroup2.add(this.leftSideShinyRadioButton);
        this.updateLeftSideShininessRadioButtons(wallController);
        this.leftSideBaseboardButton = new JButton(new ResourceAction.ButtonAction(new ResourceAction(userPreferences, WallPanel.class, "MODIFY_LEFT_SIDE_BASEBOARD", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WallPanel.this.editBaseboard((JComponent)actionEvent.getSource(), userPreferences.getLocalizedString(WallPanel.class, "leftSideBaseboardDialog.title", new Object[0]), wallController.getLeftSideBaseboardController());
            }
        }));
        this.rightSideColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "rightSideColorRadioButton.text", new Object[0]));
        this.rightSideColorRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.rightSideColorRadioButton.isSelected()) {
                    wallController.setRightSidePaint(WallController.WallPaint.COLORED);
                }
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.RIGHT_SIDE_PAINT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.updateRightSideColorRadioButtons(wallController);
            }
        });
        this.rightSideColorButton = new ColorButton(userPreferences);
        this.rightSideColorButton.setColor(wallController.getRightSideColor());
        this.rightSideColorButton.setColorDialogTitle(userPreferences.getLocalizedString(WallPanel.class, "rightSideColorDialog.title", new Object[0]));
        this.rightSideColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                wallController.setRightSideColor(WallPanel.this.rightSideColorButton.getColor());
                wallController.setRightSidePaint(WallController.WallPaint.COLORED);
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.RIGHT_SIDE_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.rightSideColorButton.setColor(wallController.getRightSideColor());
            }
        });
        this.rightSideTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "rightSideTextureRadioButton.text", new Object[0]));
        this.rightSideTextureRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.rightSideTextureRadioButton.isSelected()) {
                    wallController.setRightSidePaint(WallController.WallPaint.TEXTURED);
                }
            }
        });
        this.rightSideTextureComponent = (JComponent)((Object)wallController.getRightSideTextureController().getView());
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.rightSideColorRadioButton);
        buttonGroup3.add(this.rightSideTextureRadioButton);
        this.updateRightSideColorRadioButtons(wallController);
        this.rightSideMattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "rightSideMattRadioButton.text", new Object[0]));
        this.rightSideMattRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.rightSideMattRadioButton.isSelected()) {
                    wallController.setRightSideShininess(Float.valueOf(0.0f));
                }
            }
        });
        PropertyChangeListener propertyChangeListener7 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.updateRightSideShininessRadioButtons(wallController);
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.RIGHT_SIDE_SHININESS, propertyChangeListener7);
        this.rightSideShinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "rightSideShinyRadioButton.text", new Object[0]));
        this.rightSideShinyRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.rightSideShinyRadioButton.isSelected()) {
                    wallController.setRightSideShininess(Float.valueOf(0.25f));
                }
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.RIGHT_SIDE_SHININESS, propertyChangeListener7);
        ButtonGroup buttonGroup4 = new ButtonGroup();
        buttonGroup4.add(this.rightSideMattRadioButton);
        buttonGroup4.add(this.rightSideShinyRadioButton);
        this.updateRightSideShininessRadioButtons(wallController);
        this.rightSideBaseboardButton = new JButton(new ResourceAction.ButtonAction(new ResourceAction(userPreferences, WallPanel.class, "MODIFY_RIGHT_SIDE_BASEBOARD", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WallPanel.this.editBaseboard((JComponent)actionEvent.getSource(), userPreferences.getLocalizedString(WallPanel.class, "rightSideBaseboardDialog.title", new Object[0]), wallController.getRightSideBaseboardController());
            }
        }));
        this.patternLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "patternLabel.text", new Object[0]));
        List<TextureImage> list = userPreferences.getPatternsCatalog().getPatterns();
        if (wallController.getPattern() == null) {
            list = new ArrayList<TextureImage>(list);
            list.add(0, null);
        }
        this.patternComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(list.toArray()));
        final float f3 = SwingTools.getResolutionScale();
        this.patternComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(final JList jList, Object object, int n, boolean bl, boolean bl2) {
                TextureImage textureImage = (TextureImage)object;
                Component component = super.getListCellRendererComponent((JList<?>)jList, textureImage == null ? " " : "", n, bl, bl2);
                if (textureImage != null) {
                    final BufferedImage bufferedImage = SwingTools.getPatternImage(textureImage, jList.getBackground(), jList.getForeground());
                    this.setIcon(new Icon(){

                        @Override
                        public int getIconWidth() {
                            return (int)((float)(bufferedImage.getWidth() * 4) * f3 + 1.0f);
                        }

                        @Override
                        public int getIconHeight() {
                            return (int)((float)bufferedImage.getHeight() * f3 + 2.0f);
                        }

                        @Override
                        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            graphics2D.scale(f3, f3);
                            for (int i = 0; i < 4; ++i) {
                                graphics2D.drawImage((Image)bufferedImage, n + i * bufferedImage.getWidth(), n2 + 1, jList);
                            }
                            graphics2D.scale(1.0f / f3, 1.0f / f3);
                            graphics2D.setColor(jList.getForeground());
                            graphics2D.drawRect(n, n2, this.getIconWidth() - 2, this.getIconHeight() - 1);
                        }
                    });
                }
                return component;
            }
        });
        this.patternComboBox.setSelectedItem(wallController.getPattern());
        this.patternComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                wallController.setPattern((TextureImage)WallPanel.this.patternComboBox.getSelectedItem());
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.PATTERN, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.patternComboBox.setSelectedItem(wallController.getPattern());
            }
        });
        this.topColorLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "topColorLabel.text", new Object[0]));
        this.topDefaultColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "topDefaultColorRadioButton.text", new Object[0]));
        this.topDefaultColorRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.topDefaultColorRadioButton.isSelected()) {
                    wallController.setTopPaint(WallController.WallPaint.DEFAULT);
                }
            }
        });
        this.topColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "topColorRadioButton.text", new Object[0]));
        this.topColorRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.topColorRadioButton.isSelected()) {
                    wallController.setTopPaint(WallController.WallPaint.COLORED);
                }
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.TOP_PAINT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.updateTopColorRadioButtons(wallController);
            }
        });
        this.topColorButton = new ColorButton(userPreferences);
        this.topColorButton.setColorDialogTitle(userPreferences.getLocalizedString(WallPanel.class, "topColorDialog.title", new Object[0]));
        this.topColorButton.setColor(wallController.getTopColor());
        this.topColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                wallController.setTopColor(WallPanel.this.topColorButton.getColor());
                wallController.setTopPaint(WallController.WallPaint.COLORED);
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.TOP_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.topColorButton.setColor(wallController.getTopColor());
            }
        });
        ButtonGroup buttonGroup5 = new ButtonGroup();
        buttonGroup5.add(this.topDefaultColorRadioButton);
        buttonGroup5.add(this.topColorRadioButton);
        this.updateTopColorRadioButtons(wallController);
        this.rectangularWallRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "rectangularWallRadioButton.text", new Object[0]));
        this.rectangularWallRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.rectangularWallRadioButton.isSelected()) {
                    wallController.setShape(WallController.WallShape.RECTANGULAR_WALL);
                }
            }
        });
        wallController.addPropertyChangeListener(WallController.Property.SHAPE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WallPanel.this.updateWallShapeRadioButtons(wallController);
            }
        });
        this.rectangularWallHeightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "rectangularWallHeightLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel6 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f);
        this.rectangularWallHeightSpinner = new NullableSpinner(nullableSpinnerLengthModel6);
        nullableSpinnerLengthModel6.setNullable(wallController.getRectangularWallHeight() == null);
        nullableSpinnerLengthModel6.setLength(wallController.getRectangularWallHeight());
        final PropertyChangeListener propertyChangeListener8 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel6.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel6.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.RECTANGULAR_WALL_HEIGHT, propertyChangeListener8);
        nullableSpinnerLengthModel6.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.RECTANGULAR_WALL_HEIGHT, propertyChangeListener8);
                wallController.setRectangularWallHeight(nullableSpinnerLengthModel6.getLength());
                wallController.addPropertyChangeListener(WallController.Property.RECTANGULAR_WALL_HEIGHT, propertyChangeListener8);
            }
        });
        this.slopingWallRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "slopingWallRadioButton.text", new Object[0]));
        this.slopingWallRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WallPanel.this.slopingWallRadioButton.isSelected()) {
                    wallController.setShape(WallController.WallShape.SLOPING_WALL);
                }
            }
        });
        ButtonGroup buttonGroup6 = new ButtonGroup();
        buttonGroup6.add(this.rectangularWallRadioButton);
        buttonGroup6.add(this.slopingWallRadioButton);
        this.updateWallShapeRadioButtons(wallController);
        this.slopingWallHeightAtStartLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "slopingWallHeightAtStartLabel.text", new Object[0]));
        final float f4 = wallController.getSlopingWallHeightAtStart() != null && wallController.getSlopingWallHeightAtEnd() != null ? 0.0f : f2;
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel7 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f4, f);
        this.slopingWallHeightAtStartSpinner = new NullableSpinner(nullableSpinnerLengthModel7);
        nullableSpinnerLengthModel7.setNullable(wallController.getSlopingWallHeightAtStart() == null);
        nullableSpinnerLengthModel7.setLength(wallController.getSlopingWallHeightAtStart());
        final PropertyChangeListener propertyChangeListener9 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel7.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel7.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.SLOPING_WALL_HEIGHT_AT_START, propertyChangeListener9);
        nullableSpinnerLengthModel7.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.SLOPING_WALL_HEIGHT_AT_START, propertyChangeListener9);
                wallController.setSlopingWallHeightAtStart(nullableSpinnerLengthModel7.getLength());
                if (f4 == 0.0f && wallController.getSlopingWallHeightAtStart().floatValue() == 0.0f && wallController.getSlopingWallHeightAtEnd().floatValue() == 0.0f) {
                    wallController.setSlopingWallHeightAtEnd(Float.valueOf(f2));
                }
                wallController.addPropertyChangeListener(WallController.Property.SLOPING_WALL_HEIGHT_AT_START, propertyChangeListener9);
            }
        });
        this.slopingWallHeightAtEndLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "slopingWallHeightAtEndLabel.text", new Object[0]));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel8 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f4, f);
        this.slopingWallHeightAtEndSpinner = new NullableSpinner(nullableSpinnerLengthModel8);
        nullableSpinnerLengthModel8.setNullable(wallController.getSlopingWallHeightAtEnd() == null);
        nullableSpinnerLengthModel8.setLength(wallController.getSlopingWallHeightAtEnd());
        final PropertyChangeListener propertyChangeListener10 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel8.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel8.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.SLOPING_WALL_HEIGHT_AT_END, propertyChangeListener10);
        nullableSpinnerLengthModel8.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.SLOPING_WALL_HEIGHT_AT_END, propertyChangeListener10);
                wallController.setSlopingWallHeightAtEnd(nullableSpinnerLengthModel8.getLength());
                if (f4 == 0.0f && wallController.getSlopingWallHeightAtStart().floatValue() == 0.0f && wallController.getSlopingWallHeightAtEnd().floatValue() == 0.0f) {
                    wallController.setSlopingWallHeightAtStart(Float.valueOf(f2));
                }
                wallController.addPropertyChangeListener(WallController.Property.SLOPING_WALL_HEIGHT_AT_END, propertyChangeListener10);
            }
        });
        this.thicknessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "thicknessLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel9 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f / 10.0f);
        this.thicknessSpinner = new NullableSpinner(nullableSpinnerLengthModel9);
        nullableSpinnerLengthModel9.setNullable(wallController.getThickness() == null);
        nullableSpinnerLengthModel9.setLength(wallController.getThickness());
        final PropertyChangeListener propertyChangeListener11 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel9.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel9.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        wallController.addPropertyChangeListener(WallController.Property.THICKNESS, propertyChangeListener11);
        nullableSpinnerLengthModel9.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.THICKNESS, propertyChangeListener11);
                wallController.setThickness(nullableSpinnerLengthModel9.getLength());
                wallController.addPropertyChangeListener(WallController.Property.THICKNESS, propertyChangeListener11);
            }
        });
        this.arcExtentLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, WallPanel.class, "arcExtentLabel.text", string));
        final NullableSpinner.NullableSpinnerNumberModel nullableSpinnerNumberModel = new NullableSpinner.NullableSpinnerNumberModel(new Float(0.0f).floatValue(), new Float(-270.0f).floatValue(), new Float(270.0f).floatValue(), new Float(5.0f).floatValue());
        this.arcExtentSpinner = new NullableSpinner(nullableSpinnerNumberModel);
        final PropertyChangeListener propertyChangeListener12 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerNumberModel.setNullable(wallController.getArcExtentInDegrees() == null);
                nullableSpinnerNumberModel.setValue(wallController.getArcExtentInDegrees());
            }
        };
        propertyChangeListener12.propertyChange(null);
        PropertyChangeListener propertyChangeListener13 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Float f = wallController.getArcLength();
                if (f != null && (wallController.getArcExtentInDegrees().floatValue() != 0.0f || SwingTools.isToolTipShowing())) {
                    String string = userPreferences.getLocalizedString(WallPanel.class, "arcExtentSpinner.tooltip", userPreferences.getLengthUnit().getFormatWithUnit().format(f));
                    WallPanel.this.arcExtentSpinner.setToolTipText(string);
                    if (WallPanel.this.arcExtentSpinner.isShowing() && SwingTools.isToolTipShowing()) {
                        Point point = MouseInfo.getPointerInfo().getLocation();
                        SwingUtilities.convertPointFromScreen(point, WallPanel.this.arcExtentSpinner);
                        ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(WallPanel.this.arcExtentSpinner, -1, System.currentTimeMillis(), 0, Math.max(0, Math.min(WallPanel.this.arcExtentSpinner.getWidth(), point.x)), Math.max(0, Math.min(WallPanel.this.arcExtentSpinner.getHeight(), point.y)), 1, false, 0));
                    }
                } else {
                    WallPanel.this.arcExtentSpinner.setToolTipText(null);
                }
            }
        };
        propertyChangeListener13.propertyChange(null);
        wallController.addPropertyChangeListener(WallController.Property.ARC_EXTENT_IN_DEGREES, propertyChangeListener13);
        wallController.addPropertyChangeListener(WallController.Property.ARC_EXTENT_IN_DEGREES, propertyChangeListener12);
        nullableSpinnerNumberModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                wallController.removePropertyChangeListener(WallController.Property.ARC_EXTENT_IN_DEGREES, propertyChangeListener12);
                Number number = (Number)nullableSpinnerNumberModel.getValue();
                wallController.setArcExtentInDegrees(number != null ? Float.valueOf(number.floatValue()) : null);
                wallController.addPropertyChangeListener(WallController.Property.ARC_EXTENT_IN_DEGREES, propertyChangeListener12);
            }
        });
        this.wallOrientationLabel = new JEditorPane("text/html", userPreferences.getLocalizedString(WallPanel.class, "wallOrientationLabel.text", new ResourceURLContent(WallPanel.class, "resources/wallOrientation.png").getURL()).replace("<html>", "<html><center>"));
        this.wallOrientationLabel.setEditable(false);
        this.wallOrientationLabel.setOpaque(false);
        this.wallOrientationLabel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.wallOrientationLabel.setFont(UIManager.getFont("ToolTip.font"));
        this.dialogTitle = userPreferences.getLocalizedString(WallPanel.class, "wall.title", new Object[0]);
    }

    private void updateLeftSideColorRadioButtons(WallController wallController) {
        if (wallController.getLeftSidePaint() == WallController.WallPaint.COLORED) {
            this.leftSideColorRadioButton.setSelected(true);
        } else if (wallController.getLeftSidePaint() == WallController.WallPaint.TEXTURED) {
            this.leftSideTextureRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.leftSideColorRadioButton, this.leftSideTextureRadioButton);
        }
    }

    private void updateLeftSideShininessRadioButtons(WallController wallController) {
        if (wallController.getLeftSideShininess() == null) {
            SwingTools.deselectAllRadioButtons(this.leftSideMattRadioButton, this.leftSideShinyRadioButton);
        } else if (wallController.getLeftSideShininess().floatValue() == 0.0f) {
            this.leftSideMattRadioButton.setSelected(true);
        } else {
            this.leftSideShinyRadioButton.setSelected(true);
        }
    }

    private void updateRightSideColorRadioButtons(WallController wallController) {
        if (wallController.getRightSidePaint() == WallController.WallPaint.COLORED) {
            this.rightSideColorRadioButton.setSelected(true);
        } else if (wallController.getRightSidePaint() == WallController.WallPaint.TEXTURED) {
            this.rightSideTextureRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.rightSideColorRadioButton, this.rightSideTextureRadioButton);
        }
    }

    private void updateRightSideShininessRadioButtons(WallController wallController) {
        if (wallController.getRightSideShininess() == null) {
            SwingTools.deselectAllRadioButtons(this.rightSideMattRadioButton, this.rightSideShinyRadioButton);
        } else if (wallController.getRightSideShininess().floatValue() == 0.0f) {
            this.rightSideMattRadioButton.setSelected(true);
        } else {
            this.rightSideShinyRadioButton.setSelected(true);
        }
    }

    private void updateTopColorRadioButtons(WallController wallController) {
        if (wallController.getTopPaint() == WallController.WallPaint.COLORED) {
            this.topColorRadioButton.setSelected(true);
        } else if (wallController.getTopPaint() == WallController.WallPaint.DEFAULT) {
            this.topDefaultColorRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.topColorRadioButton, this.topDefaultColorRadioButton);
        }
    }

    private void updateWallShapeRadioButtons(WallController wallController) {
        if (wallController.getShape() == WallController.WallShape.SLOPING_WALL) {
            this.slopingWallRadioButton.setSelected(true);
        } else if (wallController.getShape() == WallController.WallShape.RECTANGULAR_WALL) {
            this.rectangularWallRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.slopingWallRadioButton, this.rectangularWallRadioButton);
        }
    }

    private void editBaseboard(JComponent jComponent, String string, BaseboardChoiceController baseboardChoiceController) {
        Boolean bl = baseboardChoiceController.getVisible();
        Integer n = baseboardChoiceController.getColor();
        HomeTexture homeTexture = baseboardChoiceController.getTextureController().getTexture();
        BaseboardChoiceController.BaseboardPaint baseboardPaint = baseboardChoiceController.getPaint();
        Float f = baseboardChoiceController.getThickness();
        Float f2 = baseboardChoiceController.getHeight();
        JComponent jComponent2 = (JComponent)((Object)baseboardChoiceController.getView());
        JPanel jPanel = new JPanel();
        jPanel.add(jComponent2);
        if (SwingTools.showConfirmDialog(jComponent, jPanel, string, (JComponent)jComponent2.getComponent(0)) != 0) {
            baseboardChoiceController.setVisible(bl);
            baseboardChoiceController.setColor(n);
            baseboardChoiceController.getTextureController().setTexture(homeTexture);
            baseboardChoiceController.setPaint(baseboardPaint);
            baseboardChoiceController.setThickness(f);
            baseboardChoiceController.setHeight(f2);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.xStartLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "xLabel.mnemonic", new Object[0])).getKeyCode());
            this.xStartLabel.setLabelFor(this.xStartSpinner);
            this.yStartLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "yLabel.mnemonic", new Object[0])).getKeyCode());
            this.yStartLabel.setLabelFor(this.yStartSpinner);
            this.xEndLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "xLabel.mnemonic", new Object[0])).getKeyCode());
            this.xEndLabel.setLabelFor(this.xEndSpinner);
            this.yEndLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "yLabel.mnemonic", new Object[0])).getKeyCode());
            this.yEndLabel.setLabelFor(this.yEndSpinner);
            this.distanceToEndPointLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "distanceToEndPointLabel.mnemonic", new Object[0])).getKeyCode());
            this.distanceToEndPointLabel.setLabelFor(this.distanceToEndPointSpinner);
            this.leftSideColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "leftSideColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.leftSideTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "leftSideTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.leftSideMattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "leftSideMattRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.leftSideShinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "leftSideShinyRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.rightSideColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "rightSideColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.rightSideTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "rightSideTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.rightSideMattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "rightSideMattRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.rightSideShinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "rightSideShinyRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.patternLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "patternLabel.mnemonic", new Object[0])).getKeyCode());
            this.patternLabel.setLabelFor(this.patternComboBox);
            this.topDefaultColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "topDefaultColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.topColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "topColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.rectangularWallRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "rectangularWallRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.rectangularWallHeightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "rectangularWallHeightLabel.mnemonic", new Object[0])).getKeyCode());
            this.rectangularWallHeightLabel.setLabelFor(this.rectangularWallHeightSpinner);
            this.slopingWallRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "slopingWallRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.slopingWallHeightAtStartLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "slopingWallHeightAtStartLabel.mnemonic", new Object[0])).getKeyCode());
            this.slopingWallHeightAtStartLabel.setLabelFor(this.slopingWallHeightAtStartSpinner);
            this.slopingWallHeightAtEndLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "slopingWallHeightAtEndLabel.mnemonic", new Object[0])).getKeyCode());
            this.slopingWallHeightAtEndLabel.setLabelFor(this.slopingWallHeightAtEndSpinner);
            this.thicknessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "thicknessLabel.mnemonic", new Object[0])).getKeyCode());
            this.thicknessLabel.setLabelFor(this.thicknessSpinner);
            this.arcExtentLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(WallPanel.class, "arcExtentLabel.mnemonic", new Object[0])).getKeyCode());
            this.arcExtentLabel.setLabelFor(this.arcExtentSpinner);
        }
    }

    private void layoutComponents(UserPreferences userPreferences, final WallController wallController) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        final JPanel jPanel = this.createTitledPanel(userPreferences.getLocalizedString(WallPanel.class, "startPointPanel.title", new Object[0]), new JComponent[]{this.xStartLabel, this.xStartSpinner, this.yStartLabel, this.yStartSpinner}, true);
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        Insets insets = OperatingSystem.isMacOSXLeopardOrSuperior() ? new Insets(0, 0, 0, 0) : new Insets(0, 0, n2, 0);
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        final JPanel jPanel2 = this.createTitledPanel(userPreferences.getLocalizedString(WallPanel.class, "endPointPanel.title", new Object[0]), new JComponent[]{this.xEndLabel, this.xEndSpinner, this.yEndLabel, this.yEndSpinner}, true);
        jPanel2.add((Component)this.distanceToEndPointLabel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 22, 0, new Insets(n2, 0, 0, n2), 0, 0));
        jPanel2.add((Component)this.distanceToEndPointSpinner, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(n2, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel3 = this.createTitledPanel(userPreferences.getLocalizedString(WallPanel.class, "leftSidePanel.title", new Object[0]), new JComponent[]{this.leftSideColorRadioButton, this.leftSideColorButton, this.leftSideTextureRadioButton, this.leftSideTextureComponent}, false);
        jPanel3.add((Component)new JSeparator(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
        jPanel3.add((Component)this.leftSideMattRadioButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel3.add((Component)this.leftSideShinyRadioButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.leftSideBaseboardButton, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 0, new Insets(n2, 0, 0, 0), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel4 = this.createTitledPanel(userPreferences.getLocalizedString(WallPanel.class, "rightSidePanel.title", new Object[0]), new JComponent[]{this.rightSideColorRadioButton, this.rightSideColorButton, this.rightSideTextureRadioButton, this.rightSideTextureComponent}, false);
        jPanel4.add((Component)new JSeparator(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
        jPanel4.add((Component)this.rightSideMattRadioButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel4.add((Component)this.rightSideShinyRadioButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.rightSideBaseboardButton, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 0, new Insets(n2, 0, 0, 0), 0, 0));
        this.add((Component)jPanel4, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel5 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(WallPanel.class, "topPanel.title", new Object[0]));
        int n3 = new JRadioButton().getPreferredSize().width;
        jPanel5.add((Component)this.patternLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, n3, 3, n2), 0, 0));
        jPanel5.add((Component)this.patternComboBox, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 3, 0), 0, 0));
        jPanel5.add((Component)this.topColorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, n3, 0, n2), 0, 0));
        jPanel5.add((Component)this.topDefaultColorRadioButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel5.add((Component)this.topColorRadioButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel5.add((Component)this.topColorButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel5, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel6 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(WallPanel.class, "heightPanel.title", new Object[0]));
        jPanel6.add((Component)this.rectangularWallRadioButton, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 2, 0), 0, 0));
        int n4 = OperatingSystem.isMacOSX() ? -20 : -10;
        jPanel6.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, 0), new JRadioButton().getPreferredSize().width, 0));
        jPanel6.add((Component)this.rectangularWallHeightLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel6.add((Component)this.rectangularWallHeightSpinner, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, n2, n2), n4, 0));
        jPanel6.add((Component)this.slopingWallRadioButton, new GridBagConstraints(3, 0, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 2, 0), 0, 0));
        jPanel6.add((Component)new JLabel(), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, 0), new JRadioButton().getPreferredSize().width, 0));
        jPanel6.add((Component)this.slopingWallHeightAtStartLabel, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel6.add((Component)this.slopingWallHeightAtStartSpinner, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, n2, 0), n4, 0));
        jPanel6.add((Component)this.slopingWallHeightAtEndLabel, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel6.add((Component)this.slopingWallHeightAtEndSpinner, new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), n4, 0));
        this.add((Component)jPanel6, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        jPanel7.add((Component)this.thicknessLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 2, new Insets(0, 0, 0, n2), 0, 0));
        jPanel7.add((Component)this.thicknessSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel7.add((Component)this.arcExtentLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, n, 2, new Insets(0, 0, 0, n2), 0, 0));
        jPanel7.add((Component)this.arcExtentSpinner, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel7, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(n2, 8, 10, 8), 0, 0));
        this.add((Component)this.wallOrientationLabel, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        wallController.addPropertyChangeListener(WallController.Property.EDITABLE_POINTS, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jPanel.setVisible(wallController.isEditablePoints());
                jPanel2.setVisible(wallController.isEditablePoints());
                WallPanel.this.arcExtentLabel.setVisible(wallController.isEditablePoints());
                WallPanel.this.arcExtentSpinner.setVisible(wallController.isEditablePoints());
            }
        });
        jPanel.setVisible(wallController.isEditablePoints());
        jPanel2.setVisible(wallController.isEditablePoints());
        this.arcExtentLabel.setVisible(wallController.isEditablePoints());
        this.arcExtentSpinner.setVisible(wallController.isEditablePoints());
    }

    private JPanel createTitledPanel(String string, JComponent[] jComponentArray, boolean bl) {
        JPanel jPanel = SwingTools.createTitledPanel(string);
        int n = Math.round(5.0f * SwingTools.getResolutionScale());
        if (bl) {
            int n2 = OperatingSystem.isMacOSX() ? 22 : 21;
            Insets insets = new Insets(0, 0, 0, n);
            Insets insets2 = new Insets(0, 0, 0, n);
            for (int i = 0; i < jComponentArray.length - 1; i += 2) {
                jPanel.add((Component)jComponentArray[i], new GridBagConstraints(i, 0, 1, 1, 1.0, 0.0, n2, 0, insets, 0, 0));
                jPanel.add((Component)jComponentArray[i + 1], new GridBagConstraints(i + 1, 0, 1, 1, 1.0, 0.0, 21, 2, insets2, 0, 0));
            }
            jPanel.add((Component)jComponentArray[jComponentArray.length - 1], new GridBagConstraints(jComponentArray.length - 1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            for (int i = 0; i < jComponentArray.length; i += 2) {
                int n3 = i < jComponentArray.length - 2 ? Math.round(2.0f * SwingTools.getResolutionScale()) : 0;
                jPanel.add((Component)jComponentArray[i], new GridBagConstraints(0, i / 2, jComponentArray[i + 1] != null ? 1 : 2, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, n3, n), 0, 0));
                if (jComponentArray[i + 1] == null) continue;
                jPanel.add((Component)jComponentArray[i + 1], new GridBagConstraints(1, i / 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, n3, 0), 0, 0));
            }
        }
        return jPanel;
    }

    @Override
    public void displayView(View view) {
        JComponent jComponent;
        Component component = SwingUtilities.getRoot((Component)((Object)view));
        if (component != null) {
            jComponent = new JOptionPane(this, -1, 2);
            JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)((Object)view));
            JDialog jDialog = ((JOptionPane)jComponent).createDialog(jRootPane, this.dialogTitle);
            jDialog.applyComponentOrientation(jRootPane != null ? jRootPane.getComponentOrientation() : ComponentOrientation.getOrientation(Locale.getDefault()));
            Dimension dimension = this.getToolkit().getScreenSize();
            Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
            int n = dimension.height - insets.top - insets.bottom;
            if (OperatingSystem.isLinux() && n == dimension.height) {
                n -= 30;
            }
            if (jDialog.getHeight() > n) {
                this.wallOrientationLabel.setVisible(false);
            }
            jDialog.pack();
            if (jDialog.getHeight() > n) {
                this.patternLabel.getParent().setVisible(false);
            }
            jDialog.dispose();
        }
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, jComponent = ((JSpinner.DefaultEditor)this.thicknessSpinner.getEditor()).getTextField()) == 0) {
            this.controller.modifyWalls();
        }
    }
}

