/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import icons.GithubIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestKeys;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\u0002 !B#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsList;", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/plugins/github/api/data/GithubSearchedIssue;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable;", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "avatarIconsProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "model", "Ljavax/swing/ListModel;", "(Lcom/intellij/openapi/ide/CopyPasteManager;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;Ljavax/swing/ListModel;)V", "avatarIconSize", "Lcom/intellij/util/ui/JBValue$UIInteger;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "dispose", "", "getData", "", "dataId", "", "getToolTipText", "event", "Ljava/awt/event/MouseEvent;", "isCopyEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyVisible", "performCopy", "PullRequestsListCellRenderer", "RightClickSelectionListener", "intellij.vcs.github"})
public final class GithubPullRequestsList
extends JBList<GithubSearchedIssue>
implements CopyProvider,
DataProvider,
Disposable {
    private final JBValue.UIInteger avatarIconSize;
    private final CachingGithubAvatarIconsProvider avatarIconsProvider;
    private final CopyPasteManager copyPasteManager;

    @Nullable
    public String getToolTipText(@NotNull MouseEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Component childComponent = ListUtil.getDeepestRendererChildComponentAt((JList)((JList)((Object)this)), (Point)event.getPoint());
        if (!(childComponent instanceof JComponent)) {
            return null;
        }
        return ((JComponent)childComponent).getToolTipText();
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (this.getSelectedIndex() < 0) {
            return;
        }
        GithubSearchedIssue selection = (GithubSearchedIssue)this.getModel().getElementAt(this.getSelectedIndex());
        StringBuilder stringBuilder = new StringBuilder().append('#');
        GithubSearchedIssue githubSearchedIssue = selection;
        Intrinsics.checkExpressionValueIsNotNull((Object)githubSearchedIssue, (String)"selection");
        this.copyPasteManager.setContents((Transferable)new StringSelection(stringBuilder.append(githubSearchedIssue.getNumber()).append(' ').append(selection.getTitle()).toString()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return !this.isSelectionEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return false;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this : (GithubPullRequestKeys.getSELECTED_SEARCHED_ISSUE$intellij_vcs_github().is(dataId) ? this.getSelectedValue() : null);
    }

    public void dispose() {
    }

    public GithubPullRequestsList(@NotNull CopyPasteManager copyPasteManager, @NotNull CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory, @NotNull ListModel<GithubSearchedIssue> model) {
        Intrinsics.checkParameterIsNotNull((Object)copyPasteManager, (String)"copyPasteManager");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProviderFactory, (String)"avatarIconsProviderFactory");
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        super(model);
        this.copyPasteManager = copyPasteManager;
        this.avatarIconSize = new JBValue.UIInteger("Github.PullRequests.List.Assignee.Avatar.Size", 20);
        this.avatarIconsProvider = avatarIconsProviderFactory.create((JBValue)this.avatarIconSize, (Component)((Object)this));
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionModel, (String)"selectionModel");
        listSelectionModel.setSelectionMode(0);
        this.addMouseListener(new RightClickSelectionListener());
        PullRequestsListCellRenderer renderer = new PullRequestsListCellRenderer();
        this.setCellRenderer(renderer);
        UIUtil.putClientProperty((JComponent)((JComponent)((Object)this)), (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)CollectionsKt.listOf((Object)renderer));
        ScrollingUtil.installActions((JList)((JList)((Object)this)));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J8\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsList$PullRequestsListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GithubSearchedIssue;", "Ljavax/swing/JPanel;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsList;)V", "assignees", "info", "Ljavax/swing/JLabel;", "labels", "stateIcon", "title", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.vcs.github"})
    private final class PullRequestsListCellRenderer
    extends JPanel
    implements ListCellRenderer<GithubSearchedIssue> {
        private final JLabel stateIcon = new JLabel();
        private final JLabel title = new JLabel();
        private final JLabel info = new JLabel();
        private final JPanel labels;
        private final JPanel assignees;

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends GithubSearchedIssue> list, @NotNull GithubSearchedIssue value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            UIUtil.setBackgroundRecursively((Component)this, (Color)GithubUIUtil.List.WithTallRow.INSTANCE.background(list, isSelected));
            Color primaryTextColor = GithubUIUtil.List.WithTallRow.INSTANCE.foreground(list, isSelected);
            Color secondaryTextColor = GithubUIUtil.List.WithTallRow.INSTANCE.secondaryForeground(list, isSelected);
            JComponent jComponent = this.stateIcon;
            boolean bl = false;
            boolean bl2 = false;
            JLabel $this$apply = jComponent;
            boolean bl3 = false;
            $this$apply.setIcon(value.getState() == GithubIssueState.open ? GithubIcons.PullRequestOpen : GithubIcons.PullRequestClosed);
            jComponent = this.title;
            bl = false;
            bl2 = false;
            $this$apply = jComponent;
            boolean bl4 = false;
            $this$apply.setText(value.getTitle());
            $this$apply.setForeground(primaryTextColor);
            jComponent = this.info;
            bl = false;
            bl2 = false;
            $this$apply = jComponent;
            boolean bl5 = false;
            StringBuilder stringBuilder = new StringBuilder().append('#').append(value.getNumber()).append(' ');
            GithubUser githubUser = value.getUser();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubUser, (String)"value.user");
            $this$apply.setText(stringBuilder.append(githubUser.getLogin()).append(" on ").append(DateFormatUtil.formatDate((Date)value.getCreatedAt())).toString());
            $this$apply.setForeground(secondaryTextColor);
            jComponent = this.labels;
            bl = false;
            bl2 = false;
            $this$apply = jComponent;
            boolean bl6 = false;
            $this$apply.removeAll();
            List list2 = value.getLabels();
            boolean bl7 = false;
            Object object = list2;
            if (object == null) {
                object = CollectionsKt.emptyList();
            }
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                GithubIssueLabel label;
                GithubIssueLabel githubIssueLabel = label = object2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubIssueLabel, (String)"label");
                $this$apply.add((Component)GithubUIUtil.INSTANCE.createIssueLabelLabel(githubIssueLabel));
                $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(4, 0)));
            }
            jComponent = this.assignees;
            bl = false;
            bl2 = false;
            $this$apply = jComponent;
            boolean bl8 = false;
            $this$apply.removeAll();
            for (GithubUser assignee2 : value.getAssignees()) {
                if ($this$apply.getComponentCount() != 0) {
                    $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
                }
                object2 = new JLabel();
                JLabel jLabel = $this$apply;
                boolean bl9 = false;
                boolean bl10 = false;
                Object $this$apply2 = object2;
                boolean bl11 = false;
                GithubUser githubUser2 = assignee2;
                ((JLabel)$this$apply2).setIcon(GithubPullRequestsList.this.avatarIconsProvider.getIcon(githubUser2 != null ? githubUser2.getAvatarUrl() : null));
                GithubUser githubUser3 = assignee2;
                Intrinsics.checkExpressionValueIsNotNull((Object)githubUser3, (String)"assignee");
                ((JComponent)$this$apply2).setToolTipText(githubUser3.getLogin());
                Object object3 = object2;
                jLabel.add((Component)object3);
            }
            return this;
        }

        public PullRequestsListCellRenderer() {
            JPanel jPanel;
            JPanel jPanel2 = new JPanel();
            PullRequestsListCellRenderer pullRequestsListCellRenderer = this;
            boolean bl = false;
            boolean bl2 = false;
            JPanel $this$apply = jPanel2;
            boolean bl3 = false;
            $this$apply.setLayout(new BoxLayout($this$apply, 0));
            pullRequestsListCellRenderer.labels = jPanel = jPanel2;
            jPanel2 = new JPanel();
            pullRequestsListCellRenderer = this;
            bl = false;
            bl2 = false;
            $this$apply = jPanel2;
            boolean bl4 = false;
            $this$apply.setLayout(new BoxLayout($this$apply, 0));
            pullRequestsListCellRenderer.assignees = jPanel = jPanel2;
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
            this.setLayout((LayoutManager)new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fillX()));
            String gapAfter = JBUI.scale((int)5) + "px";
            this.add((Component)this.stateIcon, new CC().gapAfter(gapAfter));
            this.add((Component)this.title, new CC().minWidth("pref/2px").gapAfter(gapAfter));
            this.add((Component)this.labels, new CC().growX().pushX().minWidth("0px").gapAfter(gapAfter));
            this.add((Component)this.assignees, new CC().spanY(2).wrap());
            this.add((Component)this.info, new CC().minWidth("0px").skip(1).spanX(2));
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsList$RightClickSelectionListener;", "Ljava/awt/event/MouseAdapter;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsList;)V", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.vcs.github"})
    private final class RightClickSelectionListener
    extends MouseAdapter {
        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            int row;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (JBSwingUtilities.isRightMouseButton((MouseEvent)e) && (row = GithubPullRequestsList.this.locationToIndex(e.getPoint())) != -1) {
                GithubPullRequestsList.this.getSelectionModel().setSelectionInterval(row, row);
            }
        }
    }
}

