/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public abstract class ChangesTrackingTableView<T>
extends TableView<T> {
    private Disposable myEditorListenerDisposable;

    protected abstract void onCellValueChanged(int var1, int var2, Object var3);

    protected abstract void onEditingStopped();

    public boolean editCellAt(final int row, final int column, EventObject e) {
        if (super.editCellAt(row, column, e)) {
            assert (this.myEditorListenerDisposable == null);
            this.myEditorListenerDisposable = Disposer.newDisposable();
            ChangesTrackingTableView.addChangeListener(this.getEditorComponent(), new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ChangesTrackingTableView.this.onCellValueChanged(row, column, ChangesTrackingTableView.getValue(ChangesTrackingTableView.this.getEditorComponent()));
                }
            }, this.myEditorListenerDisposable);
            return true;
        }
        return false;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = super.getCellEditor(row, column);
        if (column != 0 || editor instanceof DefaultCellEditor) {
            // empty if block
        }
        return editor;
    }

    public void removeEditor() {
        if (this.myEditorListenerDisposable != null) {
            Disposer.dispose((Disposable)this.myEditorListenerDisposable);
            this.myEditorListenerDisposable = null;
        }
        this.onEditingStopped();
        super.removeEditor();
    }

    public static Object getValue(Component component) {
        if (component instanceof CellEditorComponentWithBrowseButton) {
            JTextField textField2 = (JTextField)((CellEditorComponentWithBrowseButton)component).getChildComponent();
            return textField2.getText();
        }
        if (component instanceof JTextField) {
            return ((JTextField)component).getText();
        }
        if (component instanceof JComboBox) {
            return ((JComboBox)component).getSelectedItem();
        }
        if (component instanceof JCheckBox) {
            return ((JCheckBox)component).isSelected();
        }
        throw new UnsupportedOperationException("editor control of type " + component.getClass().getName() + " is not supported");
    }

    private static void addChangeListener(final Component component, final ChangeListener listener2, Disposable parentDisposable) {
        if (component instanceof CellEditorComponentWithBrowseButton) {
            ChangesTrackingTableView.addChangeListener(((CellEditorComponentWithBrowseButton)component).getChildComponent(), listener2, parentDisposable);
        } else if (component instanceof JTextField) {
            final DocumentAdapter documentListener = new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    listener2.stateChanged(new ChangeEvent(component));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/ChangesTrackingTableView$2", "textChanged"));
                }
            };
            final Document document = ((JTextField)component).getDocument();
            document.addDocumentListener((DocumentListener)documentListener);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    document.removeDocumentListener((DocumentListener)documentListener);
                }
            });
        } else if (component instanceof JComboBox) {
            final ActionListener comboListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    listener2.stateChanged(new ChangeEvent(component));
                }
            };
            ((JComboBox)component).addActionListener(comboListener);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    ((JComboBox)component).removeActionListener(comboListener);
                }
            });
        } else if (component instanceof JCheckBox) {
            final ActionListener checkBoxListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    listener2.stateChanged(new ChangeEvent(component));
                }
            };
            ((JCheckBox)component).addActionListener(checkBoxListener);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    ((JCheckBox)component).removeActionListener(checkBoxListener);
                }
            });
        } else {
            throw new UnsupportedOperationException("editor control of type " + component.getClass().getName() + " is not supported");
        }
    }
}

