/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(RenamePsiElementProcessor.class);
    public static final ExtensionPointName<RenamePsiElementProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.renamePsiElementProcessor");
    public static final RenamePsiElementProcessor DEFAULT = new RenamePsiElementProcessor(){

        @Override
        public boolean canProcessElement(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessor$1", "canProcessElement"));
        }
    };
    final boolean myOldFindMethodsImplemented;

    public RenamePsiElementProcessor() {
        boolean implemented;
        try {
            Method find1 = this.getClass().getMethod("findReferences", PsiElement.class);
            Method find2 = this.getClass().getMethod("findReferences", PsiElement.class, Boolean.TYPE);
            boolean bl = implemented = !RenamePsiElementProcessor.class.equals(find1.getDeclaringClass()) || !RenamePsiElementProcessor.class.equals(find2.getDeclaringClass());
            if (implemented) {
                LOG.warn(this.getClass().getName() + " overrides deprecated findReferences(..).\nOverride findReferences(PsiElement, SearchScope, boolean) instead.");
            }
        }
        catch (NoSuchMethodException e) {
            implemented = false;
            LOG.warn((Throwable)e);
        }
        this.myOldFindMethodsImplemented = implemented;
    }

    public abstract boolean canProcessElement(@NotNull PsiElement var1);

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (project == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(1);
        }
        RenameDialog renameDialog = new RenameDialog(project, element, nameSuggestionContext, editor);
        if (renameDialog == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(2);
        }
        return renameDialog;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(4);
        }
        if (usages == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(5);
        }
        RenameUtil.doRenameGenericNamedElement(element, newName, usages, listener2);
    }

    @Deprecated
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(6);
        }
        Collection<PsiReference> collection = this.myOldFindMethodsImplemented ? this.findReferences(element) : this.findReferences(element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), searchInCommentsAndStrings);
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Deprecated
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(8);
        }
        Collection<PsiReference> collection = this.myOldFindMethodsImplemented ? ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject())).findAll() : this.findReferences(element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), false);
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(11);
        }
        if (this.myOldFindMethodsImplemented) {
            Collection<PsiReference> refs = this.findReferences(element, searchInCommentsAndStrings);
            if (!searchScope.equals(GlobalSearchScope.projectScope((Project)element.getProject()))) {
                ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
                for (PsiReference ref : refs) {
                    VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)ref.getElement());
                    if (file2 != null && !searchScope.contains(file2)) continue;
                    result2.add(ref);
                }
                ArrayList<PsiReference> arrayList = result2;
                if (arrayList == null) {
                    RenamePsiElementProcessor.$$$reportNull$$$0(12);
                }
                return arrayList;
            }
            Collection<PsiReference> collection = refs;
            if (collection == null) {
                RenamePsiElementProcessor.$$$reportNull$$$0(13);
            }
            return collection;
        }
        Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)searchScope).findAll();
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(16);
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(17);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(18);
        }
        return null;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(19);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(20);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(21);
        }
        this.prepareRenaming(element, newName, allRenames, element.getUseScope());
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(22);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(23);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(25);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(26);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(27);
        }
        if (conflicts == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(28);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(29);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(30);
        }
        if (conflicts == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(31);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(32);
        }
        this.findExistingNameConflicts(element, newName, conflicts);
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    @NotNull
    public static List<RenamePsiElementProcessor> allForElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(33);
        }
        ArrayList<RenamePsiElementProcessor> result2 = new ArrayList<RenamePsiElementProcessor>();
        for (RenamePsiElementProcessor processor2 : (RenamePsiElementProcessor[])EP_NAME.getExtensions()) {
            if (!processor2.canProcessElement(element)) continue;
            result2.add(processor2);
        }
        ArrayList<RenamePsiElementProcessor> arrayList = result2;
        if (arrayList == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    public static RenamePsiElementProcessor forElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(35);
        }
        for (RenamePsiElementProcessor processor2 : EP_NAME.getExtensionList()) {
            if (!processor2.canProcessElement(element)) continue;
            RenamePsiElementProcessor renamePsiElementProcessor = processor2;
            if (renamePsiElementProcessor == null) {
                RenamePsiElementProcessor.$$$reportNull$$$0(36);
            }
            return renamePsiElementProcessor;
        }
        RenamePsiElementProcessor renamePsiElementProcessor = DEFAULT;
        if (renamePsiElementProcessor == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(37);
        }
        return renamePsiElementProcessor;
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String newName, @NotNull RefactoringElementListener elementListener) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(38);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(39);
        }
        if (elementListener == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(40);
        }
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        if (element instanceof PsiFile) {
            return "refactoring.renameFile";
        }
        return "refactoring.renameDialogs";
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(41);
        }
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(42);
        }
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(43);
        }
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(44);
        }
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE = enabled;
        }
    }

    public boolean showRenamePreviewButton(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(45);
        }
        return true;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(46);
        }
        return element;
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        PsiElement psiElement;
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(47);
        }
        if (editor == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(48);
        }
        if (renameCallback == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(49);
        }
        if ((psiElement = this.substituteElementToRename(element, editor)) == null) {
            return;
        }
        if (!PsiElementRenameHandler.canRename(psiElement.getProject(), editor, psiElement)) {
            return;
        }
        renameCallback.pass((Object)psiElement);
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(50);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(51);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(52);
        }
        if (result2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(53);
        }
    }

    public boolean forcesShowPreview() {
        return false;
    }

    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(54);
        }
        return element;
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(55);
        }
        if (ref == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(56);
        }
        if (referenceElement == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(57);
        }
        MoveRenameUsageInfo moveRenameUsageInfo = new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, ref.resolve() == null && (!(ref instanceof PsiPolyVariantReference) || ((PsiPolyVariantReference)ref).multiResolve(true).length <= 0));
        if (moveRenameUsageInfo == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(58);
        }
        return moveRenameUsageInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 34: 
            case 36: 
            case 37: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 34: 
            case 36: 
            case 37: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 26: 
            case 29: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 34: 
            case 36: 
            case 37: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenamePsiElementProcessor";
                break;
            }
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 30: 
            case 39: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 21: 
            case 24: 
            case 32: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementListener";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenamePsiElementProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "allForElement";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 34: 
            case 36: 
            case 37: 
            case 58: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrenceSearchStrings";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameAfterRename";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "allForElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPostRenameCallback";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "showRenamePreviewButton";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findCollisions";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getElementToSearchInStringsAndComments";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 34: 
            case 36: 
            case 37: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

