/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class InheritedJdkOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements InheritedJdkOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    @NonNls
    public static final String ENTRY_TYPE = "inheritedJdk";
    private final MyProjectJdkListener myListener;

    InheritedJdkOrderEntryImpl(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(0);
        }
        if (projectRootManager == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(1);
        }
        super(rootModel, projectRootManager);
        this.myListener = new MyProjectJdkListener();
        this.myProjectRootManagerImpl.addProjectJdkListener(this.myListener);
        this.myProjectRootManagerImpl.addJdkTableListener(new MyJdkTableListener(), this);
        this.init();
    }

    InheritedJdkOrderEntryImpl(@NotNull Element element, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        if (element == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(2);
        }
        if (rootModel == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(3);
        }
        if (projectRootManager == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(4);
        }
        this(rootModel, projectRootManager);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException(element.getName());
        }
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        if (rootModel == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(5);
        }
        if (projectRootManager == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(6);
        }
        if (filePointerManager == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(7);
        }
        InheritedJdkOrderEntryImpl inheritedJdkOrderEntryImpl = new InheritedJdkOrderEntryImpl(rootModel, projectRootManager);
        if (inheritedJdkOrderEntryImpl == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(8);
        }
        return inheritedJdkOrderEntryImpl;
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getJdk() != null;
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(9);
        }
        return (R)policy.visitInheritedJdkOrderEntry((InheritedJdkOrderEntry)this, initialValue);
    }

    @Override
    public void writeExternal(@NotNull Element rootElement) throws WriteExternalException {
        if (rootElement == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(10);
        }
        Element orderEntryElement = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        rootElement.addContent(orderEntryElement);
    }

    public Sdk getJdk() {
        Project project = this.getRootModel().getModule().getProject();
        return this.getRootModel().getConfigurationAccessor().getProjectSdk(project);
    }

    public String getJdkName() {
        Project project = this.getRootModel().getModule().getProject();
        return this.getRootModel().getConfigurationAccessor().getProjectSdkName(project);
    }

    @Override
    protected RootProvider getRootProvider() {
        Sdk projectJdk = this.myProjectRootManagerImpl.getProjectSdk();
        return projectJdk == null ? null : projectJdk.getRootProvider();
    }

    @NotNull
    public String getPresentableName() {
        String string = "< " + this.getJdkName() + " >";
        if (string == null) {
            InheritedJdkOrderEntryImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myProjectRootManagerImpl.removeProjectJdkListener(this.myListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointerManager";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/InheritedJdkOrderEntryImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/InheritedJdkOrderEntryImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneEntry";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cloneEntry";
                break;
            }
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyProjectJdkListener
    implements ProjectRootManagerEx.ProjectJdkListener {
        private MyProjectJdkListener() {
        }

        public void projectJdkChanged() {
            InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
        }
    }

    private class MyJdkTableListener
    implements ProjectJdkTable.Listener {
        private MyJdkTableListener() {
        }

        public void jdkRemoved(@NotNull Sdk jdk) {
            if (jdk == null) {
                MyJdkTableListener.$$$reportNull$$$0(0);
            }
            if (jdk.equals(InheritedJdkOrderEntryImpl.this.getJdk())) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        public void jdkAdded(@NotNull Sdk jdk) {
            if (jdk == null) {
                MyJdkTableListener.$$$reportNull$$$0(1);
            }
            if (this.isAffectedByJdk(jdk)) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            if (jdk == null) {
                MyJdkTableListener.$$$reportNull$$$0(2);
            }
            if (previousName == null) {
                MyJdkTableListener.$$$reportNull$$$0(3);
            }
            if (this.isAffectedByJdk(jdk)) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        private boolean isAffectedByJdk(Sdk jdk) {
            return jdk.getName().equals(InheritedJdkOrderEntryImpl.this.getJdkName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdk";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/InheritedJdkOrderEntryImpl$MyJdkTableListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkRemoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkNameChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

