/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.newui.HiDPIPluginLogoIcon;
import com.intellij.ide.plugins.newui.LazyPluginLogoIcon;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginLogoIconProvider;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginLogo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.plugins.newui.PluginLogo");
    private static final String CACHE_DIR = "imageCache";
    private static final String PLUGIN_ICON = "pluginIcon.svg";
    private static final String PLUGIN_ICON_DARK = "pluginIcon_dark.svg";
    private static final int PLUGIN_ICON_SIZE = 40;
    private static final int PLUGIN_ICON_SIZE_SCALED = 80;
    private static final Map<String, Pair<PluginLogoIconProvider, PluginLogoIconProvider>> ICONS = new HashMap<String, Pair<PluginLogoIconProvider, PluginLogoIconProvider>>();
    private static PluginLogoIconProvider Default;
    private static List<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> myPrepareToLoad;

    @NotNull
    public static Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, boolean big, boolean jb, boolean error, boolean disabled) {
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(0);
        }
        Icon icon = PluginLogo.getIcon(descriptor2).getIcon(big, jb, error, disabled);
        if (icon == null) {
            PluginLogo.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    private static PluginLogoIconProvider getIcon(@NotNull IdeaPluginDescriptor descriptor2) {
        Pair<PluginLogoIconProvider, PluginLogoIconProvider> icons;
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(2);
        }
        if ((icons = PluginLogo.getOrLoadIcon(descriptor2)) != null) {
            PluginLogoIconProvider pluginLogoIconProvider = JBColor.isBright() ? (PluginLogoIconProvider)icons.first : (PluginLogoIconProvider)icons.second;
            if (pluginLogoIconProvider == null) {
                PluginLogo.$$$reportNull$$$0(3);
            }
            return pluginLogoIconProvider;
        }
        PluginLogoIconProvider pluginLogoIconProvider = PluginLogo.getDefault();
        if (pluginLogoIconProvider == null) {
            PluginLogo.$$$reportNull$$$0(4);
        }
        return pluginLogoIconProvider;
    }

    public static void startBatchMode() {
        assert (myPrepareToLoad == null);
        myPrepareToLoad = new ArrayList<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>>();
    }

    public static void endBatchMode() {
        assert (myPrepareToLoad != null);
        List<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> descriptors = myPrepareToLoad;
        myPrepareToLoad = null;
        PluginLogo.runLoadTask(descriptors);
    }

    @NotNull
    private static PluginLogoIconProvider getDefault() {
        if (Default == null) {
            Default = new HiDPIPluginLogoIcon(AllIcons.Plugins.PluginLogo_40, AllIcons.Plugins.PluginLogoDisabled_40, AllIcons.Plugins.PluginLogo_80, AllIcons.Plugins.PluginLogoDisabled_80);
        }
        PluginLogoIconProvider pluginLogoIconProvider = Default;
        if (pluginLogoIconProvider == null) {
            PluginLogo.$$$reportNull$$$0(5);
        }
        return pluginLogoIconProvider;
    }

    @Nullable
    private static Pair<PluginLogoIconProvider, PluginLogoIconProvider> getOrLoadIcon(@NotNull IdeaPluginDescriptor descriptor2) {
        String idPlugin;
        Pair<PluginLogoIconProvider, PluginLogoIconProvider> icons;
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(6);
        }
        if ((icons = ICONS.get(idPlugin = PluginLogo.getIdForKey(descriptor2))) != null) {
            return icons.first == null && icons.second == null ? null : icons;
        }
        LazyPluginLogoIcon lazyIcon = new LazyPluginLogoIcon(PluginLogo.getDefault());
        Pair lazyIcons = Pair.create((Object)lazyIcon, (Object)lazyIcon);
        ICONS.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)lazyIcons);
        Pair info = Pair.create((Object)descriptor2, (Object)lazyIcon);
        if (myPrepareToLoad == null) {
            PluginLogo.runLoadTask(Collections.singletonList(info));
        } else {
            myPrepareToLoad.add((Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>)info);
        }
        return lazyIcons;
    }

    private static void runLoadTask(@NotNull List<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> loadInfo) {
        if (loadInfo == null) {
            PluginLogo.$$$reportNull$$$0(7);
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            for (Pair info : loadInfo) {
                if (application.isDisposed()) {
                    return;
                }
                PluginLogo.loadPluginIcons((IdeaPluginDescriptor)info.first, (LazyPluginLogoIcon)info.second);
            }
        });
    }

    private static void loadPluginIcons(@NotNull IdeaPluginDescriptor descriptor2, @NotNull LazyPluginLogoIcon lazyIcon) {
        PluginLogoIconProvider dark;
        PluginLogoIconProvider light;
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(8);
        }
        if (lazyIcon == null) {
            PluginLogo.$$$reportNull$$$0(9);
        }
        String idPlugin = PluginLogo.getIdForKey(descriptor2);
        File path = descriptor2.getPath();
        if (path != null) {
            if (path.isDirectory()) {
                if (System.getProperty("idea.required.plugins.id") != null && PluginLogo.tryLoadDirIcons(idPlugin, lazyIcon, new File(path, "classes"))) {
                    return;
                }
                if (PluginLogo.tryLoadDirIcons(idPlugin, lazyIcon, path)) {
                    return;
                }
                File libFile = new File(path, "lib");
                if (!libFile.exists() || !libFile.isDirectory()) {
                    PluginLogo.putIcon(idPlugin, lazyIcon, null, null);
                    return;
                }
                Object[] files2 = libFile.listFiles();
                if (ArrayUtil.isEmpty((Object[])files2)) {
                    PluginLogo.putIcon(idPlugin, lazyIcon, null, null);
                    return;
                }
                for (Object file2 : files2) {
                    if (PluginLogo.tryLoadDirIcons(idPlugin, lazyIcon, (File)file2)) {
                        return;
                    }
                    if (!PluginLogo.tryLoadJarIcons(idPlugin, lazyIcon, (File)file2, false)) continue;
                    return;
                }
            } else {
                PluginLogo.tryLoadJarIcons(idPlugin, lazyIcon, path, true);
                return;
            }
            PluginLogo.putIcon(idPlugin, lazyIcon, null, null);
            return;
        }
        String idFileName = FileUtil.sanitizeFileName((String)idPlugin);
        File cache = new File(PathManager.getPluginTempPath(), CACHE_DIR);
        File lightFile = new File(cache, idFileName + ".svg");
        File darkFile = new File(cache, idFileName + "_dark.svg");
        if (cache.exists()) {
            light = PluginLogo.tryLoadIcon(lightFile);
            dark = PluginLogo.tryLoadIcon(darkFile);
            if (light != null || dark != null) {
                PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
                return;
            }
        }
        try {
            PluginLogo.downloadFile(idPlugin, lightFile, "");
            PluginLogo.downloadFile(idPlugin, darkFile, "&theme=DARCULA");
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        light = PluginLogo.tryLoadIcon(lightFile);
        dark = PluginLogo.tryLoadIcon(darkFile);
        PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
    }

    @NotNull
    private static String getIdForKey(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(10);
        }
        String string = descriptor2.getPluginId().getIdString() + (descriptor2.getPath() == null || MyPluginModel.getInstallingPlugins().contains(descriptor2) || InstalledPluginsState.getInstance().wasInstalled(descriptor2.getPluginId()) ? "" : "#local");
        if (string == null) {
            PluginLogo.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean tryLoadDirIcons(@NotNull String idPlugin, @NotNull LazyPluginLogoIcon lazyIcon, @NotNull File path) {
        if (idPlugin == null) {
            PluginLogo.$$$reportNull$$$0(12);
        }
        if (lazyIcon == null) {
            PluginLogo.$$$reportNull$$$0(13);
        }
        if (path == null) {
            PluginLogo.$$$reportNull$$$0(14);
        }
        PluginLogoIconProvider light = PluginLogo.tryLoadIcon(path, true);
        PluginLogoIconProvider dark = PluginLogo.tryLoadIcon(path, false);
        if (light != null || dark != null) {
            PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean tryLoadJarIcons(@NotNull String idPlugin, @NotNull LazyPluginLogoIcon lazyIcon, @NotNull File path, boolean put) {
        if (idPlugin == null) {
            PluginLogo.$$$reportNull$$$0(15);
        }
        if (lazyIcon == null) {
            PluginLogo.$$$reportNull$$$0(16);
        }
        if (path == null) {
            PluginLogo.$$$reportNull$$$0(17);
        }
        if (!FileUtilRt.isJarOrZip((File)path)) return false;
        if (!path.exists()) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(path);){
            PluginLogoIconProvider light = PluginLogo.tryLoadIcon(zipFile, true);
            PluginLogoIconProvider dark = PluginLogo.tryLoadIcon(zipFile, false);
            if (!put && light == null) {
                if (dark == null) return false;
            }
            PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    private static void downloadFile(@NotNull String idPlugin, @NotNull File file2, @NotNull String theme) {
        if (idPlugin == null) {
            PluginLogo.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            PluginLogo.$$$reportNull$$$0(19);
        }
        if (theme == null) {
            PluginLogo.$$$reportNull$$$0(20);
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        try {
            Url url = Urls.newFromEncoded((String)(ApplicationInfoImpl.getShadowInstance().getPluginManagerUrl() + "/api/icon?pluginId=" + URLUtil.encodeURIComponent((String)idPlugin) + theme));
            HttpRequests.request((Url)url).productNameAsUserAgent().saveToFile(file2, null);
        }
        catch (HttpRequests.HttpStatusException url) {
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    private static void putIcon(@NotNull String idPlugin, @NotNull LazyPluginLogoIcon lazyIcon, @Nullable PluginLogoIconProvider light, @Nullable PluginLogoIconProvider dark) {
        if (idPlugin == null) {
            PluginLogo.$$$reportNull$$$0(21);
        }
        if (lazyIcon == null) {
            PluginLogo.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (light == null && dark == null) {
                ICONS.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)Pair.empty());
                return;
            }
            Pair icons = Pair.create((Object)(light == null ? dark : light), (Object)(dark == null ? light : dark));
            ICONS.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)icons);
            lazyIcon.setLogoIcon(JBColor.isBright() ? (PluginLogoIconProvider)icons.first : (PluginLogoIconProvider)icons.second);
        }, ModalityState.any());
    }

    @Nullable
    private static PluginLogoIconProvider tryLoadIcon(@NotNull File dirFile, boolean light) {
        if (dirFile == null) {
            PluginLogo.$$$reportNull$$$0(23);
        }
        return PluginLogo.tryLoadIcon(new File(dirFile, PluginLogo.getIconFileName(light)));
    }

    @Nullable
    private static PluginLogoIconProvider tryLoadIcon(@NotNull File iconFile) {
        if (iconFile == null) {
            PluginLogo.$$$reportNull$$$0(24);
        }
        return iconFile.exists() && iconFile.length() > 0L ? PluginLogo.loadFileIcon((ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> new FileInputStream(iconFile))) : null;
    }

    @Nullable
    private static PluginLogoIconProvider tryLoadIcon(@NotNull ZipFile zipFile, boolean light) {
        ZipEntry iconEntry;
        if (zipFile == null) {
            PluginLogo.$$$reportNull$$$0(25);
        }
        return (iconEntry = zipFile.getEntry(PluginLogo.getIconFileName(light))) == null ? null : PluginLogo.loadFileIcon((ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> zipFile.getInputStream(iconEntry)));
    }

    @NotNull
    public static String getIconFileName(boolean light) {
        String string = "META-INF/" + (light ? PLUGIN_ICON : PLUGIN_ICON_DARK);
        if (string == null) {
            PluginLogo.$$$reportNull$$$0(26);
        }
        return string;
    }

    public static int height() {
        return 40;
    }

    public static int width() {
        return 40;
    }

    @Nullable
    private static PluginLogoIconProvider loadFileIcon(@NotNull ThrowableComputable<? extends InputStream, ? extends IOException> provider) {
        if (provider == null) {
            PluginLogo.$$$reportNull$$$0(27);
        }
        try {
            Icon logo40 = HiDPIPluginLogoIcon.loadSVG((InputStream)provider.compute(), 40, 40);
            Icon logo80 = HiDPIPluginLogoIcon.loadSVG((InputStream)provider.compute(), 80, 80);
            return new HiDPIPluginLogoIcon(logo40, logo80);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            LafManager.getInstance().addLafManagerListener(_0 -> {
                Default = null;
                HiDPIPluginLogoIcon.clearCache();
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginLogo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadInfo";
                break;
            }
            case 9: 
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyIcon";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPlugin";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginLogo";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdForKey";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 26: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runLoadTask";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadPluginIcons";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIdForKey";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadDirIcons";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadJarIcons";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "putIcon";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadIcon";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadFileIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

