/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.CountComponent;
import com.intellij.ide.plugins.CountIcon;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsManagerMain;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginHostsConfigurable;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerConfigurableInfo;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.LinkComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.NewListPluginComponent;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginListLayout;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.PluginsTab;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.SearchUpDownPopupController;
import com.intellij.ide.plugins.newui.TabbedPaneHeaderComponent;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerConfigurableNewLayout
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.NoMargin,
Configurable.TopComponentProvider,
PluginManagerConfigurableInfo {
    private static final int MARKETPLACE_TAB = 0;
    private static final int INSTALLED_TAB = 1;
    private TabbedPaneHeaderComponent myTabHeaderComponent;
    private MultiPanel myCardPanel;
    private PluginsTab myMarketplaceTab;
    private PluginsTab myInstalledTab;
    private PluginsGroupComponentWithProgress myMarketplacePanel;
    private PluginsGroupComponent myInstalledPanel;
    private Runnable myMarketplaceRunnable;
    private SearchResultPanel myMarketplaceSearchPanel;
    private SearchResultPanel myInstalledSearchPanel;
    private LinkListener<IdeaPluginDescriptor> myNameListener;
    private LinkListener<String> mySearchListener;
    private final LinkLabel<Object> myUpdateAll = new LinkLabel("Update All", null);
    private final JLabel myUpdateCounter = new CountComponent();
    private final CountIcon myCountIcon = new CountIcon();
    private final MyPluginModel myPluginModel = new MyPluginModel(){

        @Override
        public List<IdeaPluginDescriptor> getAllRepoPlugins() {
            return PluginManagerConfigurableNewLayout.this.getPluginRepositories();
        }
    };
    private Runnable myShutdownCallback;
    private PluginUpdatesService myPluginUpdatesService;
    private List<IdeaPluginDescriptor> myAllRepositoriesList;
    private Map<String, IdeaPluginDescriptor> myAllRepositoriesMap;
    private Map<String, List<IdeaPluginDescriptor>> myCustomRepositoriesMap;
    private final Object myRepositoriesLock = new Object();
    private List<String> myTagsSorted;
    private List<String> myVendorsSorted;
    private DefaultActionGroup myMarketplaceSortByGroup;
    private java.util.function.Consumer<MarketplaceSortByAction> myMarketplaceSortByCallback;
    private LinkComponent myMarketplaceSortByAction;
    private DefaultActionGroup myInstalledSearchGroup;
    private java.util.function.Consumer<InstalledSearchOptionAction> myInstalledSearchCallback;
    private boolean myInstalledSearchSetState = true;

    @NotNull
    public String getId() {
        if ("preferences.pluginManager" == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(0);
        }
        return "preferences.pluginManager";
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    }

    @NotNull
    public Component getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        if (controller == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(1);
        }
        this.myPluginModel.setTopController(controller);
        TabbedPaneHeaderComponent tabbedPaneHeaderComponent = this.myTabHeaderComponent;
        if (tabbedPaneHeaderComponent == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(2);
        }
        return tabbedPaneHeaderComponent;
    }

    @Nullable
    public JComponent createComponent() {
        this.myTabHeaderComponent = new TabbedPaneHeaderComponent(this.createGearActions(), index -> {
            this.myCardPanel.select(index, true);
            PluginManagerConfigurableNewLayout.storeSelectionTab(index);
            String query = (index == 0 ? this.myInstalledTab : this.myMarketplaceTab).getSearchQuery();
            (index == 0 ? this.myMarketplaceTab : this.myInstalledTab).setSearchQuery(query);
        });
        this.myUpdateAll.setVisible(false);
        this.myUpdateCounter.setVisible(false);
        this.myTabHeaderComponent.addTab("Marketplace", null);
        this.myTabHeaderComponent.addTab("Installed", this.myCountIcon);
        this.myPluginUpdatesService = PluginUpdatesService.connectConfigurable(countValue -> {
            int count = countValue == null ? 0 : countValue;
            String text2 = String.valueOf(count);
            boolean visible = count > 0;
            this.myUpdateAll.setEnabled(true);
            this.myUpdateAll.setVisible(visible);
            this.myUpdateCounter.setText(text2);
            this.myUpdateCounter.setVisible(visible);
            this.myCountIcon.setText(text2);
            this.myTabHeaderComponent.update();
        });
        this.myPluginModel.setPluginUpdatesService(this.myPluginUpdatesService);
        this.myNameListener = (aSource, aLinkData) -> {};
        this.mySearchListener = (aSource, aLinkData) -> {};
        this.createMarketplaceTab();
        this.createInstalledTab();
        this.myCardPanel = new MultiPanel(){

            @Override
            protected JComponent create(Integer key) {
                if (key == 0) {
                    return PluginManagerConfigurableNewLayout.this.myMarketplaceTab.createPanel();
                }
                if (key == 1) {
                    return PluginManagerConfigurableNewLayout.this.myInstalledTab.createPanel();
                }
                return super.create(key);
            }
        };
        this.myCardPanel.setMinimumSize((Dimension)new JBDimension(580, 380));
        this.myTabHeaderComponent.setListener();
        int selectionTab = PluginManagerConfigurableNewLayout.getStoredSelectionTab();
        this.myTabHeaderComponent.setSelection(selectionTab);
        this.myCardPanel.select(selectionTab, true);
        return this.myCardPanel;
    }

    @NotNull
    private DefaultActionGroup createGearActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new DumbAwareAction("Manage Plugin Repositories..."){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)PluginManagerConfigurableNewLayout.this.myCardPanel, (Configurable)new PluginHostsConfigurable())) {
                    PluginManagerConfigurableNewLayout.this.resetPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$3", "actionPerformed"));
            }
        });
        actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"button.http.proxy.settings", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (HttpConfigurable.editConfigurable((JComponent)PluginManagerConfigurableNewLayout.this.myCardPanel)) {
                    PluginManagerConfigurableNewLayout.this.resetPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$4", "actionPerformed"));
            }
        });
        actions.addSeparator();
        actions.add((AnAction)new DumbAwareAction("Install Plugin from Disk..."){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                InstalledPluginsManagerMain.chooseAndInstall(PluginManagerConfigurableNewLayout.this.myPluginModel, PluginManagerConfigurableNewLayout.this.myCardPanel, (Consumer<? super Pair<File, IdeaPluginDescriptor>>)((Consumer)pair -> {
                    boolean select;
                    PluginManagerConfigurableNewLayout.this.myPluginModel.appendOrUpdateDescriptor((IdeaPluginDescriptor)pair.second);
                    boolean bl = select = PluginManagerConfigurableNewLayout.this.myInstalledPanel == null;
                    if (PluginManagerConfigurableNewLayout.this.myTabHeaderComponent.getSelectionTab() != 1) {
                        PluginManagerConfigurableNewLayout.this.myTabHeaderComponent.setSelectionWithEvents(1);
                    }
                    PluginManagerConfigurableNewLayout.this.myInstalledTab.clearSearchPanel("");
                    if (select) {
                        for (UIPluginGroup group : PluginManagerConfigurableNewLayout.this.myInstalledPanel.getGroups()) {
                            CellPluginComponent component = group.findComponent((IdeaPluginDescriptor)pair.second);
                            if (component == null) continue;
                            PluginManagerConfigurableNewLayout.this.myInstalledPanel.setSelection(component);
                            break;
                        }
                    }
                }));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$5", "actionPerformed"));
            }
        });
        actions.addSeparator();
        actions.add((AnAction)new ChangePluginStateAction(false));
        actions.add((AnAction)new ChangePluginStateAction(true));
        DefaultActionGroup defaultActionGroup = actions;
        if (defaultActionGroup == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    private static void showRightBottomPopup(final @NotNull Component component, @NotNull String title, @NotNull ActionGroup group) {
        if (component == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(4);
        }
        if (title == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(5);
        }
        if (group == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(6);
        }
        GroupByActionGroup actions = new GroupByActionGroup();
        actions.addSeparator("  " + title);
        actions.addAll(group);
        DataContext context = DataManager.getInstance().getDataContext(component);
        final PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, (ActionGroup)actions, context, false, false, false, true, null, -1, null, null){

            @Override
            protected ListCellRenderer getListElementRenderer() {
                return new PopupListElementRenderer(this){

                    protected SeparatorWithText createSeparator() {
                        return new SeparatorWithText(){
                            {
                                this.setTextForeground((Color)JBColor.BLACK);
                                this.setFont(UIUtil.getLabelFont());
                                this.setCaptionCentered(false);
                            }

                            protected void paintLine(Graphics g, int x, int y, int width) {
                            }
                        };
                    }

                    protected Border getDefaultItemComponentBorder() {
                        return new EmptyBorder((Insets)JBInsets.create((int)UIUtil.getListCellVPadding(), (int)15));
                    }
                };
            }
        };
        popup2.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    7.$$$reportNull$$$0(0);
                }
                Point location = component.getLocationOnScreen();
                Dimension size = popup2.getSize();
                popup2.setLocation(new Point(location.x + component.getWidth() - size.width, location.y + component.getHeight()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$7", "beforeShown"));
            }
        });
        popup2.show(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPanels() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            this.myAllRepositoriesList = null;
            this.myAllRepositoriesMap = null;
            this.myCustomRepositoriesMap = null;
        }
        this.myTagsSorted = null;
        this.myVendorsSorted = null;
        this.myPluginUpdatesService.recalculateUpdates();
        if (this.myMarketplacePanel == null) {
            return;
        }
        int selectionTab = this.myTabHeaderComponent.getSelectionTab();
        if (selectionTab == 0) {
            this.myMarketplaceRunnable.run();
        } else {
            this.myMarketplacePanel.setVisibleRunnable(this.myMarketplaceRunnable);
        }
    }

    private static int getStoredSelectionTab() {
        int value = PropertiesComponent.getInstance().getInt("PluginConfigurable.selectionTab", 0);
        return value < 0 || value > 1 ? 0 : value;
    }

    private static void storeSelectionTab(int value) {
        PropertiesComponent.getInstance().setValue("PluginConfigurable.selectionTab", value, 0);
    }

    private void createMarketplaceTab() {
        this.myMarketplaceTab = new PluginsTab(){

            @Override
            protected void createSearchTextField(int flyDelay) {
                super.createSearchTextField(250);
                this.mySearchTextField.setHistoryPropertyName("MarketplacePluginsSearchHistory");
            }

            @Override
            @NotNull
            protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
                if (searchListener == null) {
                    8.$$$reportNull$$$0(0);
                }
                PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(PluginManagerConfigurableNewLayout.this.myPluginModel, searchListener, true);
                PluginManagerConfigurableNewLayout.this.myPluginModel.addDetailPanel(detailPanel);
                PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
                if (pluginDetailsPageComponent == null) {
                    8.$$$reportNull$$$0(1);
                }
                return pluginDetailsPageComponent;
            }

            @Override
            @NotNull
            protected JComponent createPluginsPanel(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    8.$$$reportNull$$$0(2);
                }
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                PluginManagerConfigurableNewLayout.this.myMarketplacePanel = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginListLayout()), eventHandler, (LinkListener<IdeaPluginDescriptor>)PluginManagerConfigurableNewLayout.this.myNameListener, (LinkListener<String>)PluginManagerConfigurableNewLayout.this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)d -> new NewListPluginComponent(PluginManagerConfigurableNewLayout.this.myPluginModel, (IdeaPluginDescriptor)d, true)));
                PluginManagerConfigurableNewLayout.this.myMarketplacePanel.setSelectionListener(selectionListener);
                PluginManagerConfigurableNew.registerCopyProvider(PluginManagerConfigurableNewLayout.this.myMarketplacePanel);
                ((SearchUpDownPopupController)((PluginManagerConfigurableNewLayout)PluginManagerConfigurableNewLayout.this).myMarketplaceSearchPanel.controller).setEventHandler(eventHandler);
                Runnable runnable2 = () -> {
                    ArrayList groups = new ArrayList();
                    try {
                        Pair pair = PluginManagerConfigurableNewLayout.this.loadPluginRepositories();
                        Map allRepositoriesMap = (Map)pair.first;
                        Map customRepositoriesMap = (Map)pair.second;
                        try {
                            PluginManagerConfigurableNewLayout.this.addGroup(groups, allRepositoriesMap, "Featured", "is_featured_search=true", "/sortBy:featured");
                            PluginManagerConfigurableNewLayout.this.addGroup(groups, allRepositoriesMap, "New and Updated", "orderBy=update+date", "/sortBy:updated");
                            PluginManagerConfigurableNewLayout.this.addGroup(groups, allRepositoriesMap, "Top Downloads", "orderBy=downloads", "/sortBy:downloads");
                            PluginManagerConfigurableNewLayout.this.addGroup(groups, allRepositoriesMap, "Top Rated", "orderBy=rating", "/sortBy:rating");
                        }
                        catch (IOException e) {
                            PluginManagerMain.LOG.info("Main plugin repository is not available ('" + e.getMessage() + "'). Please check your network settings.");
                        }
                        for (String host : UpdateSettings.getInstance().getPluginHosts()) {
                            List allDescriptors = (List)customRepositoriesMap.get(host);
                            if (allDescriptors == null) continue;
                            PluginManagerConfigurableNewLayout.this.addGroup(groups, "Repository: " + host, "/repository:\"" + host + "\"", (ThrowableNotNullFunction<? super List<IdeaPluginDescriptor>, Boolean, ? extends IOException>)descriptors -> {
                                int allSize = allDescriptors.size();
                                descriptors.addAll(ContainerUtil.getFirstItems((List)allDescriptors, (int)9));
                                PluginsGroup.sortByName(descriptors);
                                return allSize > 9;
                            });
                        }
                    }
                    catch (IOException e) {
                        PluginManagerMain.LOG.info((Throwable)e);
                    }
                    finally {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            PluginManagerConfigurableNewLayout.this.myMarketplacePanel.stopLoading();
                            PluginLogo.startBatchMode();
                            for (PluginsGroup group : groups) {
                                PluginManagerConfigurableNewLayout.this.myMarketplacePanel.addGroup(group);
                            }
                            PluginLogo.endBatchMode();
                            PluginManagerConfigurableNewLayout.this.myMarketplacePanel.doLayout();
                            PluginManagerConfigurableNewLayout.this.myMarketplacePanel.initialSelection();
                        }, ModalityState.any());
                    }
                };
                PluginManagerConfigurableNewLayout.this.myMarketplaceRunnable = () -> {
                    PluginManagerConfigurableNewLayout.this.myMarketplacePanel.clear();
                    PluginManagerConfigurableNewLayout.this.myMarketplacePanel.startLoading();
                    ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                };
                PluginManagerConfigurableNewLayout.this.myMarketplacePanel.getEmptyText().setText("Marketplace plugins are not loaded.").appendSecondaryText("Check the internet connection and ", StatusText.DEFAULT_ATTRIBUTES, null).appendSecondaryText("refresh", SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> PluginManagerConfigurableNewLayout.this.myMarketplaceRunnable.run());
                ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                JComponent jComponent = PluginManagerConfigurableNewLayout.createScrollPane(PluginManagerConfigurableNewLayout.this.myMarketplacePanel, false);
                if (jComponent == null) {
                    8.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            @Override
            protected void updateMainSelection(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    8.$$$reportNull$$$0(4);
                }
                selectionListener.accept(PluginManagerConfigurableNewLayout.this.myMarketplacePanel);
            }

            @Override
            @NotNull
            protected SearchResultPanel createSearchPanel(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    8.$$$reportNull$$$0(5);
                }
                SearchUpDownPopupController marketplaceController = new SearchUpDownPopupController(this.mySearchTextField){

                    @Override
                    @NotNull
                    protected List<String> getAttributes() {
                        ArrayList<String> attributes = new ArrayList<String>();
                        attributes.add("/tag:");
                        attributes.add("/sortBy:");
                        attributes.add("/vendor:");
                        if (!UpdateSettings.getInstance().getPluginHosts().isEmpty()) {
                            attributes.add("/repository:");
                        }
                        ArrayList<String> arrayList = attributes;
                        if (arrayList == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return arrayList;
                    }

                    @Override
                    @Nullable
                    protected List<String> getValues(@NotNull String attribute) {
                        if (attribute == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        switch (attribute) {
                            case "/tag:": {
                                if (ContainerUtil.isEmpty((Collection)PluginManagerConfigurableNewLayout.this.myTagsSorted)) {
                                    HashSet<String> allTags = new HashSet<String>();
                                    for (IdeaPluginDescriptor descriptor2 : PluginManagerConfigurableNewLayout.this.getPluginRepositories()) {
                                        List<String> tags;
                                        if (!(descriptor2 instanceof PluginNode) || ContainerUtil.isEmpty(tags = ((PluginNode)descriptor2).getTags())) continue;
                                        allTags.addAll(tags);
                                    }
                                    PluginManagerConfigurableNewLayout.this.myTagsSorted = ContainerUtil.sorted(allTags, String::compareToIgnoreCase);
                                }
                                return PluginManagerConfigurableNewLayout.this.myTagsSorted;
                            }
                            case "/sortBy:": {
                                return Arrays.asList("downloads", "name", "rating", "updated");
                            }
                            case "/vendor:": {
                                if (ContainerUtil.isEmpty((Collection)PluginManagerConfigurableNewLayout.this.myVendorsSorted)) {
                                    PluginManagerConfigurableNewLayout.this.myVendorsSorted = MyPluginModel.getVendors(PluginManagerConfigurableNewLayout.this.getPluginRepositories());
                                }
                                return PluginManagerConfigurableNewLayout.this.myVendorsSorted;
                            }
                            case "/repository:": {
                                return UpdateSettings.getInstance().getPluginHosts();
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void handleAppendToQuery() {
                        this.showPopupForQuery();
                    }

                    @Override
                    protected void handleAppendAttributeValue() {
                        this.showPopupForQuery();
                    }

                    @Override
                    protected void showPopupForQuery() {
                        this.hidePopup();
                        this.showSearchPanel(mySearchTextField.getText());
                    }

                    @Override
                    protected void handleEnter() {
                        if (!mySearchTextField.getText().isEmpty()) {
                            this.handleTrigger("marketplace.suggest.popup.enter");
                        }
                    }

                    @Override
                    protected void handlePopupListFirstSelection() {
                        this.handleTrigger("marketplace.suggest.popup.select");
                    }

                    private void handleTrigger(@NonNls String key) {
                        if (this.myPopup != null && this.myPopup.type == SearchPopup.Type.SearchQuery) {
                            FeatureUsageTracker.getInstance().triggerFeatureUsed(key);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$8$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attribute";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAttributes";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$8$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getValues";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByGroup = new DefaultActionGroup();
                for (SortBySearchOption option : SortBySearchOption.values()) {
                    PluginManagerConfigurableNewLayout.this.myMarketplaceSortByGroup.addAction((AnAction)new MarketplaceSortByAction(option));
                }
                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByAction = new LinkComponent(){

                    protected boolean isInClickableArea(Point pt) {
                        return true;
                    }
                };
                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByAction.setIcon(new Icon(){

                    @Override
                    public void paintIcon(Component c2, Graphics g, int x, int y) {
                        this.getIcon().paintIcon(c2, g, x, y + 1);
                    }

                    @Override
                    public int getIconWidth() {
                        return this.getIcon().getIconWidth();
                    }

                    @Override
                    public int getIconHeight() {
                        return this.getIcon().getIconHeight();
                    }

                    @NotNull
                    private Icon getIcon() {
                        Icon icon = AllIcons.General.ButtonDropTriangle;
                        if (icon == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return icon;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$8$3", "getIcon"));
                    }
                });
                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByAction.setPaintUnderline(false);
                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByAction.setIconTextGap(JBUIScale.scale((int)4));
                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByAction.setHorizontalTextPosition(2);
                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByAction.setForeground(PluginsGroupComponent.SECTION_HEADER_FOREGROUND);
                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByAction.setListener((component, __) -> PluginManagerConfigurableNewLayout.showRightBottomPopup(component.getParent().getParent(), "Sort By", (ActionGroup)PluginManagerConfigurableNewLayout.this.myMarketplaceSortByGroup), null);
                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByCallback = updateAction -> {
                    String query;
                    MarketplaceSortByAction removeAction = null;
                    MarketplaceSortByAction addAction = null;
                    if (((MarketplaceSortByAction)updateAction).myState) {
                        for (AnAction action2 : PluginManagerConfigurableNewLayout.this.myMarketplaceSortByGroup.getChildren(null)) {
                            MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                            if (sortByAction == updateAction || !sortByAction.myState) continue;
                            sortByAction.myState = false;
                            removeAction = sortByAction;
                            break;
                        }
                        addAction = updateAction;
                    } else {
                        if (((MarketplaceSortByAction)updateAction).myOption == SortBySearchOption.Relevance) {
                            ((MarketplaceSortByAction)updateAction).myState = true;
                            return;
                        }
                        for (AnAction action3 : PluginManagerConfigurableNewLayout.this.myMarketplaceSortByGroup.getChildren(null)) {
                            MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action3;
                            if (sortByAction.myOption != SortBySearchOption.Relevance) continue;
                            sortByAction.myState = true;
                            break;
                        }
                        removeAction = updateAction;
                    }
                    final ArrayList<String> queries = new ArrayList<String>();
                    new SearchQueryParser.Marketplace(this.mySearchTextField.getText()){

                        @Override
                        protected void addToSearchQuery(@NotNull String query) {
                            if (query == null) {
                                4.$$$reportNull$$$0(0);
                            }
                            super.addToSearchQuery(query);
                            queries.add(query);
                        }

                        @Override
                        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert) {
                            if (name == null) {
                                4.$$$reportNull$$$0(1);
                            }
                            if (value == null) {
                                4.$$$reportNull$$$0(2);
                            }
                            super.handleAttribute(name, value, invert);
                            queries.add(name + ":" + SearchQueryParser.wrapAttribute(value));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "query";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "value";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$8$4";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "addToSearchQuery";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "handleAttribute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    if (removeAction != null && (query = removeAction.getQuery()) != null) {
                        queries.remove(query);
                    }
                    if (addAction != null && (query = addAction.getQuery()) != null) {
                        queries.add(query);
                    }
                    query = StringUtil.join(queries, (String)" ");
                    this.mySearchTextField.setTextIgnoreEvents(query);
                    if (query.isEmpty()) {
                        PluginManagerConfigurableNewLayout.this.myMarketplaceTab.hideSearchPanel();
                    } else {
                        PluginManagerConfigurableNewLayout.this.myMarketplaceTab.showSearchPanel(query);
                    }
                };
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                marketplaceController.setSearchResultEventHandler(eventHandler);
                PluginsGroupComponentWithProgress panel2 = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginListLayout()), eventHandler, (LinkListener<IdeaPluginDescriptor>)PluginManagerConfigurableNewLayout.this.myNameListener, (LinkListener<String>)PluginManagerConfigurableNewLayout.this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor2 -> new NewListPluginComponent(PluginManagerConfigurableNewLayout.this.myPluginModel, (IdeaPluginDescriptor)descriptor2, true)));
                panel2.setSelectionListener(selectionListener);
                PluginManagerConfigurableNew.registerCopyProvider(panel2);
                PluginManagerConfigurableNewLayout.this.myMarketplaceSearchPanel = new SearchResultPanel(marketplaceController, panel2, 0, 0){

                    @Override
                    protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                        if (query == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if (result2 == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        try {
                            Pair p = PluginManagerConfigurableNewLayout.this.loadPluginRepositories();
                            Map allRepositoriesMap = (Map)p.first;
                            Map customRepositoriesMap = (Map)p.second;
                            SearchQueryParser.Marketplace parser = new SearchQueryParser.Marketplace(query);
                            if (!parser.vendors.isEmpty()) {
                                for (IdeaPluginDescriptor descriptor2 : PluginManagerConfigurableNewLayout.this.getPluginRepositories()) {
                                    if (!MyPluginModel.isVendor(descriptor2, parser.vendors)) continue;
                                    result2.descriptors.add(descriptor2);
                                }
                                ContainerUtil.removeDuplicates(result2.descriptors);
                                result2.sortByName();
                                return;
                            }
                            if (!parser.repositories.isEmpty()) {
                                for (String repository : parser.repositories) {
                                    List descriptors = (List)customRepositoriesMap.get(repository);
                                    if (descriptors == null) continue;
                                    if (parser.searchQuery == null) {
                                        result2.descriptors.addAll(descriptors);
                                        continue;
                                    }
                                    for (IdeaPluginDescriptor descriptor3 : descriptors) {
                                        if (!StringUtil.containsIgnoreCase((String)descriptor3.getName(), (String)parser.searchQuery)) continue;
                                        result2.descriptors.add(descriptor3);
                                    }
                                }
                                ContainerUtil.removeDuplicates(result2.descriptors);
                                result2.sortByName();
                                return;
                            }
                            Url url = PluginManagerConfigurableNew.createSearchUrl(parser.getUrlQuery(), 10000);
                            for (String pluginId : PluginManagerConfigurableNew.requestToPluginRepository(url)) {
                                IdeaPluginDescriptor descriptor4 = (IdeaPluginDescriptor)allRepositoriesMap.get(pluginId);
                                if (descriptor4 == null) continue;
                                result2.descriptors.add(descriptor4);
                            }
                            if (parser.searchQuery != null) {
                                String builtinUrl = ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl();
                                ArrayList builtinList = new ArrayList();
                                for (Map.Entry entry : customRepositoriesMap.entrySet()) {
                                    List<Object> descriptors = ((String)entry.getKey()).equals(builtinUrl) ? builtinList : result2.descriptors;
                                    for (IdeaPluginDescriptor descriptor5 : (List)entry.getValue()) {
                                        if (!StringUtil.containsIgnoreCase((String)descriptor5.getName(), (String)parser.searchQuery)) continue;
                                        descriptors.add(descriptor5);
                                    }
                                }
                                result2.descriptors.addAll(0, builtinList);
                            }
                            ContainerUtil.removeDuplicates(result2.descriptors);
                            if (!result2.descriptors.isEmpty()) {
                                String title = "Sort By";
                                for (AnAction action2 : PluginManagerConfigurableNewLayout.this.myMarketplaceSortByGroup.getChildren(null)) {
                                    MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                                    sortByAction.setState(parser);
                                    if (!sortByAction.myState) continue;
                                    title = "Sort By: " + sortByAction.myOption.name();
                                }
                                PluginManagerConfigurableNewLayout.this.myMarketplaceSortByAction.setText(title);
                                result2.addRightAction((JComponent)((Object)PluginManagerConfigurableNewLayout.this.myMarketplaceSortByAction));
                            }
                        }
                        catch (IOException e) {
                            PluginManagerMain.LOG.info((Throwable)e);
                            ApplicationManager.getApplication().invokeLater(() -> this.myPanel.getEmptyText().setText("Search result are not loaded.").appendSecondaryText("Check the internet connection.", StatusText.DEFAULT_ATTRIBUTES, null), ModalityState.any());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "query";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "result";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$8$5";
                        objectArray[2] = "handleQuery";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                SearchResultPanel searchResultPanel = PluginManagerConfigurableNewLayout.this.myMarketplaceSearchPanel;
                if (searchResultPanel == null) {
                    8.$$$reportNull$$$0(6);
                }
                return searchResultPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchListener";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$8";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectionListener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$8";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDetailsPanel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPluginsPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDetailsPanel";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPluginsPanel";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "updateMainSelection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createSearchPanel";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private void createInstalledTab() {
        this.myInstalledSearchGroup = new DefaultActionGroup();
        for (InstalledSearchOption option : InstalledSearchOption.values()) {
            this.myInstalledSearchGroup.add((AnAction)new InstalledSearchOptionAction(option));
        }
        this.myInstalledTab = new PluginsTab(){

            @Override
            protected void createSearchTextField(int flyDelay) {
                super.createSearchTextField(flyDelay);
                JBTextField textField2 = this.mySearchTextField.getTextEditor();
                textField2.putClientProperty((Object)"search.extension", (Object)ExtendableTextComponent.Extension.create((Icon)AllIcons.Actions.More, (Icon)AllIcons.Actions.More, (String)"Search Options", () -> PluginManagerConfigurableNewLayout.showRightBottomPopup((Component)textField2, "Show", (ActionGroup)PluginManagerConfigurableNewLayout.this.myInstalledSearchGroup)));
                textField2.putClientProperty((Object)"JTextField.variant", null);
                textField2.putClientProperty((Object)"JTextField.variant", (Object)"search");
                this.mySearchTextField.setHistoryPropertyName("InstalledPluginsSearchHistory");
            }

            @Override
            @NotNull
            protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
                if (searchListener == null) {
                    9.$$$reportNull$$$0(0);
                }
                PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(PluginManagerConfigurableNewLayout.this.myPluginModel, searchListener, false);
                PluginManagerConfigurableNewLayout.this.myPluginModel.addDetailPanel(detailPanel);
                PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
                if (pluginDetailsPageComponent == null) {
                    9.$$$reportNull$$$0(1);
                }
                return pluginDetailsPageComponent;
            }

            @Override
            @NotNull
            protected JComponent createPluginsPanel(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    9.$$$reportNull$$$0(2);
                }
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                PluginManagerConfigurableNewLayout.this.myInstalledPanel = new PluginsGroupComponent((LayoutManager)((Object)new PluginListLayout()), eventHandler, (LinkListener<IdeaPluginDescriptor>)PluginManagerConfigurableNewLayout.this.myNameListener, (LinkListener<String>)PluginManagerConfigurableNewLayout.this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor2 -> new NewListPluginComponent(PluginManagerConfigurableNewLayout.this.myPluginModel, (IdeaPluginDescriptor)descriptor2, false)));
                PluginManagerConfigurableNewLayout.this.myInstalledPanel.setSelectionListener(selectionListener);
                PluginManagerConfigurableNew.registerCopyProvider(PluginManagerConfigurableNewLayout.this.myInstalledPanel);
                ((SearchUpDownPopupController)((PluginManagerConfigurableNewLayout)PluginManagerConfigurableNewLayout.this).myInstalledSearchPanel.controller).setEventHandler(eventHandler);
                PluginLogo.startBatchMode();
                PluginsGroup installing = new PluginsGroup("Installing");
                installing.descriptors.addAll(MyPluginModel.getInstallingPlugins());
                if (!installing.descriptors.isEmpty()) {
                    installing.sortByName();
                    installing.titleWithCount();
                    PluginManagerConfigurableNewLayout.this.myInstalledPanel.addGroup(installing);
                }
                final PluginsGroup downloaded = new PluginsGroup("Downloaded");
                downloaded.descriptors.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
                PluginsGroup bundled = new PluginsGroup("Bundled");
                ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
                int bundledEnabled = 0;
                int downloadedEnabled = 0;
                boolean hideImplDetails = !Registry.is((String)"plugins.show.implementation.details");
                for (IdeaPluginDescriptor descriptor3 : PluginManagerCore.getPlugins()) {
                    if (appInfo.isEssentialPlugin(descriptor3.getPluginId().getIdString())) continue;
                    if (descriptor3.isBundled()) {
                        if (hideImplDetails && descriptor3.isImplementationDetail()) continue;
                        bundled.descriptors.add(descriptor3);
                        if (!descriptor3.isEnabled()) continue;
                        ++bundledEnabled;
                        continue;
                    }
                    downloaded.descriptors.add(descriptor3);
                    if (!descriptor3.isEnabled()) continue;
                    ++downloadedEnabled;
                }
                if (!downloaded.descriptors.isEmpty()) {
                    PluginManagerConfigurableNewLayout.this.myUpdateAll.setListener((LinkListener)new LinkListener<Object>(){

                        public void linkSelected(LinkLabel aSource, Object aLinkData) {
                            PluginManagerConfigurableNewLayout.this.myUpdateAll.setEnabled(false);
                            for (CellPluginComponent plugin : downloaded.ui.plugins) {
                                ((NewListPluginComponent)plugin).updatePlugin();
                            }
                        }
                    }, null);
                    downloaded.addRightAction((JComponent)PluginManagerConfigurableNewLayout.this.myUpdateAll);
                    downloaded.addRightAction(PluginManagerConfigurableNewLayout.this.myUpdateCounter);
                    downloaded.sortByName();
                    downloaded.titleWithCount(downloadedEnabled);
                    PluginManagerConfigurableNewLayout.this.myInstalledPanel.addGroup(downloaded);
                    PluginManagerConfigurableNewLayout.this.myPluginModel.addEnabledGroup(downloaded);
                }
                PluginManagerConfigurableNewLayout.this.myPluginModel.setDownloadedGroup(PluginManagerConfigurableNewLayout.this.myInstalledPanel, downloaded, installing);
                bundled.sortByName();
                bundled.titleWithCount(bundledEnabled);
                PluginManagerConfigurableNewLayout.this.myInstalledPanel.addGroup(bundled);
                PluginManagerConfigurableNewLayout.this.myPluginModel.addEnabledGroup(bundled);
                PluginManagerConfigurableNewLayout.this.myPluginUpdatesService.connectInstalled(updates -> {
                    if (ContainerUtil.isEmpty((Collection)updates)) {
                        PluginManagerConfigurableNewLayout.clearUpdates(PluginManagerConfigurableNewLayout.this.myInstalledPanel);
                        PluginManagerConfigurableNewLayout.clearUpdates(PluginManagerConfigurableNewLayout.this.myInstalledSearchPanel.getPanel());
                    } else {
                        PluginManagerConfigurableNewLayout.applyUpdates(PluginManagerConfigurableNewLayout.this.myInstalledPanel, updates);
                        PluginManagerConfigurableNewLayout.applyUpdates(PluginManagerConfigurableNewLayout.this.myInstalledSearchPanel.getPanel(), updates);
                    }
                    selectionListener.accept(PluginManagerConfigurableNewLayout.this.myInstalledPanel);
                });
                PluginLogo.endBatchMode();
                JComponent jComponent = PluginManagerConfigurableNewLayout.createScrollPane(PluginManagerConfigurableNewLayout.this.myInstalledPanel, true);
                if (jComponent == null) {
                    9.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            @Override
            protected void updateMainSelection(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    9.$$$reportNull$$$0(4);
                }
                selectionListener.accept(PluginManagerConfigurableNewLayout.this.myInstalledPanel);
            }

            @Override
            public void hideSearchPanel() {
                super.hideSearchPanel();
                if (PluginManagerConfigurableNewLayout.this.myInstalledSearchSetState) {
                    for (AnAction action2 : PluginManagerConfigurableNewLayout.this.myInstalledSearchGroup.getChildren(null)) {
                        ((InstalledSearchOptionAction)action2).setState(null);
                    }
                }
                PluginManagerConfigurableNewLayout.this.myPluginModel.setInvalidFixCallback(null);
            }

            @Override
            @NotNull
            protected SearchResultPanel createSearchPanel(final @NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    9.$$$reportNull$$$0(5);
                }
                SearchUpDownPopupController installedController = new SearchUpDownPopupController(this.mySearchTextField){

                    @Override
                    @NotNull
                    protected List<String> getAttributes() {
                        List<String> list2 = Arrays.asList("/downloaded", "/outdated", "/enabled", "/disabled", "/invalid", "/bundled", "/vendor:");
                        if (list2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return list2;
                    }

                    @Override
                    @Nullable
                    protected List<String> getValues(@NotNull String attribute) {
                        if (attribute == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return "/vendor:".equals(attribute) ? PluginManagerConfigurableNewLayout.this.myPluginModel.getVendors() : null;
                    }

                    @Override
                    protected void handleAppendToQuery() {
                        this.showPopupForQuery();
                    }

                    @Override
                    protected void handleAppendAttributeValue() {
                        this.showPopupForQuery();
                    }

                    @Override
                    protected void showPopupForQuery() {
                        this.showSearchPanel(mySearchTextField.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$9$2";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attribute";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAttributes";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$9$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getValues";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                installedController.setSearchResultEventHandler(eventHandler);
                PluginsGroupComponent panel2 = new PluginsGroupComponent((LayoutManager)((Object)new PluginListLayout()), eventHandler, (LinkListener<IdeaPluginDescriptor>)PluginManagerConfigurableNewLayout.this.myNameListener, (LinkListener<String>)PluginManagerConfigurableNewLayout.this.mySearchListener, (Function<? super IdeaPluginDescriptor, ? extends CellPluginComponent>)((Function)descriptor2 -> new NewListPluginComponent(PluginManagerConfigurableNewLayout.this.myPluginModel, (IdeaPluginDescriptor)descriptor2, false)));
                panel2.setSelectionListener(selectionListener);
                PluginManagerConfigurableNew.registerCopyProvider(panel2);
                PluginManagerConfigurableNewLayout.this.myInstalledSearchCallback = updateAction -> {
                    final ArrayList<String> queries = new ArrayList<String>();
                    new SearchQueryParser.InstalledWithVendor(this.mySearchTextField.getText(), (InstalledSearchOptionAction)((Object)updateAction)){
                        final /* synthetic */ InstalledSearchOptionAction val$updateAction;
                        {
                            this.val$updateAction = installedSearchOptionAction;
                            super(query);
                        }

                        @Override
                        protected void addToSearchQuery(@NotNull String query) {
                            if (query == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            super.addToSearchQuery(query);
                            queries.add(query);
                        }

                        @Override
                        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert) {
                            if (name == null) {
                                3.$$$reportNull$$$0(1);
                            }
                            if (value == null) {
                                3.$$$reportNull$$$0(2);
                            }
                            super.handleAttribute(name, value, invert);
                            if (!this.val$updateAction.myState) {
                                queries.add("/" + name + (value.isEmpty() ? "" : ":" + SearchQueryParser.wrapAttribute(value)));
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "query";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "value";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$9$3";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "addToSearchQuery";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "handleAttribute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    if (((InstalledSearchOptionAction)updateAction).myState) {
                        for (AnAction action2 : PluginManagerConfigurableNewLayout.this.myInstalledSearchGroup.getChildren(null)) {
                            if (action2 == updateAction) continue;
                            ((InstalledSearchOptionAction)action2).myState = false;
                        }
                        queries.add(updateAction.getQuery());
                    } else {
                        queries.remove(updateAction.getQuery());
                    }
                    try {
                        PluginManagerConfigurableNewLayout.this.myInstalledSearchSetState = false;
                        String query = StringUtil.join(queries, (String)" ");
                        this.mySearchTextField.setTextIgnoreEvents(query);
                        if (query.isEmpty()) {
                            PluginManagerConfigurableNewLayout.this.myInstalledTab.hideSearchPanel();
                        } else {
                            PluginManagerConfigurableNewLayout.this.myInstalledTab.showSearchPanel(query);
                        }
                    }
                    finally {
                        PluginManagerConfigurableNewLayout.this.myInstalledSearchSetState = true;
                    }
                };
                PluginManagerConfigurableNewLayout.this.myInstalledSearchPanel = new SearchResultPanel(installedController, panel2, 0, 0){

                    @Override
                    protected void setEmptyText() {
                        this.myPanel.getEmptyText().setText("Nothing found.");
                        this.myPanel.getEmptyText().appendSecondaryText("Search in marketplace", SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> PluginManagerConfigurableNewLayout.this.myTabHeaderComponent.setSelectionWithEvents(0));
                    }

                    @Override
                    protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                        block10: {
                            SearchQueryParser.InstalledWithVendor parser;
                            block9: {
                                Collection<PluginDownloader> updates;
                                if (query == null) {
                                    4.$$$reportNull$$$0(0);
                                }
                                if (result2 == null) {
                                    4.$$$reportNull$$$0(1);
                                }
                                PluginManagerConfigurableNewLayout.this.myPluginModel.setInvalidFixCallback(null);
                                parser = new SearchQueryParser.InstalledWithVendor(query);
                                if (PluginManagerConfigurableNewLayout.this.myInstalledSearchSetState) {
                                    for (AnAction action2 : PluginManagerConfigurableNewLayout.this.myInstalledSearchGroup.getChildren(null)) {
                                        ((InstalledSearchOptionAction)action2).setState(parser);
                                    }
                                }
                                if (!parser.vendors.isEmpty()) break block9;
                                for (UIPluginGroup uiGroup : PluginManagerConfigurableNewLayout.this.myInstalledPanel.getGroups()) {
                                    for (CellPluginComponent plugin : uiGroup.plugins) {
                                        if (parser.attributes && (parser.enabled && !PluginManagerConfigurableNewLayout.this.myPluginModel.isEnabled(plugin.myPlugin) || parser.disabled && PluginManagerConfigurableNewLayout.this.myPluginModel.isEnabled(plugin.myPlugin) || parser.bundled && !plugin.myPlugin.isBundled() || parser.downloaded && plugin.myPlugin.isBundled() || parser.invalid && !PluginManagerConfigurableNewLayout.this.myPluginModel.hasErrors(plugin.myPlugin) || parser.needUpdate && !PluginUpdatesService.isNeedUpdate(plugin.myPlugin)) || parser.searchQuery != null && !StringUtil.containsIgnoreCase((String)plugin.myPlugin.getName(), (String)parser.searchQuery)) continue;
                                        result2.descriptors.add(plugin.myPlugin);
                                    }
                                }
                                if (result2.descriptors.isEmpty()) break block10;
                                if (parser.invalid) {
                                    PluginManagerConfigurableNewLayout.this.myPluginModel.setInvalidFixCallback(() -> {
                                        PluginsGroup group = PluginManagerConfigurableNewLayout.this.myInstalledSearchPanel.getGroup();
                                        if (group.ui == null) {
                                            PluginManagerConfigurableNewLayout.this.myPluginModel.setInvalidFixCallback(null);
                                            return;
                                        }
                                        PluginsGroupComponent resultPanel = PluginManagerConfigurableNewLayout.this.myInstalledSearchPanel.getPanel();
                                        for (IdeaPluginDescriptor descriptor2 : new ArrayList<IdeaPluginDescriptor>(group.descriptors)) {
                                            if (PluginManagerConfigurableNewLayout.this.myPluginModel.hasErrors(descriptor2)) continue;
                                            resultPanel.removeFromGroup(group, descriptor2);
                                        }
                                        group.titleWithCount();
                                        PluginManagerConfigurableNewLayout.this.myInstalledSearchPanel.fullRepaint();
                                        if (group.descriptors.isEmpty()) {
                                            PluginManagerConfigurableNewLayout.this.myPluginModel.setInvalidFixCallback(null);
                                        }
                                    });
                                }
                                if (ContainerUtil.isEmpty(updates = PluginUpdatesService.getUpdates())) break block10;
                                this.myPostFillGroupCallback = () -> {
                                    PluginManagerConfigurableNewLayout.applyUpdates(this.myPanel, updates);
                                    selectionListener.accept(PluginManagerConfigurableNewLayout.this.myInstalledPanel);
                                };
                                break block10;
                            }
                            for (UIPluginGroup uiGroup : PluginManagerConfigurableNewLayout.this.myInstalledPanel.getGroups()) {
                                for (CellPluginComponent plugin : uiGroup.plugins) {
                                    if (!MyPluginModel.isVendor(plugin.myPlugin, parser.vendors)) continue;
                                    result2.descriptors.add(plugin.myPlugin);
                                }
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "query";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "result";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$9$4";
                        objectArray[2] = "handleQuery";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                SearchResultPanel searchResultPanel = PluginManagerConfigurableNewLayout.this.myInstalledSearchPanel;
                if (searchResultPanel == null) {
                    9.$$$reportNull$$$0(6);
                }
                return searchResultPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchListener";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$9";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectionListener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$9";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDetailsPanel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPluginsPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDetailsPanel";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPluginsPanel";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "updateMainSelection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createSearchPanel";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void clearUpdates(@NotNull PluginsGroupComponent panel2) {
        if (panel2 == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(7);
        }
        for (UIPluginGroup group : panel2.getGroups()) {
            for (CellPluginComponent plugin : group.plugins) {
                ((NewListPluginComponent)plugin).setUpdateDescriptor(null);
            }
        }
    }

    private static void applyUpdates(@NotNull PluginsGroupComponent panel2, @NotNull Collection<? extends PluginDownloader> updates) {
        if (panel2 == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(8);
        }
        if (updates == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(9);
        }
        block0: for (PluginDownloader pluginDownloader : updates) {
            IdeaPluginDescriptor descriptor2 = pluginDownloader.getDescriptor();
            for (UIPluginGroup group : panel2.getGroups()) {
                CellPluginComponent component = group.findComponent(descriptor2);
                if (component == null) continue;
                ((NewListPluginComponent)component).setUpdateDescriptor(descriptor2);
                continue block0;
            }
        }
    }

    @NotNull
    private static JComponent createScrollPane(@NotNull PluginsGroupComponent panel2, boolean initSelection) {
        if (panel2 == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(10);
        }
        JBScrollPane pane2 = new JBScrollPane((Component)((Object)panel2), 20, 31);
        pane2.setBorder((Border)JBUI.Borders.empty());
        if (initSelection) {
            panel2.initialSelection();
        }
        JBScrollPane jBScrollPane = pane2;
        if (jBScrollPane == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(11);
        }
        return jBScrollPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<IdeaPluginDescriptor> getPluginRepositories() {
        block9: {
            List<IdeaPluginDescriptor> list2;
            Object object = this.myRepositoriesLock;
            synchronized (object) {
                if (this.myAllRepositoriesList != null) {
                    List<IdeaPluginDescriptor> list3 = this.myAllRepositoriesList;
                    // MONITOREXIT @DISABLED, blocks:[3, 8] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (list3 == null) {
                        PluginManagerConfigurableNewLayout.$$$reportNull$$$0(12);
                    }
                    return list3;
                }
            }
            try {
                List<IdeaPluginDescriptor> list4 = RepositoryHelper.loadCachedPlugins();
                if (list4 == null) break block9;
                list2 = list4;
            }
            catch (IOException e) {
                PluginManagerMain.LOG.info((Throwable)e);
                break block9;
            }
            if (list2 == null) {
                PluginManagerConfigurableNewLayout.$$$reportNull$$$0(13);
            }
            return list2;
        }
        List<IdeaPluginDescriptor> list5 = Collections.emptyList();
        if (list5 == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(14);
        }
        return list5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Pair<Map<String, IdeaPluginDescriptor>, Map<String, List<IdeaPluginDescriptor>>> loadPluginRepositories() {
        Object object = this.myRepositoriesLock;
        // MONITORENTER : object
        if (this.myAllRepositoriesMap != null) {
            Pair pair = Pair.create(this.myAllRepositoriesMap, this.myCustomRepositoriesMap);
            // MONITOREXIT : object
            if (pair != null) return pair;
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(15);
            return pair;
        }
        // MONITOREXIT : object
        ArrayList<IdeaPluginDescriptor> list2 = new ArrayList<IdeaPluginDescriptor>();
        HashMap<String, IdeaPluginDescriptor> map2 = new HashMap<String, IdeaPluginDescriptor>();
        HashMap<String, List<IdeaPluginDescriptor>> custom = new HashMap<String, List<IdeaPluginDescriptor>>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(host, null);
                if (host != null) {
                    custom.put(host, descriptors);
                }
                for (IdeaPluginDescriptor plugin : descriptors) {
                    String id = plugin.getPluginId().getIdString();
                    if (map2.containsKey(id)) continue;
                    list2.add(plugin);
                    map2.put(id, plugin);
                }
            }
            catch (IOException e) {
                if (host == null) {
                    PluginManagerMain.LOG.info("Main plugin repository is not available ('" + e.getMessage() + "'). Please check your network settings.");
                    continue;
                }
                PluginManagerMain.LOG.info(host, (Throwable)e);
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            InstalledPluginsState state = InstalledPluginsState.getInstance();
            for (IdeaPluginDescriptor descriptor2 : list2) {
                state.onDescriptorDownload(descriptor2);
            }
        });
        Object object2 = this.myRepositoriesLock;
        // MONITORENTER : object2
        if (this.myAllRepositoriesList == null) {
            this.myAllRepositoriesList = list2;
            this.myAllRepositoriesMap = map2;
            this.myCustomRepositoriesMap = custom;
        }
        Pair pair = Pair.create(this.myAllRepositoriesMap, this.myCustomRepositoriesMap);
        // MONITOREXIT : object2
        if (pair != null) return pair;
        PluginManagerConfigurableNewLayout.$$$reportNull$$$0(16);
        return pair;
    }

    private void addGroup(@NotNull List<? super PluginsGroup> groups, @NotNull String name, @NotNull String showAllQuery, @NotNull ThrowableNotNullFunction<? super List<IdeaPluginDescriptor>, Boolean, ? extends IOException> function) throws IOException {
        if (groups == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(17);
        }
        if (name == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(18);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(19);
        }
        if (function == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(20);
        }
        PluginsGroup group = new PluginsGroup(name);
        if (Boolean.TRUE.equals(function.fun(group.descriptors))) {
            group.rightAction = new LinkLabel("Show All", null, this.myMarketplaceTab.mySearchListener, (Object)showAllQuery);
            group.rightAction.setBorder((Border)JBUI.Borders.emptyRight((int)5));
        }
        if (!group.descriptors.isEmpty()) {
            groups.add(group);
        }
    }

    private void addGroup(@NotNull List<? super PluginsGroup> groups, @NotNull Map<String, IdeaPluginDescriptor> allRepositoriesMap, @NotNull String name, @NotNull String query, @NotNull String showAllQuery) throws IOException {
        if (groups == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(21);
        }
        if (allRepositoriesMap == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(22);
        }
        if (name == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(23);
        }
        if (query == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(24);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(25);
        }
        this.addGroup(groups, name, showAllQuery, (ThrowableNotNullFunction<? super List<IdeaPluginDescriptor>, Boolean, ? extends IOException>)((ThrowableNotNullFunction)descriptors -> PluginManagerConfigurableNew.loadPlugins(descriptors, allRepositoriesMap, query)));
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.pluginManager" == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(26);
        }
        return "preferences.pluginManager";
    }

    public void disposeUIResources() {
        this.myPluginModel.toBackground();
        this.myMarketplaceTab.dispose();
        this.myInstalledTab.dispose();
        if (this.myMarketplacePanel != null) {
            this.myMarketplacePanel.dispose();
        }
        if (this.myMarketplaceSearchPanel != null) {
            this.myMarketplaceSearchPanel.dispose();
        }
        this.myPluginUpdatesService.dispose();
        if (this.myShutdownCallback != null) {
            this.myShutdownCallback.run();
            this.myShutdownCallback = null;
        }
    }

    public boolean isModified() {
        if (this.myPluginModel.needRestart) {
            return true;
        }
        int rowCount = this.myPluginModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IdeaPluginDescriptor descriptor2 = this.myPluginModel.getObjectAt(i);
            boolean enabledInTable = this.myPluginModel.isEnabled(descriptor2);
            if (descriptor2.isEnabled() == enabledInTable || enabledInTable && !PluginManagerCore.isDisabled(descriptor2.getPluginId().getIdString())) continue;
            return true;
        }
        for (Map.Entry<PluginId, Boolean> entry : this.myPluginModel.getEnabledMap().entrySet()) {
            Boolean enabled = entry.getValue();
            if (enabled == null || enabled.booleanValue() || PluginManagerCore.isDisabled(entry.getKey().getIdString())) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        Map<PluginId, Boolean> enabledMap = this.myPluginModel.getEnabledMap();
        ArrayList<String> dependencies = new ArrayList<String>();
        block2: for (Map.Entry<PluginId, Set<PluginId>> entry : this.myPluginModel.getDependentToRequiredListMap().entrySet()) {
            PluginId id = entry.getKey();
            if (enabledMap.get(id) == null) continue;
            for (PluginId dependId : entry.getValue()) {
                if (PluginManagerCore.isModuleDependency(dependId)) continue;
                IdeaPluginDescriptor descriptor2 = PluginManager.getPlugin(id);
                if (descriptor2 instanceof IdeaPluginDescriptorImpl && (((IdeaPluginDescriptorImpl)descriptor2).isDeleted() || descriptor2.isImplementationDetail())) continue block2;
                dependencies.add("\"" + (descriptor2 == null ? id.getIdString() : descriptor2.getName()) + "\"");
                continue block2;
            }
        }
        if (!dependencies.isEmpty()) {
            throw new ConfigurationException("<html><body style=\"padding: 5px;\">Unable to apply changes: plugin" + (dependencies.size() == 1 ? " " : "s ") + StringUtil.join(dependencies, (String)", ") + " won't be able to load.</body></html>");
        }
        int rowCount = this.myPluginModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IdeaPluginDescriptor descriptor3 = this.myPluginModel.getObjectAt(i);
            descriptor3.setEnabled(this.myPluginModel.isEnabled(descriptor3.getPluginId()));
        }
        ArrayList<String> disableIds = new ArrayList<String>();
        for (Map.Entry entry : enabledMap.entrySet()) {
            Boolean enabled = (Boolean)entry.getValue();
            if (enabled == null || enabled.booleanValue()) continue;
            disableIds.add(((PluginId)entry.getKey()).getIdString());
        }
        try {
            PluginManagerCore.saveDisabledPlugins(disableIds, false);
        }
        catch (IOException e) {
            PluginManagerMain.LOG.error((Throwable)e);
        }
        if (this.myShutdownCallback == null && this.myPluginModel.createShutdownCallback) {
            this.myShutdownCallback = () -> ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0])));
        }
    }

    @Override
    @NotNull
    public MyPluginModel getPluginModel() {
        MyPluginModel myPluginModel = this.myPluginModel;
        if (myPluginModel == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(27);
        }
        return myPluginModel;
    }

    @Override
    public void select(IdeaPluginDescriptor ... descriptors) {
        if (descriptors == null) {
            PluginManagerConfigurableNewLayout.$$$reportNull$$$0(28);
        }
        if (this.myTabHeaderComponent.getSelectionTab() != 1) {
            this.myTabHeaderComponent.setSelectionWithEvents(1);
        }
        if (descriptors.length == 0) {
            return;
        }
        ArrayList<CellPluginComponent> components = new ArrayList<CellPluginComponent>();
        block0: for (IdeaPluginDescriptor descriptor2 : descriptors) {
            for (UIPluginGroup group : this.myInstalledPanel.getGroups()) {
                CellPluginComponent component = group.findComponent(descriptor2);
                if (component == null) continue;
                components.add(component);
                continue block0;
            }
        }
        if (!components.isEmpty()) {
            this.myInstalledPanel.setSelection(components);
        }
    }

    @Nullable
    public Runnable enableSearch(String option) {
        if (StringUtil.isEmpty((String)option) && (this.myTabHeaderComponent.getSelectionTab() == 0 ? this.myMarketplaceSearchPanel : this.myInstalledSearchPanel).isEmpty()) {
            return null;
        }
        return () -> {
            if (this.myTabHeaderComponent.getSelectionTab() != 1) {
                this.myTabHeaderComponent.setSelectionWithEvents(1);
            }
            this.myInstalledTab.clearSearchPanel(option);
            if (!StringUtil.isEmpty((String)option)) {
                this.myInstalledTab.showSearchPanel(option);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllQuery";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositoriesMap";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createGearActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginRepositories";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPluginRepositories";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCenterComponent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showRightBottomPopup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearUpdates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyUpdates";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ChangePluginStateAction
    extends AnAction {
        private final boolean myEnable;

        private ChangePluginStateAction(boolean enable) {
            super(enable ? "Enable All Downloaded Plugins" : "Disable All Downloaded Plugins");
            this.myEnable = enable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            IdeaPluginDescriptor[] descriptors;
            PluginsGroup group;
            if (e == null) {
                ChangePluginStateAction.$$$reportNull$$$0(0);
            }
            if ((group = PluginManagerConfigurableNewLayout.this.myPluginModel.getDownloadedGroup()) == null || group.ui == null) {
                ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
                ArrayList<IdeaPluginDescriptor> descriptorList = new ArrayList<IdeaPluginDescriptor>();
                for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                    if (appInfo.isEssentialPlugin(descriptor2.getPluginId().getIdString()) || descriptor2.isBundled() || descriptor2.isEnabled() == this.myEnable) continue;
                    descriptorList.add(descriptor2);
                }
                descriptors = descriptorList.toArray(new IdeaPluginDescriptor[0]);
            } else {
                descriptors = (IdeaPluginDescriptor[])group.ui.plugins.stream().filter(component -> PluginManagerConfigurableNewLayout.this.myPluginModel.isEnabled(component.myPlugin) != this.myEnable).map(component -> component.myPlugin).toArray(IdeaPluginDescriptor[]::new);
            }
            if (descriptors.length > 0) {
                PluginManagerConfigurableNewLayout.this.myPluginModel.changeEnableDisable(descriptors, this.myEnable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$ChangePluginStateAction", "actionPerformed"));
        }
    }

    private static class GroupByActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        private GroupByActionGroup() {
        }
    }

    private class InstalledSearchOptionAction
    extends ToggleAction {
        private final InstalledSearchOption myOption;
        private boolean myState;

        private InstalledSearchOptionAction(InstalledSearchOption option) {
            if (option == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(0);
            }
            super(option == InstalledSearchOption.NeedUpdate ? "Update available" : option.name());
            this.myOption = option;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(1);
            }
            return this.myState;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(2);
            }
            this.myState = state;
            PluginManagerConfigurableNewLayout.this.myInstalledSearchCallback.accept(this);
        }

        public void setState(@Nullable SearchQueryParser.InstalledWithVendor parser) {
            if (parser == null) {
                this.myState = false;
                return;
            }
            switch (this.myOption) {
                case Enabled: {
                    this.myState = parser.enabled;
                    break;
                }
                case Disabled: {
                    this.myState = parser.disabled;
                    break;
                }
                case Downloaded: {
                    this.myState = parser.downloaded;
                    break;
                }
                case Bundled: {
                    this.myState = parser.bundled;
                    break;
                }
                case Invalid: {
                    this.myState = parser.invalid;
                    break;
                }
                case NeedUpdate: {
                    this.myState = parser.needUpdate;
                }
            }
        }

        @NotNull
        public String getQuery() {
            String string = this.myOption == InstalledSearchOption.NeedUpdate ? "/outdated" : "/" + StringUtil.decapitalize((String)this.myOption.name());
            if (string == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$InstalledSearchOptionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$InstalledSearchOptionAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum InstalledSearchOption {
        Downloaded,
        NeedUpdate,
        Enabled,
        Disabled,
        Invalid,
        Bundled;

    }

    private class MarketplaceSortByAction
    extends ToggleAction {
        private final SortBySearchOption myOption;
        private boolean myState;

        private MarketplaceSortByAction(SortBySearchOption option) {
            if (option == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(0);
            }
            super(option.name());
            this.myOption = option;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(1);
            }
            return this.myState;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(2);
            }
            this.myState = state;
            PluginManagerConfigurableNewLayout.this.myMarketplaceSortByCallback.accept(this);
        }

        public void setState(@NotNull SearchQueryParser.Marketplace parser) {
            if (parser == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(3);
            }
            if (this.myOption == SortBySearchOption.Relevance) {
                this.myState = parser.sortBy == null;
                this.getTemplatePresentation().setVisible(parser.sortBy == null || !parser.tags.isEmpty() || parser.searchQuery != null);
            } else {
                this.myState = parser.sortBy != null && this.myOption.name().equalsIgnoreCase(parser.sortBy);
            }
        }

        @Nullable
        public String getQuery() {
            switch (this.myOption) {
                case Downloads: {
                    return "/sortBy:downloads";
                }
                case Name: {
                    return "/sortBy:name";
                }
                case Rating: {
                    return "/sortBy:rating";
                }
                case Updated: {
                    return "/sortBy:updated";
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNewLayout$MarketplaceSortByAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum SortBySearchOption {
        Downloads,
        Name,
        Rating,
        Relevance,
        Updated;

    }
}

