/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferenceUtil {
    static void highlight(Editor editor, Project project, List<? extends PsiElement> elements2) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (elements2.size() == 1 && editor != null && project != null) {
            PsiElement element = elements2.get(0);
            PsiElement nameIdentifier = IdentifierUtil.getNameIdentifier(element);
            if (nameIdentifier != null) {
                highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{nameIdentifier}, attributes, true, null);
            } else {
                PsiReference reference2 = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
                if (reference2 != null) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiReference[]{reference2}, attributes, true, null);
                } else if (element != PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(editor.getDocument())) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{element}, attributes, true, null);
                }
            }
        }
    }

    @NotNull
    static List<PsiElement> getElementsToCopy(@Nullable Editor editor, DataContext dataContext) {
        PsiElement[] psiElements;
        PsiReference reference2;
        ArrayList elements2 = new ArrayList();
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor)) != null) {
            ContainerUtil.addIfNotNull(elements2, (Object)reference2.getElement());
        }
        if (elements2.isEmpty() && (psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)) != null) {
            Collections.addAll(elements2, psiElements);
        }
        if (elements2.isEmpty()) {
            ContainerUtil.addIfNotNull(elements2, (Object)CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        }
        if (elements2.isEmpty() && editor == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            if (project != null && files2 != null) {
                for (VirtualFile file2 : files2) {
                    ContainerUtil.addIfNotNull(elements2, (Object)PsiManager.getInstance((Project)project).findFile(file2));
                }
            }
        }
        List list2 = ContainerUtil.mapNotNull(elements2, element -> element instanceof PsiFile && !((PsiFile)element).getViewProvider().isPhysical() ? null : CopyReferenceUtil.adjustElement(element));
        if (list2 == null) {
            CopyReferenceUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    static PsiElement adjustElement(PsiElement element) {
        PsiElement adjustedElement = QualifiedNameProviderUtil.adjustElementToCopy(element);
        return adjustedElement != null ? adjustedElement : element;
    }

    static void setStatusBarText(Project project, String message) {
        StatusBarEx statusBar;
        if (project != null && (statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar.setInfo(message);
        }
    }

    @Nullable
    static String getQualifiedNameFromProviders(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        DumbService.getInstance((Project)element.getProject()).setAlternativeResolveEnabled(true);
        try {
            String string = QualifiedNameProviderUtil.getQualifiedName(element);
            return string;
        }
        finally {
            DumbService.getInstance((Project)element.getProject()).setAlternativeResolveEnabled(false);
        }
    }

    static String doCopy(List<? extends PsiElement> elements2, @Nullable Editor editor) {
        if (elements2.isEmpty()) {
            return null;
        }
        ArrayList<String> fqns = new ArrayList<String>();
        for (PsiElement psiElement : elements2) {
            String fqn = CopyReferenceUtil.elementToFqn(psiElement, editor);
            if (fqn == null) {
                return null;
            }
            fqns.add(fqn);
        }
        return StringUtil.join(fqns, (String)"\n");
    }

    @Nullable
    static String elementToFqn(@Nullable PsiElement element, @Nullable Editor editor) {
        PsiReference reference2;
        String result2 = CopyReferenceUtil.getQualifiedNameFromProviders(element);
        if (result2 != null) {
            return result2;
        }
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset())) != null && (result2 = CopyReferenceUtil.getQualifiedNameFromProviders(reference2.resolve())) != null) {
            return result2;
        }
        if (element instanceof PsiFile) {
            return FileUtil.toSystemIndependentName((String)CopyReferenceUtil.getFileFqn((PsiFile)element));
        }
        if (element instanceof PsiDirectory) {
            return FileUtil.toSystemIndependentName((String)CopyReferenceUtil.getVirtualFileFqn(((PsiDirectory)element).getVirtualFile(), element.getProject()));
        }
        return null;
    }

    @NotNull
    static String getFileFqn(PsiFile file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        String string = virtualFile == null ? file2.getName() : CopyReferenceUtil.getVirtualFileFqn(virtualFile, file2.getProject());
        if (string == null) {
            CopyReferenceUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String getVirtualFileFqn(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        String scratchRelativePath;
        VirtualFile scratchRootVirtualFile;
        String relativePath;
        if (virtualFile == null) {
            CopyReferenceUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CopyReferenceUtil.$$$reportNull$$$0(3);
        }
        for (VirtualFile[] provider : CopyReferenceAction.VirtualFileQualifiedNameProvider.EP_NAME.getExtensionList()) {
            String qualifiedName = provider.getQualifiedName(project, virtualFile);
            if (qualifiedName == null) continue;
            String string = qualifiedName;
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(virtualFile, false);
        if (module != null) {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                String relativePath2 = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)root);
                if (relativePath2 == null) continue;
                String string = relativePath2;
                if (string == null) {
                    CopyReferenceUtil.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        if ((relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)project.getBaseDir())) != null) {
            String string = relativePath;
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        RootType rootType = RootType.forFile((VirtualFile)virtualFile);
        if (rootType != null && (scratchRootVirtualFile = VfsUtil.findFileByIoFile((File)new File(ScratchFileService.getInstance().getRootPath(rootType)), (boolean)false)) != null && (scratchRelativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)scratchRootVirtualFile)) != null) {
            String string = scratchRelativePath;
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = virtualFile.getPath();
        if (string == null) {
            CopyReferenceUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CopyReferenceUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileFqn";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CopyReferenceUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFileFqn";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFileFqn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

