/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.WeighingDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class AsyncCompletion
extends CompletionThreadingBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.AsyncCompletion");
    private final ArrayList<CompletionResult> myBatchList = new ArrayList();
    private final LinkedBlockingQueue<Computable<Boolean>> myQueue = new LinkedBlockingQueue();

    AsyncCompletion() {
    }

    @Override
    public Future<?> startThread(ProgressIndicator progressIndicator, Runnable runnable2) {
        Semaphore startSemaphore = new Semaphore();
        startSemaphore.down();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
            try {
                startSemaphore.up();
                ProgressManager.checkCanceled();
                runnable2.run();
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }, progressIndicator));
        startSemaphore.waitFor();
        return future2;
    }

    @Override
    public WeighingDelegate delegateWeighing(final CompletionProgressIndicator indicator) {
        class WeighItems
        implements Runnable {
            WeighItems() {
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        Computable next;
                        if ((next = (Computable)AsyncCompletion.this.myQueue.poll(30L, TimeUnit.MILLISECONDS)) != null && !((Boolean)next.compute()).booleanValue()) {
                            AsyncCompletion.tryReadOrCancel(indicator, () -> indicator.addDelayedMiddleMatches());
                            return;
                        }
                        indicator.checkCanceled();
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                    return;
                }
            }
        }
        final Future<?> future2 = this.startThread(ProgressWrapper.wrap(indicator), new WeighItems());
        return new WeighingDelegate(){

            @Override
            public void waitFor() {
                AsyncCompletion.this.myQueue.offer(new Computable.PredefinedValueComputable((Object)false));
                try {
                    future2.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            }

            public void consume(CompletionResult result2) {
                if (CompletionThreadingBase.ourIsInBatchUpdate.get().booleanValue()) {
                    AsyncCompletion.this.myBatchList.add(result2);
                } else {
                    AsyncCompletion.this.myQueue.offer(() -> {
                        AsyncCompletion.tryReadOrCancel(indicator, () -> indicator.addItem(result2));
                        return true;
                    });
                }
            }
        };
    }

    @Override
    protected void flushBatchResult(CompletionProgressIndicator indicator) {
        ArrayList<CompletionResult> batchListCopy = new ArrayList<CompletionResult>(this.myBatchList);
        this.myBatchList.clear();
        this.myQueue.offer((Computable<Boolean>)((Computable)() -> {
            AsyncCompletion.tryReadOrCancel(indicator, () -> indicator.withSingleUpdate(() -> {
                for (CompletionResult result2 : batchListCopy) {
                    indicator.addItem(result2);
                }
            }));
            return true;
        }));
    }

    static void tryReadOrCancel(ProgressIndicator indicator, Runnable runnable2) {
        if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
            indicator.checkCanceled();
            runnable2.run();
        })) {
            indicator.cancel();
            indicator.checkCanceled();
        }
    }
}

