/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrackerProperties {
    private static String PROPERTIES_FILENAME = "xgboost-tracker.properties";
    private static String HOST_IP = "host-ip";
    private static final Log logger = LogFactory.getLog(TrackerProperties.class);
    private static TrackerProperties instance = new TrackerProperties();
    private Properties properties = new Properties();

    private TrackerProperties() {
        InputStream inputStream = null;
        try {
            URL propertiesFileURL = Thread.currentThread().getContextClassLoader().getResource(PROPERTIES_FILENAME);
            if (propertiesFileURL != null) {
                inputStream = propertiesFileURL.openStream();
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Could not load " + PROPERTIES_FILENAME + " file. "), (Throwable)e);
        }
        if (inputStream != null) {
            try {
                this.properties.load(inputStream);
                logger.debug((Object)"Loaded properties from external source");
            }
            catch (IOException e) {
                logger.error((Object)"Error loading tracker properties file. Skipping and using defaults. ", (Throwable)e);
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static TrackerProperties getInstance() {
        return instance;
    }

    public String getHostIp() {
        return this.properties.getProperty(HOST_IP);
    }
}

