/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface CachedValueProvider<T> {
    @Nullable
    public Result<T> compute();

    public static class Result<T> {
        private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.CachedValueProvider.Result");
        private final T myValue;
        private final Object[] myDependencyItems;

        public Result(@Nullable T value2, Object ... dependencyItems) {
            if (dependencyItems == null) {
                Result.$$$reportNull$$$0(0);
            }
            this.myValue = value2;
            this.myDependencyItems = dependencyItems;
            if (dependencyItems.length == 0) {
                LOG.error("No dependencies provided which causes CachedValue to be never recalculated again. If this is intentional, please use ModificationTracker.NEVER_CHANGED");
            }
            for (int i = 0; i < dependencyItems.length; ++i) {
                if (dependencyItems[i] != null) continue;
                LOG.error("Null dependencies are not allowed, index=" + i);
            }
            if (CachedValueProfiler.canProfile()) {
                CachedValueProfiler.getInstance().createInfo(this);
            }
        }

        public T getValue() {
            return this.myValue;
        }

        @NotNull
        public Object[] getDependencyItems() {
            if (this.myDependencyItems == null) {
                Result.$$$reportNull$$$0(1);
            }
            return this.myDependencyItems;
        }

        @NotNull
        public static <T> Result<T> createSingleDependency(@Nullable T value2, @NotNull Object dependency) {
            if (dependency == null) {
                Result.$$$reportNull$$$0(2);
            }
            Result<T> result2 = Result.create(value2, dependency);
            if (result2 == null) {
                Result.$$$reportNull$$$0(3);
            }
            return result2;
        }

        @NotNull
        public static <T> Result<T> create(@Nullable T value2, Object ... dependencies2) {
            if (dependencies2 == null) {
                Result.$$$reportNull$$$0(4);
            }
            Result<T> result2 = new Result<T>(value2, dependencies2);
            if (result2 == null) {
                Result.$$$reportNull$$$0(5);
            }
            return result2;
        }

        @NotNull
        public static <T> Result<T> create(@Nullable T value2, @NotNull Collection<?> dependencies2) {
            if (dependencies2 == null) {
                Result.$$$reportNull$$$0(6);
            }
            Result<T> result2 = new Result<T>(value2, ArrayUtil.toObjectArray(dependencies2));
            if (result2 == null) {
                Result.$$$reportNull$$$0(7);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyItems";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/util/CachedValueProvider$Result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/util/CachedValueProvider$Result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencyItems";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSingleDependency";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createSingleDependency";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

