/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class JMapViewer
extends JPanel
implements TileLoaderListener {
    private static final long serialVersionUID = 1L;
    protected static final Point[] move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    public static final int MAX_ZOOM = 22;
    public static final int MIN_ZOOM = 0;
    protected List<MapMarker> mapMarkerList;
    protected List<MapRectangle> mapRectangleList;
    protected List<MapPolygon> mapPolygonList;
    protected boolean mapMarkersVisible;
    protected boolean mapRectanglesVisible;
    protected boolean mapPolygonsVisible;
    protected boolean tileGridVisible;
    protected boolean scrollWrapEnabled;
    protected TileController tileController;
    protected Point center;
    protected int zoom;
    protected JSlider zoomSlider;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected ZOOM_BUTTON_STYLE zoomButtonStyle;
    private TileSource tileSource;
    protected AttributionSupport attribution = new AttributionSupport();
    protected EventListenerList listenerList = new EventListenerList();

    public JMapViewer() {
        this(new MemoryTileCache(), 8);
        new DefaultMapController(this);
    }

    public JMapViewer(TileCache tileCache, int downloadThreadCount) {
        JobDispatcher.setMaxWorkers(downloadThreadCount);
        this.tileSource = new OsmTileSource.Mapnik();
        this.tileController = new TileController(this.tileSource, tileCache, this);
        this.mapMarkerList = new LinkedList<MapMarker>();
        this.mapPolygonList = new LinkedList<MapPolygon>();
        this.mapRectangleList = new LinkedList<MapRectangle>();
        this.mapMarkersVisible = true;
        this.mapRectanglesVisible = true;
        this.mapPolygonsVisible = true;
        this.tileGridVisible = false;
        this.setLayout(null);
        this.initializeZoomSlider();
        this.setMinimumSize(new Dimension(this.tileSource.getTileSize(), this.tileSource.getTileSize()));
        this.setPreferredSize(new Dimension(400, 400));
        this.setDisplayPositionByLatLon(50.0, 9.0, 3);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return super.getToolTipText(event);
    }

    protected void initializeZoomSlider() {
        ImageIcon icon;
        this.zoomSlider = new JSlider(0, this.tileController.getTileSource().getMaxZoom());
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(10, 10, 30, 150);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JMapViewer.this.setZoom(JMapViewer.this.zoomSlider.getValue());
            }
        });
        this.zoomSlider.setFocusable(false);
        this.add(this.zoomSlider);
        int size = 18;
        try {
            icon = new ImageIcon(JMapViewer.class.getResource("images/plus.png"));
            this.zoomInButton = new JButton(icon);
        }
        catch (Exception e) {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("sansserif", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setBounds(4, 155, size, size);
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMapViewer.this.zoomIn();
            }
        });
        this.zoomInButton.setFocusable(false);
        this.add(this.zoomInButton);
        try {
            icon = new ImageIcon(JMapViewer.class.getResource("images/minus.png"));
            this.zoomOutButton = new JButton(icon);
        }
        catch (Exception e) {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("sansserif", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setBounds(8 + size, 155, size, size);
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMapViewer.this.zoomOut();
            }
        });
        this.zoomOutButton.setFocusable(false);
        this.add(this.zoomOutButton);
    }

    public void setDisplayPositionByLatLon(double lat, double lon, int zoom) {
        this.setDisplayPositionByLatLon(new Point(this.getWidth() / 2, this.getHeight() / 2), lat, lon, zoom);
    }

    public void setDisplayPositionByLatLon(Point mapPoint, double lat, double lon, int zoom) {
        int x = OsmMercator.LonToX(lon, zoom);
        int y = OsmMercator.LatToY(lat, zoom);
        this.setDisplayPosition(mapPoint, x, y, zoom);
    }

    public void setDisplayPosition(int x, int y, int zoom) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), x, y, zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point mapPoint, int x, int y, int zoom) {
        if (zoom > this.tileController.getTileSource().getMaxZoom() || zoom < 0) {
            return;
        }
        Point p = new Point();
        p.x = x - mapPoint.x + this.getWidth() / 2;
        p.y = y - mapPoint.y + this.getHeight() / 2;
        this.center = p;
        this.setIgnoreRepaint(true);
        try {
            int oldZoom = this.zoom;
            this.zoom = zoom;
            if (oldZoom != zoom) {
                this.zoomChanged(oldZoom);
            }
            if (this.zoomSlider.getValue() != zoom) {
                this.zoomSlider.setValue(zoom);
            }
        }
        finally {
            this.setIgnoreRepaint(false);
            this.repaint();
        }
    }

    public void setDisplayToFitMapElements(boolean markers, boolean rectangles, boolean polygons) {
        int y;
        int nbElemToCheck = 0;
        if (markers && this.mapMarkerList != null) {
            nbElemToCheck += this.mapMarkerList.size();
        }
        if (rectangles && this.mapRectangleList != null) {
            nbElemToCheck += this.mapRectangleList.size();
        }
        if (polygons && this.mapPolygonList != null) {
            nbElemToCheck += this.mapPolygonList.size();
        }
        if (nbElemToCheck == 0) {
            return;
        }
        int x_min = Integer.MAX_VALUE;
        int y_min = Integer.MAX_VALUE;
        int x_max = Integer.MIN_VALUE;
        int y_max = Integer.MIN_VALUE;
        int mapZoomMax = this.tileController.getTileSource().getMaxZoom();
        if (markers) {
            for (MapMarker marker : this.mapMarkerList) {
                int x = OsmMercator.LonToX(marker.getLon(), mapZoomMax);
                int y2 = OsmMercator.LatToY(marker.getLat(), mapZoomMax);
                x_max = Math.max(x_max, x);
                y_max = Math.max(y_max, y2);
                x_min = Math.min(x_min, x);
                y_min = Math.min(y_min, y2);
            }
        }
        if (rectangles) {
            for (MapRectangle rectangle : this.mapRectangleList) {
                x_max = Math.max(x_max, OsmMercator.LonToX(rectangle.getBottomRight().getLon(), mapZoomMax));
                y_max = Math.max(y_max, OsmMercator.LatToY(rectangle.getTopLeft().getLat(), mapZoomMax));
                x_min = Math.min(x_min, OsmMercator.LonToX(rectangle.getTopLeft().getLon(), mapZoomMax));
                y_min = Math.min(y_min, OsmMercator.LatToY(rectangle.getBottomRight().getLat(), mapZoomMax));
            }
        }
        if (polygons) {
            for (MapPolygon polygon : this.mapPolygonList) {
                for (Coordinate c : polygon.getPoints()) {
                    int x = OsmMercator.LonToX(c.getLon(), mapZoomMax);
                    int y3 = OsmMercator.LatToY(c.getLat(), mapZoomMax);
                    x_max = Math.max(x_max, x);
                    y_max = Math.max(y_max, y3);
                    x_min = Math.min(x_min, x);
                    y_min = Math.min(y_min, y3);
                }
            }
        }
        int height = Math.max(0, this.getHeight());
        int width = Math.max(0, this.getWidth());
        int newZoom = mapZoomMax;
        int x = x_max - x_min;
        for (y = y_max - y_min; x > width || y > height; x >>= 1, y >>= 1) {
            --newZoom;
        }
        x = x_min + (x_max - x_min) / 2;
        y = y_min + (y_max - y_min) / 2;
        int z = 1 << mapZoomMax - newZoom;
        this.setDisplayPosition(x /= z, y /= z, newZoom);
    }

    public void setDisplayToFitMapMarkers() {
        this.setDisplayToFitMapElements(true, false, false);
    }

    public void setDisplayToFitMapRectangles() {
        this.setDisplayToFitMapElements(false, true, false);
    }

    public void setDisplayToFitMapPolygons() {
        this.setDisplayToFitMapElements(false, false, true);
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public Coordinate getPosition() {
        double lon = OsmMercator.XToLon(this.center.x, this.zoom);
        double lat = OsmMercator.YToLat(this.center.y, this.zoom);
        return new Coordinate(lat, lon);
    }

    public Coordinate getPosition(Point mapPoint) {
        return this.getPosition(mapPoint.x, mapPoint.y);
    }

    public Coordinate getPosition(int mapPointX, int mapPointY) {
        int x = this.center.x + mapPointX - this.getWidth() / 2;
        int y = this.center.y + mapPointY - this.getHeight() / 2;
        double lon = OsmMercator.XToLon(x, this.zoom);
        double lat = OsmMercator.YToLat(y, this.zoom);
        return new Coordinate(lat, lon);
    }

    public Point getMapPosition(double lat, double lon, boolean checkOutside) {
        int x = OsmMercator.LonToX(lon, this.zoom);
        int y = OsmMercator.LatToY(lat, this.zoom);
        if (checkOutside && ((x -= this.center.x - this.getWidth() / 2) < 0 || (y -= this.center.y - this.getHeight() / 2) < 0 || x > this.getWidth() || y > this.getHeight())) {
            return null;
        }
        return new Point(x, y);
    }

    public Point getMapPosition(double lat, double lon) {
        return this.getMapPosition(lat, lon, true);
    }

    public Point getMapPosition(Coordinate coord) {
        if (coord != null) {
            return this.getMapPosition(coord.getLat(), coord.getLon());
        }
        return null;
    }

    public Point getMapPosition(Coordinate coord, boolean checkOutside) {
        if (coord != null) {
            return this.getMapPosition(coord.getLat(), coord.getLon(), checkOutside);
        }
        return null;
    }

    public double getMeterPerPixel() {
        Point origin = new Point(5, 5);
        Point center = new Point(this.getWidth() / 2, this.getHeight() / 2);
        double pDistance = center.distance(origin);
        Coordinate originCoord = this.getPosition(origin);
        Coordinate centerCoord = this.getPosition(center);
        double mDistance = OsmMercator.getDistance(originCoord.getLat(), originCoord.getLon(), centerCoord.getLat(), centerCoord.getLon());
        return mDistance / pDistance;
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean start_top;
        super.paintComponent(g);
        int iMove = 0;
        int tilesize = this.tileSource.getTileSize();
        int tilex = this.center.x / tilesize;
        int tiley = this.center.y / tilesize;
        int off_x = this.center.x % tilesize;
        int off_y = this.center.y % tilesize;
        int w2 = this.getWidth() / 2;
        int h2 = this.getHeight() / 2;
        int posx = w2 - off_x;
        int posy = h2 - off_y;
        int diff_left = off_x;
        int diff_right = tilesize - off_x;
        int diff_top = off_y;
        int diff_bottom = tilesize - off_y;
        boolean start_left = diff_left < diff_right;
        boolean bl = start_top = diff_top < diff_bottom;
        iMove = start_top ? (start_left ? 2 : 3) : (start_left ? 1 : 0);
        int x_min = -tilesize;
        int y_min = -tilesize;
        int x_max = this.getWidth();
        int y_max = this.getHeight();
        int gridLength = 1 << this.zoom;
        boolean painted = true;
        int x = 0;
        while (painted) {
            painted = false;
            for (int i = 0; i < 4; ++i) {
                if (i % 2 == 0) {
                    ++x;
                }
                for (int j = 0; j < x; ++j) {
                    if (x_min <= posx && posx <= x_max && y_min <= posy && posy <= y_max) {
                        Tile tile;
                        if (this.scrollWrapEnabled) {
                            int tilexWrap = (tilex % gridLength + gridLength) % gridLength;
                            tile = this.tileController.getTile(tilexWrap, tiley, this.zoom);
                        } else {
                            tile = this.tileController.getTile(tilex, tiley, this.zoom);
                        }
                        if (tile != null) {
                            tile.paint(g, posx, posy);
                            if (this.tileGridVisible) {
                                g.drawRect(posx, posy, tilesize, tilesize);
                            }
                        }
                        painted = true;
                    }
                    Point p = move[iMove];
                    posx += p.x * tilesize;
                    posy += p.y * tilesize;
                    tilex += p.x;
                    tiley += p.y;
                }
                iMove = (iMove + 1) % move.length;
            }
        }
        int mapSize = tilesize << this.zoom;
        if (this.scrollWrapEnabled) {
            g.drawLine(0, h2 - this.center.y, this.getWidth(), h2 - this.center.y);
            g.drawLine(0, h2 - this.center.y + mapSize, this.getWidth(), h2 - this.center.y + mapSize);
        } else {
            g.drawRect(w2 - this.center.x, h2 - this.center.y, mapSize, mapSize);
        }
        if (this.scrollWrapEnabled) {
            this.center.x %= mapSize;
        }
        if (this.mapPolygonsVisible && this.mapPolygonList != null) {
            for (MapPolygon polygon : this.mapPolygonList) {
                this.paintPolygon(g, polygon);
            }
        }
        if (this.mapRectanglesVisible && this.mapRectangleList != null) {
            for (MapRectangle rectangle : this.mapRectangleList) {
                this.paintRectangle(g, rectangle);
            }
        }
        if (this.mapMarkersVisible && this.mapMarkerList != null) {
            for (MapMarker marker : this.mapMarkerList) {
                this.paintMarker(g, marker);
            }
        }
        this.attribution.paintAttribution(g, this.getWidth(), this.getHeight(), this.getPosition(0, 0), this.getPosition(this.getWidth(), this.getHeight()), this.zoom, this);
    }

    protected void paintMarker(Graphics g, MapMarker marker) {
        Point p = this.getMapPosition(marker.getLat(), marker.getLon());
        if (this.scrollWrapEnabled) {
            int xSave;
            int tilesize = this.tileSource.getTileSize();
            int mapSize = tilesize << this.zoom;
            if (p == null) {
                p = this.getMapPosition(marker.getLat(), marker.getLon(), false);
            }
            marker.paint(g, p);
            int xWrap = xSave = p.x;
            while ((xWrap -= mapSize) >= -15) {
                p.x = xWrap;
                marker.paint(g, p);
            }
            xWrap = xSave;
            while ((xWrap += mapSize) <= this.getWidth() + 15) {
                p.x = xWrap;
                marker.paint(g, p);
            }
        } else if (p != null) {
            marker.paint(g, p);
        }
    }

    protected void paintRectangle(Graphics g, MapRectangle rectangle) {
        Coordinate topLeft = rectangle.getTopLeft();
        Coordinate bottomRight = rectangle.getBottomRight();
        if (topLeft != null && bottomRight != null) {
            Point pTopLeft = this.getMapPosition(topLeft, false);
            Point pBottomRight = this.getMapPosition(bottomRight, false);
            if (pTopLeft != null && pBottomRight != null) {
                rectangle.paint(g, pTopLeft, pBottomRight);
                if (this.scrollWrapEnabled) {
                    int xBottomRightSave;
                    int xTopLeftSave;
                    int tilesize = this.tileSource.getTileSize();
                    int mapSize = tilesize << this.zoom;
                    int xTopLeftWrap = xTopLeftSave = pTopLeft.x;
                    int xBottomRightWrap = xBottomRightSave = pBottomRight.x;
                    while ((xBottomRightWrap -= mapSize) >= 0) {
                        pTopLeft.x = xTopLeftWrap -= mapSize;
                        pBottomRight.x = xBottomRightWrap;
                        rectangle.paint(g, pTopLeft, pBottomRight);
                    }
                    xTopLeftWrap = xTopLeftSave;
                    xBottomRightWrap = xBottomRightSave;
                    while ((xTopLeftWrap += mapSize) <= this.getWidth()) {
                        pTopLeft.x = xTopLeftWrap;
                        pBottomRight.x = xBottomRightWrap += mapSize;
                        rectangle.paint(g, pTopLeft, pBottomRight);
                    }
                }
            }
        }
    }

    protected void paintPolygon(Graphics g, MapPolygon polygon) {
        List<Coordinate> coords = polygon.getPoints();
        if (coords != null && coords.size() >= 3) {
            LinkedList<Point> points = new LinkedList<Point>();
            for (Coordinate c : coords) {
                Point p = this.getMapPosition(c, false);
                if (p == null) {
                    return;
                }
                points.add(p);
            }
            polygon.paint(g, points);
            if (this.scrollWrapEnabled) {
                int tilesize = this.tileSource.getTileSize();
                int mapSize = tilesize << this.zoom;
                LinkedList<Point> pointsWrapped = new LinkedList<Point>(points);
                boolean keepWrapping = true;
                while (keepWrapping) {
                    for (Point p : pointsWrapped) {
                        p.x -= mapSize;
                        if (p.x >= 0) continue;
                        keepWrapping = false;
                    }
                    polygon.paint(g, pointsWrapped);
                }
                pointsWrapped = new LinkedList<Point>(points);
                keepWrapping = true;
                while (keepWrapping) {
                    for (Point p : pointsWrapped) {
                        p.x += mapSize;
                        if (p.x <= this.getWidth()) continue;
                        keepWrapping = false;
                    }
                    polygon.paint(g, pointsWrapped);
                }
            }
        }
    }

    public void moveMap(int x, int y) {
        this.tileController.cancelOutstandingJobs();
        this.center.x += x;
        this.center.y += y;
        this.repaint();
        this.fireJMVEvent(new JMVCommandEvent(JMVCommandEvent.COMMAND.MOVE, this));
    }

    public int getZoom() {
        return this.zoom;
    }

    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    public void zoomIn(Point mapPoint) {
        this.setZoom(this.zoom + 1, mapPoint);
    }

    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    public void zoomOut(Point mapPoint) {
        this.setZoom(this.zoom - 1, mapPoint);
    }

    public void setZoom(int zoom, Point mapPoint) {
        if (zoom > this.tileController.getTileSource().getMaxZoom() || zoom < this.tileController.getTileSource().getMinZoom() || zoom == this.zoom) {
            return;
        }
        Coordinate zoomPos = this.getPosition(mapPoint);
        this.tileController.cancelOutstandingJobs();
        this.setDisplayPositionByLatLon(mapPoint, zoomPos.getLat(), zoomPos.getLon(), zoom);
        this.fireJMVEvent(new JMVCommandEvent(JMVCommandEvent.COMMAND.ZOOM, this));
    }

    public void setZoom(int zoom) {
        this.setZoom(zoom, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    protected void zoomChanged(int oldZoom) {
        this.zoomSlider.setToolTipText("Zoom level " + this.zoom);
        this.zoomInButton.setToolTipText("Zoom to level " + (this.zoom + 1));
        this.zoomOutButton.setToolTipText("Zoom to level " + (this.zoom - 1));
        this.zoomOutButton.setEnabled(this.zoom > this.tileController.getTileSource().getMinZoom());
        this.zoomInButton.setEnabled(this.zoom < this.tileController.getTileSource().getMaxZoom());
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean tileGridVisible) {
        this.tileGridVisible = tileGridVisible;
        this.repaint();
    }

    public boolean getMapMarkersVisible() {
        return this.mapMarkersVisible;
    }

    public void setMapMarkerVisible(boolean mapMarkersVisible) {
        this.mapMarkersVisible = mapMarkersVisible;
        this.repaint();
    }

    public void setMapMarkerList(List<MapMarker> mapMarkerList) {
        this.mapMarkerList = mapMarkerList;
        this.repaint();
    }

    public List<MapMarker> getMapMarkerList() {
        return this.mapMarkerList;
    }

    public void setMapRectangleList(List<MapRectangle> mapRectangleList) {
        this.mapRectangleList = mapRectangleList;
        this.repaint();
    }

    public List<MapRectangle> getMapRectangleList() {
        return this.mapRectangleList;
    }

    public void setMapPolygonList(List<MapPolygon> mapPolygonList) {
        this.mapPolygonList = mapPolygonList;
        this.repaint();
    }

    public List<MapPolygon> getMapPolygonList() {
        return this.mapPolygonList;
    }

    public void addMapMarker(MapMarker marker) {
        this.mapMarkerList.add(marker);
        this.repaint();
    }

    public void removeMapMarker(MapMarker marker) {
        this.mapMarkerList.remove(marker);
        this.repaint();
    }

    public void removeAllMapMarkers() {
        this.mapMarkerList.clear();
        this.repaint();
    }

    public void addMapRectangle(MapRectangle rectangle) {
        this.mapRectangleList.add(rectangle);
        this.repaint();
    }

    public void removeMapRectangle(MapRectangle rectangle) {
        this.mapRectangleList.remove(rectangle);
        this.repaint();
    }

    public void removeAllMapRectangles() {
        this.mapRectangleList.clear();
        this.repaint();
    }

    public void addMapPolygon(MapPolygon polygon) {
        this.mapPolygonList.add(polygon);
        this.repaint();
    }

    public void removeMapPolygon(MapPolygon polygon) {
        this.mapPolygonList.remove(polygon);
        this.repaint();
    }

    public void removeAllMapPolygons() {
        this.mapPolygonList.clear();
        this.repaint();
    }

    public void setZoomContolsVisible(boolean visible) {
        this.zoomSlider.setVisible(visible);
        this.zoomInButton.setVisible(visible);
        this.zoomOutButton.setVisible(visible);
    }

    public boolean getZoomContolsVisible() {
        return this.zoomSlider.isVisible();
    }

    public void setTileSource(TileSource tileSource) {
        if (tileSource.getMaxZoom() > 22) {
            throw new RuntimeException("Maximum zoom level too high");
        }
        if (tileSource.getMinZoom() < 0) {
            throw new RuntimeException("Minumim zoom level too low");
        }
        this.tileSource = tileSource;
        this.tileController.setTileSource(tileSource);
        this.zoomSlider.setMinimum(tileSource.getMinZoom());
        this.zoomSlider.setMaximum(tileSource.getMaxZoom());
        this.tileController.cancelOutstandingJobs();
        if (this.zoom > tileSource.getMaxZoom()) {
            this.setZoom(tileSource.getMaxZoom());
        }
        this.attribution.initialize(tileSource);
        this.repaint();
    }

    @Override
    public void tileLoadingFinished(Tile tile, boolean success) {
        this.repaint();
    }

    public boolean isMapRectanglesVisible() {
        return this.mapRectanglesVisible;
    }

    public void setMapRectanglesVisible(boolean mapRectanglesVisible) {
        this.mapRectanglesVisible = mapRectanglesVisible;
        this.repaint();
    }

    public boolean isMapPolygonsVisible() {
        return this.mapPolygonsVisible;
    }

    public void setMapPolygonsVisible(boolean mapPolygonsVisible) {
        this.mapPolygonsVisible = mapPolygonsVisible;
        this.repaint();
    }

    public boolean isScrollWrapEnabled() {
        return this.scrollWrapEnabled;
    }

    public void setScrollWrapEnabled(boolean scrollWrapEnabled) {
        this.scrollWrapEnabled = scrollWrapEnabled;
        this.repaint();
    }

    public ZOOM_BUTTON_STYLE getZoomButtonStyle() {
        return this.zoomButtonStyle;
    }

    public void setZoomButtonStyle(ZOOM_BUTTON_STYLE style) {
        this.zoomButtonStyle = style;
        if (this.zoomSlider == null || this.zoomInButton == null || this.zoomOutButton == null) {
            return;
        }
        switch (style) {
            case HORIZONTAL: {
                this.zoomSlider.setBounds(10, 10, 30, 150);
                this.zoomInButton.setBounds(4, 155, 18, 18);
                this.zoomOutButton.setBounds(26, 155, 18, 18);
                break;
            }
            case VERTICAL: {
                this.zoomSlider.setBounds(10, 27, 30, 150);
                this.zoomInButton.setBounds(14, 8, 20, 20);
                this.zoomOutButton.setBounds(14, 176, 20, 20);
                break;
            }
            default: {
                this.zoomSlider.setBounds(10, 10, 30, 150);
                this.zoomInButton.setBounds(4, 155, 18, 18);
                this.zoomOutButton.setBounds(26, 155, 18, 18);
            }
        }
        this.repaint();
    }

    public TileController getTileController() {
        return this.tileController;
    }

    @Override
    public TileCache getTileCache() {
        return this.tileController.getTileCache();
    }

    public void setTileLoader(TileLoader loader) {
        this.tileController.setTileLoader(loader);
    }

    public AttributionSupport getAttribution() {
        return this.attribution;
    }

    public void addJMVListener(JMapViewerEventListener listener) {
        this.listenerList.add(JMapViewerEventListener.class, listener);
    }

    public void removeJMVListener(JMapViewerEventListener listener) {
        this.listenerList.remove(JMapViewerEventListener.class, listener);
    }

    void fireJMVEvent(JMVCommandEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != JMapViewerEventListener.class) continue;
            ((JMapViewerEventListener)listeners[i + 1]).processCommand(evt);
        }
    }

    public static enum ZOOM_BUTTON_STYLE {
        HORIZONTAL,
        VERTICAL;

    }
}

