/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.parser;

import java.util.Stack;
import org.eclipse.wst.json.core.internal.parser.IJSONTokenizer;
import org.eclipse.wst.json.core.regions.JSONRegionContexts;

public abstract class AbstractJSONTokenizer
implements JSONRegionContexts,
IJSONTokenizer {
    protected final Stack<Boolean> jsonContextStack = new Stack();

    protected String startElement(boolean isArray) {
        this.jsonContextStack.push(isArray);
        if (isArray) {
            this.setJSONArrayState();
            return "JSON_ARRAY_OPEN";
        }
        this.setJSONObjectState();
        return "JSON_OBJECT_OPEN";
    }

    protected String endElement(boolean isArray) {
        boolean arrayContent = this.isArrayParsing();
        if (!this.jsonContextStack.isEmpty()) {
            this.jsonContextStack.pop();
        }
        if (isArray) {
            if (arrayContent) {
                if (!this.jsonContextStack.isEmpty()) {
                    this.setJSONValueState();
                }
                return "JSON_ARRAY_CLOSE";
            }
            return "UNDEFINED";
        }
        if (!arrayContent) {
            if (!this.jsonContextStack.isEmpty()) {
                this.setJSONValueState();
            }
            return "JSON_OBJECT_CLOSE";
        }
        return "UNDEFINED";
    }

    public boolean isArrayParsing() {
        if (this.jsonContextStack.isEmpty()) {
            return false;
        }
        return this.jsonContextStack.peek();
    }

    protected abstract void setJSONArrayState();

    protected abstract void setJSONObjectState();

    protected abstract void setJSONValueState();
}

