/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.border;

import java.util.Arrays;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.MessageFormater;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CSSBorder
extends AbstractBorder {
    private static final String BODER_QUERY_TEMPLETE = "border-{0}-style";
    private static final String COLOR_QUERY_TEMPLETE = "border-{0}-color";
    private final ICSSStyle _style;
    private final Rectangle _innerRect = new Rectangle();

    public CSSBorder(ICSSStyle style) {
        this._style = style;
    }

    public Insets getInsets(IFigure figure) {
        return this._style.getBorderInsets();
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(CSSBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        this._innerRect.setBounds(tempRect);
        this._innerRect.crop(this._style.getBorderInsets());
        this.paintEdge(graphics, tempRect, this._innerRect, "left");
        this.paintEdge(graphics, tempRect, this._innerRect, "right");
        this.paintEdge(graphics, tempRect, this._innerRect, "top");
        this.paintEdge(graphics, tempRect, this._innerRect, "bottom");
    }

    private boolean shouldDraw(String style) {
        return style != null && !"none".equals(style) && !"hidden".equals(style);
    }

    private RGB[] getEdgeColors(Graphics graphics, String style, String edge) {
        String property = MessageFormater.format(COLOR_QUERY_TEMPLETE, edge);
        Object obj = this._style.getStyleProperty(property);
        if (obj instanceof RGB) {
            return this.getCustomColors(graphics, style, edge, (RGB)obj);
        }
        if (obj instanceof Color) {
            return this.getCustomColors(graphics, style, edge, ((Color)obj).getRGB());
        }
        return this.getDefaultColors(graphics, style, edge);
    }

    private RGB[] getDefaultColors(Graphics graphics, String style, String edge) {
        if ("outset".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{ColorConstants.button.getRGB(), ColorConstants.buttonLightest.getRGB()};
            }
            return new RGB[]{ColorConstants.buttonDarkest.getRGB(), ColorConstants.buttonDarker.getRGB()};
        }
        if ("inset".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{ColorConstants.buttonDarker.getRGB(), ColorConstants.buttonDarkest.getRGB()};
            }
            return new RGB[]{ColorConstants.buttonLightest.getRGB(), ColorConstants.button.getRGB()};
        }
        if ("__td_border_style__".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{ColorConstants.buttonDarker.getRGB()};
            }
            return new RGB[]{ColorConstants.button.getRGB()};
        }
        if ("ridge".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{ColorConstants.button.getRGB(), ColorConstants.buttonDarkest.getRGB()};
            }
            return new RGB[]{ColorConstants.buttonDarkest.getRGB(), ColorConstants.button.getRGB()};
        }
        if ("groove".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{ColorConstants.buttonDarker.getRGB(), ColorConstants.buttonLightest.getRGB()};
            }
            return new RGB[]{ColorConstants.buttonLightest.getRGB(), ColorConstants.buttonDarker.getRGB()};
        }
        if ("double".equals(style)) {
            return new RGB[]{ColorConstants.buttonDarkest.getRGB(), graphics.getBackgroundColor().getRGB(), ColorConstants.buttonDarkest.getRGB()};
        }
        if ("solid".equals(style)) {
            return new RGB[]{ColorConstants.black.getRGB()};
        }
        return new RGB[]{ColorConstants.black.getRGB()};
    }

    private RGB[] getCustomColors(Graphics graphics, String style, String edge, RGB baseColor) {
        if ("outset".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{new RGB(baseColor.red * 3 / 4, baseColor.green * 3 / 4, baseColor.blue * 3 / 4), new RGB(baseColor.red, baseColor.green, baseColor.blue)};
            }
            return new RGB[]{new RGB(baseColor.red / 2, baseColor.green / 2, baseColor.blue / 2), new RGB(baseColor.red / 4, baseColor.green / 4, baseColor.blue / 4)};
        }
        if ("inset".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{new RGB(baseColor.red / 4, baseColor.green / 4, baseColor.blue / 4), new RGB(baseColor.red / 2, baseColor.green / 2, baseColor.blue / 2)};
            }
            return new RGB[]{new RGB(baseColor.red, baseColor.green, baseColor.blue), new RGB(baseColor.red * 3 / 4, baseColor.green * 3 / 4, baseColor.blue * 3 / 4)};
        }
        if ("__td_border_style__".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{new RGB(baseColor.red / 4, baseColor.green / 4, baseColor.blue / 4)};
            }
            return new RGB[]{new RGB(baseColor.red, baseColor.green, baseColor.blue)};
        }
        if ("ridge".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{new RGB(baseColor.red * 3 / 4, baseColor.green * 3 / 4, baseColor.blue * 3 / 4), new RGB(baseColor.red / 2, baseColor.green / 2, baseColor.blue / 2)};
            }
            return new RGB[]{new RGB(baseColor.red / 2, baseColor.green / 2, baseColor.blue / 2), new RGB(baseColor.red * 3 / 4, baseColor.green * 3 / 4, baseColor.blue * 3 / 4)};
        }
        if ("groove".equals(style)) {
            if ("top".equals(edge) || "left".equals(edge)) {
                return new RGB[]{new RGB(baseColor.red / 4, baseColor.green / 4, baseColor.blue / 4), new RGB(baseColor.red, baseColor.green, baseColor.blue)};
            }
            return new RGB[]{new RGB(baseColor.red, baseColor.green, baseColor.blue), new RGB(baseColor.red / 4, baseColor.green / 4, baseColor.blue / 4)};
        }
        if ("double".equals(style)) {
            return new RGB[]{new RGB(baseColor.red, baseColor.green, baseColor.blue), graphics.getBackgroundColor().getRGB(), new RGB(baseColor.red, baseColor.green, baseColor.blue)};
        }
        if ("solid".equals(style)) {
            return new RGB[]{new RGB(baseColor.red, baseColor.green, baseColor.blue)};
        }
        return new RGB[]{new RGB(baseColor.red, baseColor.green, baseColor.blue)};
    }

    public void paintEdge(Graphics graphics, Rectangle rect, Rectangle innerRect, String edge, String style) {
        if (!this.shouldDraw(style)) {
            return;
        }
        RGB[] rgbs = this.getEdgeColors(graphics, style, edge);
        if ("top".equals(edge)) {
            this.paintTopEdge(graphics, rgbs, style, rect, innerRect);
        } else if ("bottom".equals(edge)) {
            this.paintBottomEdge(graphics, rgbs, style, rect, innerRect);
        } else if ("left".equals(edge)) {
            this.paintLeftEdge(graphics, rgbs, style, rect, innerRect);
        } else if ("right".equals(edge)) {
            this.paintRightEdge(graphics, rgbs, style, rect, innerRect);
        }
    }

    protected void paintEdge(Graphics graphics, Rectangle rect, Rectangle innerRect, String edge) {
        String property = MessageFormater.format(BODER_QUERY_TEMPLETE, edge);
        Object obj = this._style.getStyleProperty(property);
        String style = obj.toString();
        this.paintEdge(graphics, rect, innerRect, edge, style);
    }

    private void paintTopEdge(Graphics graphics, RGB[] rgbs, String style, Rectangle rect, Rectangle innerRect) {
        int leftX = rect.x;
        int rightX = rect.right() - 1;
        int y = rect.y;
        int width = innerRect.y - rect.y;
        if ("dotted".equals(style)) {
            this.drawDottedBorder(graphics, rgbs, "top", rect, width);
        } else if ("dashed".equals(style)) {
            this.drawDashedBorder(graphics, rgbs, "top", rect, width);
        } else {
            double xLeftRate = (double)(innerRect.x - rect.x) / (double)width;
            double xRightRate = (double)(rect.right() - innerRect.right()) / (double)width;
            graphics.pushState();
            int i = 0;
            while (i < width) {
                Color color = new Color((Device)Display.getCurrent(), rgbs[rgbs.length * i / width]);
                graphics.setForegroundColor(color);
                graphics.drawLine((int)((double)leftX + (double)i * xLeftRate), y + i, (int)((double)rightX - (double)i * xRightRate), y + i);
                color.dispose();
                ++i;
            }
            graphics.popState();
        }
    }

    private void paintBottomEdge(Graphics graphics, RGB[] rgbs, String style, Rectangle rect, Rectangle innerRect) {
        int leftX = rect.x;
        int rightX = rect.right() - 1;
        int y = rect.bottom() - 1;
        int width = rect.bottom() - innerRect.bottom();
        if ("dotted".equals(style)) {
            this.drawDottedBorder(graphics, rgbs, "bottom", rect, width);
        } else if ("dashed".equals(style)) {
            this.drawDashedBorder(graphics, rgbs, "bottom", rect, width);
        } else {
            double xLeftRate = (double)(innerRect.x - rect.x) / (double)width;
            double xRightRate = (double)(rect.right() - innerRect.right()) / (double)width;
            graphics.pushState();
            int i = 0;
            while (i < width) {
                Color color = new Color((Device)Display.getCurrent(), rgbs[rgbs.length * i / width]);
                graphics.setForegroundColor(color);
                graphics.drawLine(leftX + (int)((double)i * xLeftRate), y - i, rightX - (int)((double)i * xRightRate), y - i);
                color.dispose();
                ++i;
            }
            graphics.popState();
        }
    }

    private void paintLeftEdge(Graphics graphics, RGB[] rgbs, String style, Rectangle rect, Rectangle innerRect) {
        int x = rect.x;
        int topY = rect.y;
        int bottomY = rect.bottom() - 1;
        int width = innerRect.x - rect.x;
        if ("dotted".equals(style)) {
            this.drawDottedBorder(graphics, rgbs, "left", rect, width);
        } else if ("dashed".equals(style)) {
            this.drawDashedBorder(graphics, rgbs, "left", rect, width);
        } else {
            double yTopRate = (double)(innerRect.y - rect.y) / (double)width;
            double yBottomRate = (double)(rect.bottom() - innerRect.bottom()) / (double)width;
            graphics.pushState();
            int i = 0;
            while (i < width) {
                Color color = new Color((Device)Display.getCurrent(), rgbs[rgbs.length * i / width]);
                graphics.setForegroundColor(color);
                graphics.drawLine(x + i, topY + (int)((double)i * yTopRate), x + i, bottomY - (int)((double)i * yBottomRate));
                color.dispose();
                ++i;
            }
            graphics.popState();
        }
    }

    private void paintRightEdge(Graphics graphics, RGB[] rgbs, String style, Rectangle rect, Rectangle innerRect) {
        int x = rect.right() - 1;
        int topY = rect.y;
        int bottomY = rect.bottom() - 1;
        int width = rect.right() - innerRect.right();
        if ("dotted".equals(style)) {
            this.drawDottedBorder(graphics, rgbs, "right", rect, width);
        } else if ("dashed".equals(style)) {
            this.drawDashedBorder(graphics, rgbs, "right", rect, width);
        } else {
            graphics.pushState();
            int i = 0;
            while (i < width) {
                double yTopRate = (double)(innerRect.y - rect.y) / (double)width;
                double yBottomRate = (double)(rect.bottom() - innerRect.bottom()) / (double)width;
                Color color = new Color((Device)Display.getCurrent(), rgbs[rgbs.length * i / width]);
                graphics.setForegroundColor(color);
                graphics.drawLine(x - i, topY + (int)((double)i * yTopRate), x - i, bottomY - (int)((double)i * yBottomRate));
                color.dispose();
                ++i;
            }
            graphics.popState();
        }
    }

    private void drawDottedBorder(Graphics graphics, RGB[] rgbs, String style, Rectangle rect, int width) {
        if (width == 0 || 3 * width > rect.width) {
            return;
        }
        int beginX = 0;
        int beginY = 0;
        int xRate = 0;
        int yRate = 0;
        int span = 0;
        if ("top".equals(style)) {
            beginX = rect.x;
            beginY = rect.y;
            xRate = 1;
            yRate = 0;
            span = rect.width;
        } else if ("left".equals(style)) {
            beginX = rect.x;
            beginY = rect.y;
            xRate = 0;
            yRate = 1;
            span = rect.height;
        } else if ("bottom".equals(style)) {
            beginX = rect.x;
            beginY = rect.y + rect.height - width;
            xRate = 1;
            yRate = 0;
            span = rect.width;
        } else if ("right".equals(style)) {
            beginX = rect.x + rect.width - width;
            beginY = rect.y;
            xRate = 0;
            yRate = 1;
            span = rect.height;
        }
        int dottedCount = (span + width) / (2 * width);
        if (dottedCount < 2) {
            dottedCount = 2;
        }
        int averagePad = (span - dottedCount * width) / (dottedCount - 1);
        int leftPad = (span - dottedCount * width) % (dottedCount - 1);
        int[] paddings = new int[dottedCount - 1];
        Arrays.fill(paddings, averagePad);
        int i = 0;
        while (i < leftPad) {
            paddings[i] = paddings[i] + 1;
            ++i;
        }
        int pad = 0;
        Color color = new Color((Device)Display.getCurrent(), rgbs[0]);
        graphics.pushState();
        graphics.setBackgroundColor(color);
        int i2 = 0;
        while (i2 < dottedCount) {
            graphics.fillOval(beginX + (pad + width * i2) * xRate, beginY + (pad + width * i2) * yRate, width, width);
            if (i2 != dottedCount - 1) {
                pad += paddings[i2];
            }
            ++i2;
        }
        graphics.popState();
        color.dispose();
    }

    private void drawDashedBorder(Graphics graphics, RGB[] rgbs, String style, Rectangle rect, int borderThick) {
        if (borderThick == 0 || 5 * borderThick > rect.width) {
            return;
        }
        if (5 * borderThick > rect.height && ("left".equals(style) || "right".equals(style))) {
            return;
        }
        int width = 0;
        int height = 0;
        int edgeLength = 0;
        int beginX = 0;
        int beginY = 0;
        int xRate = 0;
        int yRate = 0;
        int span = 0;
        if ("top".equals(style)) {
            width = borderThick * 2;
            height = borderThick;
            beginX = rect.x;
            beginY = rect.y;
            xRate = 1;
            yRate = 0;
            span = rect.width;
            edgeLength = width;
        } else if ("left".equals(style)) {
            width = borderThick;
            height = borderThick * 2;
            beginX = rect.x;
            beginY = rect.y;
            xRate = 0;
            yRate = 1;
            span = rect.height;
            edgeLength = height;
        } else if ("bottom".equals(style)) {
            width = borderThick * 2;
            height = borderThick;
            beginX = rect.x;
            beginY = rect.y + rect.height - height;
            xRate = 1;
            yRate = 0;
            span = rect.width;
            edgeLength = width;
        } else if ("right".equals(style)) {
            width = borderThick;
            height = borderThick * 2;
            beginX = rect.x + rect.width - width;
            beginY = rect.y;
            xRate = 0;
            yRate = 1;
            span = rect.height;
            edgeLength = height;
        }
        int dottedCount = (span + borderThick) / (edgeLength + borderThick);
        if (dottedCount < 2) {
            dottedCount = 2;
        }
        int averagePad = (span - dottedCount * edgeLength) / (dottedCount - 1);
        int leftPad = (span - dottedCount * edgeLength) % (dottedCount - 1);
        int[] paddings = new int[dottedCount - 1];
        Arrays.fill(paddings, averagePad);
        int i = 0;
        while (i < leftPad) {
            paddings[i] = paddings[i] + 1;
            ++i;
        }
        int pad = 0;
        graphics.pushState();
        Color color = new Color((Device)Display.getCurrent(), rgbs[0]);
        graphics.setBackgroundColor(color);
        int i2 = 0;
        while (i2 < dottedCount) {
            graphics.fillRectangle(beginX + (pad + width * i2) * xRate, beginY + (pad + height * i2) * yRate, width, height);
            if (i2 != dottedCount - 1) {
                pad += paddings[i2];
            }
            ++i2;
        }
        graphics.popState();
        color.dispose();
    }
}

