/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.rse.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.cft.server.rse.internal.CloudFoundryHostFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileResource
extends CloudFoundryHostFile {
    private boolean isDirectory = false;
    private boolean isFile = true;
    private long modifiedDate;
    private String name;
    private String parent;
    private String path;
    private String size;

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public String getAbsolutePath() {
        return this.path;
    }

    public List<FileResource> getChildren(IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    @Override
    public String getClassification() {
        if (this.isDirectory) {
            return "directory";
        }
        if (this.isFile) {
            return "file";
        }
        return "unknown";
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public String getName() {
        return this.name;
    }

    public String getParentPath() {
        return this.parent;
    }

    public long getSize() {
        long l = 0L;
        try {
            String num = "0";
            if (this.size.endsWith("B")) {
                num = this.size.substring(0, this.size.length() - 1);
                l = Long.parseLong(num);
            } else if (this.size.endsWith("K")) {
                num = this.size.substring(0, this.size.length() - 1);
                float f = Float.parseFloat(num) * 1000.0f;
                l = Float.valueOf(f).longValue();
            } else if (this.size.endsWith("M")) {
                num = this.size.substring(0, this.size.length() - 1);
                float f = Float.parseFloat(num) * 1000.0f * 1000.0f;
                l = Float.valueOf(f).longValue();
            }
        }
        catch (Exception exception) {}
        return l;
    }

    public boolean isArchive() {
        return false;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public void renameTo(String newAbsolutePath) {
    }

    public void setAbsolutePath(String path) {
        this.path = path;
    }

    public void setIsDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public void setIsFile(boolean isFile) {
        this.isFile = isFile;
    }

    public void setModifiedDate(long modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentPath(String parent) {
        this.parent = parent;
    }

    public void setSize(String size) {
        this.size = size;
    }
}

