/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.codan;

import java.util.Collection;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.qt.core.ASTUtil;
import org.eclipse.cdt.internal.qt.core.QtFunctionCall;
import org.eclipse.cdt.internal.qt.core.QtMethodReference;
import org.eclipse.cdt.internal.qt.core.QtNature;
import org.eclipse.cdt.internal.qt.core.codan.Messages;
import org.eclipse.cdt.internal.qt.core.index.IQMethod;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

public class QtSyntaxChecker
extends AbstractIndexAstChecker {
    private final Checker checker = new Checker();

    public boolean runInEditor() {
        return true;
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        this.getTopLevelPreference((IProblem)problem);
        this.getLaunchModePreference((IProblem)problem).enableInLaunchModes(new CheckerLaunchMode[]{CheckerLaunchMode.RUN_ON_FILE_OPEN, CheckerLaunchMode.RUN_AS_YOU_TYPE, CheckerLaunchMode.RUN_ON_DEMAND});
    }

    public synchronized boolean processResource(IResource resource) throws OperationCanceledException {
        if (QtNature.hasNature(resource.getProject())) {
            return super.processResource(resource);
        }
        return false;
    }

    public void processAst(IASTTranslationUnit ast) {
        if (QtNature.hasNature(ASTUtil.getProject((IASTNode)ast))) {
            ast.accept((ASTVisitor)this.checker);
        }
    }

    private class Checker
    extends ASTVisitor {
        public Checker() {
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTExpression expr) {
            if (!(expr instanceof IASTFunctionCallExpression)) {
                return 3;
            }
            IASTFunctionCallExpression fncall = (IASTFunctionCallExpression)expr;
            Collection<QtMethodReference> refs = QtFunctionCall.getReferences(fncall);
            if (refs != null) {
                for (QtMethodReference ref : refs) {
                    IQMethod method = ref.getMethod();
                    if (method != null) continue;
                    if (ref.getRawSignature().isEmpty()) {
                        this.report((IASTNode)ref, Messages.QtConnect_macro_without_method_1, ref.getType().macroName);
                        continue;
                    }
                    this.report((IASTNode)ref, Messages.QtConnect_macro_method_not_found_3, ref.getType().paramName, ref.getContainingType().getName(), ref.getRawSignature());
                }
            }
            return 3;
        }

        private void report(IASTNode node, String message, Object ... args) {
            if (args.length <= 0) {
                QtSyntaxChecker.this.reportProblem("org.eclipse.cdt.qt.core.qtproblem", node, new Object[]{message});
            } else {
                QtSyntaxChecker.this.reportProblem("org.eclipse.cdt.qt.core.qtproblem", node, new Object[]{NLS.bind((String)message, (Object[])args)});
            }
        }
    }
}

