/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedIndicesData {
    private static final TIntIntHashMap ourRegisteredIndices = new TIntIntHashMap();
    private static IndexedStateMap ourSharedFileInputs;
    private static IndexedStateMap ourSharedFileContentIndependentInputs;
    private static IndexedStateMap ourSharedContentInputs;
    static final boolean ourFileSharedIndicesEnabled;
    static final boolean DO_CHECKS;
    private static final Logger LOG;
    private static final int CONTENTLESS = 1;
    private static final int CONTENTFUL = 2;

    public static void init() {
    }

    static <Key, Value, Input> void registerIndex(@NotNull ID<Key, Value> indexId, @NotNull IndexExtension<Key, Value, Input> extension) {
        if (indexId == null) {
            SharedIndicesData.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            SharedIndicesData.$$$reportNull$$$0(1);
        }
        if (extension instanceof FileBasedIndexExtension) {
            boolean dependsOnFileContent = ((FileBasedIndexExtension)extension).dependsOnFileContent();
            ourRegisteredIndices.put(indexId.getUniqueId(), dependsOnFileContent ? 2 : 1);
        }
    }

    static void flushData() {
        if (!ourFileSharedIndicesEnabled) {
            return;
        }
        ourSharedFileInputs.force();
        ourSharedContentInputs.force();
        ourSharedFileContentIndependentInputs.force();
    }

    static void beforeSomeIndexVersionInvalidation() {
        SharedIndicesData.flushData();
    }

    public static boolean canReadIndexValueWithoutExtraBlocking(int contentId) {
        return !ourSharedContentInputs.isBusyReading();
    }

    private static void writeIndexValue(int indexUniqueId, long indexCreationStamp, byte[] indexValue, int indexValueOffset, int indexValueLength, DataOutput compactedOutput) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)compactedOutput, (int)indexValueLength);
        DataInputOutputUtil.writeINT((DataOutput)compactedOutput, (int)indexUniqueId);
        DataInputOutputUtil.writeTIME((DataOutput)compactedOutput, (long)indexCreationStamp);
        if (indexValue != null) {
            assert (indexValueLength > 0);
            compactedOutput.write(indexValue, indexValueOffset, indexValueLength);
        } else assert (indexValueLength == 0);
    }

    @Nullable
    static <Key, Value> Value recallFileData(int id, @NotNull ID<Key, ?> indexId, @NotNull DataExternalizer<Value> externalizer) throws IOException {
        int type;
        if (indexId == null) {
            SharedIndicesData.$$$reportNull$$$0(2);
        }
        if (externalizer == null) {
            SharedIndicesData.$$$reportNull$$$0(3);
        }
        if ((type = ourRegisteredIndices.get(indexId.getUniqueId())) == 0) {
            return null;
        }
        IndexedStateMap states = type == 1 ? ourSharedFileContentIndependentInputs : ourSharedFileInputs;
        return SharedIndicesData.doRecallData(id, indexId, externalizer, states);
    }

    @Nullable
    static <Key, Value> Value recallContentData(int id, @NotNull ID<Key, ?> indexId, @NotNull DataExternalizer<Value> externalizer) throws IOException {
        if (indexId == null) {
            SharedIndicesData.$$$reportNull$$$0(4);
        }
        if (externalizer == null) {
            SharedIndicesData.$$$reportNull$$$0(5);
        }
        return SharedIndicesData.doRecallData(id, indexId, externalizer, ourSharedContentInputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <Key, Value> Value doRecallData(int id, @NotNull ID<Key, ?> indexId, @NotNull DataExternalizer<Value> externalizer, @NotNull IndexedStateMap states) throws IOException {
        if (indexId == null) {
            SharedIndicesData.$$$reportNull$$$0(6);
        }
        if (externalizer == null) {
            SharedIndicesData.$$$reportNull$$$0(7);
        }
        if (states == null) {
            SharedIndicesData.$$$reportNull$$$0(8);
        }
        FileAccessorCache.Handle stateHandle = states.myStateCache.get(id);
        IndexedState indexedState = (IndexedState)stateHandle.get();
        try {
            DataInputStream in = indexedState.readIndexedState(indexId);
            if (in == null) {
                Value Value2 = null;
                return Value2;
            }
            Object object = externalizer.read((DataInput)in);
            return (Value)object;
        }
        finally {
            stateHandle.release();
        }
    }

    static <Key, Value> void associateFileData(int id, @NotNull ID<Key, ?> indexId, Value keys, @NotNull DataExternalizer<Value> externalizer) throws IOException {
        int type;
        if (indexId == null) {
            SharedIndicesData.$$$reportNull$$$0(9);
        }
        if (externalizer == null) {
            SharedIndicesData.$$$reportNull$$$0(10);
        }
        if ((type = ourRegisteredIndices.get(indexId.getUniqueId())) == 0) {
            return;
        }
        boolean contentlessIndex = type == 1;
        SharedIndicesData.doAssociateData(id, indexId, keys, externalizer, contentlessIndex ? ourSharedFileContentIndependentInputs : ourSharedFileInputs);
    }

    static <Key, Value> void associateContentData(int id, @NotNull ID<Key, ?> indexId, Value keys, @NotNull DataExternalizer<Value> externalizer) throws IOException {
        if (indexId == null) {
            SharedIndicesData.$$$reportNull$$$0(11);
        }
        if (externalizer == null) {
            SharedIndicesData.$$$reportNull$$$0(12);
        }
        SharedIndicesData.doAssociateData(id, indexId, keys, externalizer, ourSharedContentInputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <Key, Value> void doAssociateData(int id, @NotNull ID<Key, ?> indexId, Value keys, @NotNull DataExternalizer<Value> externalizer, @NotNull IndexedStateMap index) throws IOException {
        BufferExposingByteArrayOutputStream savedKeysData;
        if (indexId == null) {
            SharedIndicesData.$$$reportNull$$$0(13);
        }
        if (externalizer == null) {
            SharedIndicesData.$$$reportNull$$$0(14);
        }
        if (index == null) {
            SharedIndicesData.$$$reportNull$$$0(15);
        }
        if (keys != null) {
            savedKeysData = new BufferExposingByteArrayOutputStream();
            externalizer.save((DataOutput)new DataOutputStream((OutputStream)savedKeysData), keys);
        } else {
            savedKeysData = null;
        }
        FileAccessorCache.Handle stateHandle = index.myStateCache.getIfCached(id);
        try {
            index.appendData(id, out -> {
                IndexedState indexedState;
                byte[] internalBuffer = null;
                int size = 0;
                if (savedKeysData != null) {
                    internalBuffer = savedKeysData.getInternalBuffer();
                    size = savedKeysData.size();
                }
                long indexCreationStamp = IndexingStamp.getIndexCreationStamp(indexId);
                SharedIndicesData.writeIndexValue(indexId.getUniqueId(), indexCreationStamp, internalBuffer, 0, size, out);
                IndexedState indexedState2 = indexedState = stateHandle != null ? (IndexedState)stateHandle.get() : null;
                if (indexedState != null) {
                    indexedState.appendIndexedState(indexId, internalBuffer, size);
                }
            });
        }
        finally {
            if (stateHandle != null) {
                stateHandle.release();
            }
        }
    }

    static {
        ourFileSharedIndicesEnabled = SystemProperties.getBooleanProperty((String)"idea.shared.input.index.enabled", (boolean)false);
        DO_CHECKS = ourFileSharedIndicesEnabled && SystemProperties.getBooleanProperty((String)"idea.shared.input.index.checked", (boolean)false);
        LOG = Logger.getInstance((String)"#com.intellij.util.indexing.impl.MapReduceIndex");
        if (ourFileSharedIndicesEnabled) {
            try {
                ourSharedFileInputs = IndexedStateMap.createMap(new File(PathManager.getIndexRoot(), "file_inputs.data"));
                ourSharedFileContentIndependentInputs = IndexedStateMap.createMap(new File(PathManager.getIndexRoot(), "file_inputs_content_independent.data"));
                ourSharedContentInputs = IndexedStateMap.createMap(new File(IndexInfrastructure.getPersistentIndexRoot(), "content_inputs.data"));
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        this.close(ourSharedFileInputs);
                        this.close(ourSharedFileContentIndependentInputs);
                        this.close(ourSharedContentInputs);
                    }

                    private void close(IndexedStateMap index) {
                        try {
                            index.close();
                        }
                        catch (IOException ex) {
                            LOG.error((Throwable)ex);
                        }
                    }
                });
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/SharedIndicesData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "recallFileData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "recallContentData";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doRecallData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "associateFileData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "associateContentData";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "doAssociateData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class IndexedStateCache
    extends FileAccessorCache<Integer, IndexedState> {
        private final IndexedStateMap myStorage;

        IndexedStateCache(int protectedQueueSize, int probationalQueueSize, IndexedStateMap storage) {
            super(protectedQueueSize, probationalQueueSize);
            this.myStorage = storage;
        }

        @NotNull
        protected IndexedState createAccessor(Integer key) throws IOException {
            IndexedState indexedState = new IndexedState(key, this.myStorage);
            if (indexedState == null) {
                IndexedStateCache.$$$reportNull$$$0(0);
            }
            return indexedState;
        }

        protected void disposeAccessor(@NotNull IndexedState fileAccessor) throws IOException {
            if (fileAccessor == null) {
                IndexedStateCache.$$$reportNull$$$0(1);
            }
            fileAccessor.flush();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/SharedIndicesData$IndexedStateCache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAccessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAccessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/SharedIndicesData$IndexedStateCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeAccessor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class IndexedState {
        private final int fileOrContentId;
        private final PersistentHashMap<Integer, byte[]> storage;
        private byte[] values;
        private TIntLongHashMap indexId2Offset;
        private TIntObjectHashMap<byte[]> indexId2NewState;
        private boolean compactNecessary;

        IndexedState(int fileOrContentId, @NotNull PersistentHashMap<Integer, byte[]> storage) throws IOException {
            if (storage == null) {
                IndexedState.$$$reportNull$$$0(0);
            }
            this.fileOrContentId = fileOrContentId;
            this.storage = storage;
            byte[] bytes = (byte[])storage.get((Object)fileOrContentId);
            if (bytes == null) {
                return;
            }
            DataInputStream stream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));
            boolean compactNecessary = false;
            TIntLongHashMap stateMap = null;
            while (stream.available() > 0) {
                int chunkSize = DataInputOutputUtil.readINT((DataInput)stream);
                int chunkIndexId = DataInputOutputUtil.readINT((DataInput)stream);
                long chunkIndexTimeStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                int currentOffset = bytes.length - stream.available();
                ID chunkIndexID = ID.findById((int)chunkIndexId);
                if (chunkIndexID != null && chunkIndexTimeStamp == IndexingStamp.getIndexCreationStamp(chunkIndexID)) {
                    if (chunkSize != 0) {
                        if (stateMap == null) {
                            stateMap = new TIntLongHashMap();
                        }
                        stateMap.put(chunkIndexId, (long)currentOffset << 32 | (long)chunkSize);
                    } else if (stateMap != null) {
                        stateMap.remove(chunkIndexId);
                        compactNecessary = true;
                    }
                } else {
                    compactNecessary = true;
                }
                stream.skipBytes(chunkSize);
            }
            this.values = bytes;
            this.compactNecessary = compactNecessary;
            this.indexId2Offset = stateMap;
        }

        synchronized void flush() throws IOException {
            if (this.compactNecessary) {
                boolean result2;
                UnsyncByteArrayOutputStream compactedOutputStream = new UnsyncByteArrayOutputStream(this.values.length);
                DataOutputStream compactedOutput = new DataOutputStream((OutputStream)compactedOutputStream);
                Ref ioExceptionRef = new Ref();
                boolean bl = result2 = this.indexId2NewState == null || this.indexId2NewState.forEachEntry((arg_0, arg_1) -> IndexedState.lambda$flush$0((DataOutput)compactedOutput, ioExceptionRef, arg_0, arg_1));
                if (!result2) {
                    throw (IOException)ioExceptionRef.get();
                }
                boolean bl2 = result2 = this.indexId2Offset == null || this.indexId2Offset.forEachEntry((arg_0, arg_1) -> this.lambda$flush$1((DataOutput)compactedOutput, ioExceptionRef, arg_0, arg_1));
                if (!result2) {
                    throw (IOException)ioExceptionRef.get();
                }
                if (compactedOutputStream.size() > 0) {
                    this.storage.put((Object)this.fileOrContentId, (Object)compactedOutputStream.toByteArray());
                } else {
                    this.storage.remove((Object)this.fileOrContentId);
                }
            }
        }

        synchronized void appendIndexedState(@NotNull ID<?, ?> indexId, @Nullable byte[] buffer, int size) {
            if (indexId == null) {
                IndexedState.$$$reportNull$$$0(1);
            }
            int indexUniqueId = indexId.getUniqueId();
            if (this.indexId2Offset != null) {
                this.indexId2Offset.remove(indexUniqueId);
            }
            if (buffer == null) {
                if (this.indexId2NewState != null) {
                    this.indexId2NewState.remove(indexUniqueId);
                }
            } else {
                if (this.indexId2NewState == null) {
                    this.indexId2NewState = new TIntObjectHashMap();
                }
                this.indexId2NewState.put(indexUniqueId, (Object)Arrays.copyOf(buffer, size));
            }
        }

        @Nullable
        synchronized DataInputStream readIndexedState(@NotNull ID<?, ?> indexId) {
            if (indexId == null) {
                IndexedState.$$$reportNull$$$0(2);
            }
            int indexUniqueId = indexId.getUniqueId();
            int offset = 0;
            int length = 0;
            byte[] bytes = null;
            if (this.indexId2NewState != null) {
                bytes = (byte[])this.indexId2NewState.get(indexUniqueId);
                offset = 0;
                int n = length = bytes != null ? bytes.length : 0;
            }
            if (bytes == null) {
                if (this.values == null || this.indexId2Offset == null || !this.indexId2Offset.contains(indexUniqueId)) {
                    return null;
                }
                bytes = this.values;
                long offsetAndSize = this.indexId2Offset.get(indexUniqueId);
                offset = (int)(offsetAndSize >> 32);
                length = (int)offsetAndSize;
            }
            return new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes, offset, offset + length));
        }

        private /* synthetic */ boolean lambda$flush$1(DataOutput compactedOutput, Ref ioExceptionRef, int chunkIndexId, long chunkOffsetAndSize) {
            try {
                int chunkOffset = (int)(chunkOffsetAndSize >> 32);
                int chunkSize = (int)chunkOffsetAndSize;
                SharedIndicesData.writeIndexValue(chunkIndexId, IndexingStamp.getIndexCreationStamp(ID.findById((int)chunkIndexId)), this.values, chunkOffset, chunkSize, compactedOutput);
                return true;
            }
            catch (IOException e) {
                ioExceptionRef.set((Object)e);
                return false;
            }
        }

        private static /* synthetic */ boolean lambda$flush$0(DataOutput compactedOutput, Ref ioExceptionRef, int indexUniqueId, byte[] indexValue) {
            try {
                long indexCreationStamp = IndexingStamp.getIndexCreationStamp(ID.findById((int)indexUniqueId));
                SharedIndicesData.writeIndexValue(indexUniqueId, indexCreationStamp, indexValue, 0, indexValue.length, compactedOutput);
                return true;
            }
            catch (IOException ex) {
                ioExceptionRef.set((Object)ex);
                return false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/SharedIndicesData$IndexedState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendIndexedState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readIndexedState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IndexedStateMap
    extends PersistentHashMap<Integer, byte[]> {
        final IndexedStateCache myStateCache;

        IndexedStateMap(@NotNull File file2) throws IOException {
            if (file2 == null) {
                IndexedStateMap.$$$reportNull$$$0(0);
            }
            super(file2, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<byte[]>(){

                public void save(@NotNull DataOutput out, byte[] value) throws IOException {
                    if (out == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    out.write(value);
                }

                public byte[] read(@NotNull DataInput in) throws IOException {
                    if (in == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    int available = ((InputStream)((Object)in)).available();
                    byte[] result2 = new byte[available];
                    in.readFully(result2);
                    return result2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "out";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "in";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/util/indexing/SharedIndicesData$IndexedStateMap$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "save";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "read";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.myStateCache = new IndexedStateCache(200, 100, this);
        }

        protected void doDropMemoryCaches() {
            if (this.myStateCache != null) {
                this.myStateCache.clear();
            }
            super.doDropMemoryCaches();
        }

        protected void doForce() {
            if (this.myStateCache != null) {
                this.myStateCache.clear();
            }
            super.doForce();
        }

        static IndexedStateMap createMap(File indexFile) throws IOException {
            return (IndexedStateMap)((Object)IOUtil.openCleanOrResetBroken(() -> new IndexedStateMap(indexFile), (File)indexFile));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/SharedIndicesData$IndexedStateMap", "<init>"));
        }
    }
}

